/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public class GeneratePluginDescriptors
extends DefaultTask {
    private final ListProperty<PluginDeclaration> declarations;
    private final Provider<Map<String, String>> implementationClassById;
    private final DirectoryProperty outputDirectory;

    public GeneratePluginDescriptors() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.declarations = objectFactory.listProperty(PluginDeclaration.class);
        this.outputDirectory = objectFactory.directoryProperty();
        this.implementationClassById = this.getDeclarations().map(declarations -> declarations.stream().collect(Collectors.toMap(PluginDeclaration::getId, PluginDeclaration::getImplementationClass, (a, b) -> b, LinkedHashMap::new)));
    }

    @Internal(value="Changes for the declarations are tracked via implementationClassById")
    public ListProperty<PluginDeclaration> getDeclarations() {
        return this.declarations;
    }

    @Input
    Provider<Map<String, String>> getImplementationClassById() {
        return this.implementationClassById;
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void generatePluginDescriptors() {
        File outputDir = ((Directory)this.outputDirectory.get()).getAsFile();
        this.clearOutputDirectory(outputDir);
        for (Map.Entry<String, String> entry : this.implementationClassById.get().entrySet()) {
            String id = entry.getKey();
            String implementationClass = entry.getValue();
            File descriptorFile = new File(outputDir, id + ".properties");
            Properties properties = new Properties();
            properties.setProperty("implementation-class", implementationClass);
            this.writePropertiesTo(properties, descriptorFile);
        }
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    private void clearOutputDirectory(File directoryToClear) {
        try {
            this.getDeleter().ensureEmptyDirectory(directoryToClear);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writePropertiesTo(Properties properties, File descriptorFile) {
        try {
            PropertiesUtils.store(properties, descriptorFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

