/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.install.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkCacheDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkCacheDirectory.class);
    private static final String MARKER_FILE = "provisioned.ok";
    private static final String MAC_OS_JAVA_HOME_FOLDER = "Contents/Home";
    private final FileOperations operations;
    private final File jdkDirectory;
    private final FileLockManager lockManager;

    public JdkCacheDirectory(GradleUserHomeDirProvider homeDirProvider, FileOperations operations, FileLockManager lockManager) {
        this.operations = operations;
        this.jdkDirectory = new File(homeDirProvider.getGradleUserHomeDirectory(), "jdks");
        this.lockManager = lockManager;
        this.jdkDirectory.mkdir();
    }

    public Set<File> listJavaHomes() {
        File[] candidates = this.jdkDirectory.listFiles();
        if (candidates != null) {
            return Arrays.stream(candidates).flatMap(this::markedLocations).map(this::getJavaHome).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Stream<File> markedLocations(File candidate) {
        if (this.isMarkedLocation(candidate)) {
            return Stream.of(candidate);
        }
        File[] subFolders = candidate.listFiles();
        if (subFolders == null) {
            return Stream.empty();
        }
        return Arrays.stream(subFolders).filter(this::isMarkedLocation);
    }

    private boolean isMarkedLocation(File candidate) {
        return candidate.isDirectory() && new File(candidate, MARKER_FILE).exists();
    }

    private File getJavaHome(File markedLocation) {
        if (OperatingSystem.current().isMacOsX()) {
            if (new File(markedLocation, MAC_OS_JAVA_HOME_FOLDER).exists()) {
                return new File(markedLocation, MAC_OS_JAVA_HOME_FOLDER);
            }
            File[] subfolders = markedLocation.listFiles(File::isDirectory);
            if (subfolders != null) {
                for (File subfolder : subfolders) {
                    if (!new File(subfolder, MAC_OS_JAVA_HOME_FOLDER).exists()) continue;
                    return new File(subfolder, MAC_OS_JAVA_HOME_FOLDER);
                }
            }
        }
        return markedLocation;
    }

    public File provisionFromArchive(File jdkArchive) {
        File destination = this.unpack(jdkArchive);
        File markedLocation = this.markJavaHome(destination);
        return this.getJavaHome(markedLocation);
    }

    private File unpack(File jdkArchive) {
        FileTree fileTree = this.asFileTree(jdkArchive);
        String installRootName = JdkCacheDirectory.getNameWithoutExtension(jdkArchive);
        File installLocation = new File(this.jdkDirectory, installRootName);
        if (!installLocation.exists()) {
            this.operations.copy(spec -> {
                spec.from(fileTree);
                spec.into(installLocation);
            });
            LOGGER.info("Installed {} into {}", (Object)jdkArchive.getName(), (Object)installLocation);
        }
        return installLocation;
    }

    private File markJavaHome(File installLocation) {
        File[] content = installLocation.listFiles();
        if (content == null) {
            throw new RuntimeException("Programming error");
        }
        for (File file : content) {
            if (!file.isDirectory()) continue;
            this.markAsReady(file);
            return file;
        }
        return this.markAsReady(installLocation);
    }

    private File markAsReady(File destination) {
        try {
            new File(destination, MARKER_FILE).createNewFile();
            return destination;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create .ok file", e);
        }
    }

    private FileTree asFileTree(File jdkArchive) {
        String extension = FilenameUtils.getExtension((String)jdkArchive.getName());
        if (Objects.equals(extension, "zip")) {
            return this.operations.zipTree(jdkArchive);
        }
        return this.operations.tarTree(this.operations.getResources().gzip(jdkArchive));
    }

    public FileLock acquireWriteLock(File destinationFile, String operationName) {
        return this.lockManager.lock(destinationFile, LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive), destinationFile.getName(), operationName);
    }

    public File getDownloadLocation(String filename) {
        return new File(this.jdkDirectory, filename);
    }

    private static String getNameWithoutExtension(File file) {
        String input;
        String output = file.getName();
        while (!(input = output).equals(output = Files.getNameWithoutExtension((String)input))) {
        }
        return output;
    }
}

