/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.install.internal;

import java.io.File;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.install.internal.AdoptOpenJdkDownloader;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;

public class AdoptOpenJdkRemoteBinary {
    private static final String DEFAULT_ADOPTOPENJDK_ROOT_URL = "https://api.adoptopenjdk.net/";
    private static final String DEFAULT_ADOPTIUM_ROOT_URL = "https://api.adoptium.net/";
    private final SystemInfo systemInfo;
    private final OperatingSystem operatingSystem;
    private final AdoptOpenJdkDownloader downloader;
    private final Provider<String> adoptOpenJdkRootUrl;
    private final Provider<String> adoptiumRootUrl;

    @Inject
    public AdoptOpenJdkRemoteBinary(SystemInfo systemInfo, OperatingSystem operatingSystem, AdoptOpenJdkDownloader downloader, ProviderFactory providerFactory) {
        this.systemInfo = systemInfo;
        this.operatingSystem = operatingSystem;
        this.downloader = downloader;
        this.adoptOpenJdkRootUrl = providerFactory.gradleProperty("org.gradle.jvm.toolchain.install.adoptopenjdk.baseUri");
        this.adoptiumRootUrl = providerFactory.gradleProperty("org.gradle.jvm.toolchain.install.adoptium.baseUri");
    }

    public Optional<File> download(JavaToolchainSpec spec, File destinationFile) {
        if (!this.canProvideMatchingJdk(spec)) {
            return Optional.empty();
        }
        URI source = this.toDownloadUri(spec);
        this.downloader.download(source, destinationFile);
        return Optional.of(destinationFile);
    }

    public boolean canProvideMatchingJdk(JavaToolchainSpec spec) {
        boolean matchesLanguageVersion = AdoptOpenJdkRemoteBinary.determineLanguageVersion(spec).canCompileOrRun(8);
        boolean matchesVendor = this.matchesVendor(spec);
        return matchesLanguageVersion && matchesVendor;
    }

    private boolean matchesVendor(JavaToolchainSpec spec) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        if (vendorSpec == DefaultJvmVendorSpec.any()) {
            return true;
        }
        if (vendorSpec.test(JvmVendor.KnownJvmVendor.ADOPTOPENJDK.asJvmVendor())) {
            DeprecationLogger.deprecateBehaviour("Due to changes in AdoptOpenJDK download endpoint, downloading a JDK with an explicit vendor of AdoptOpenJDK should be replaced with a spec without a vendor or using Eclipse Temurin / IBM Semeru.").willBeRemovedInGradle8().withUpgradeGuideSection(7, "adoptopenjdk_download").nagUser();
            return true;
        }
        if (vendorSpec.test(JvmVendor.KnownJvmVendor.ADOPTIUM.asJvmVendor()) && !AdoptOpenJdkRemoteBinary.isJ9ExplicitlyRequested(spec)) {
            return true;
        }
        return vendorSpec.test(JvmVendor.KnownJvmVendor.IBM_SEMERU.asJvmVendor());
    }

    URI toDownloadUri(JavaToolchainSpec spec) {
        return this.constructUri(spec);
    }

    private URI constructUri(JavaToolchainSpec spec) {
        return URI.create(this.determineServerBaseUri(spec) + "v3/binary/latest/" + AdoptOpenJdkRemoteBinary.determineLanguageVersion(spec) + "/" + AdoptOpenJdkRemoteBinary.determineReleaseState() + "/" + this.determineOs() + "/" + this.determineArch() + "/jdk/" + AdoptOpenJdkRemoteBinary.determineImplementation(spec) + "/normal/" + AdoptOpenJdkRemoteBinary.determineOrganization(spec));
    }

    private static String determineImplementation(JavaToolchainSpec spec) {
        return AdoptOpenJdkRemoteBinary.isJ9Requested(spec) ? "openj9" : "hotspot";
    }

    private String determineVendor(JavaToolchainSpec spec) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        if (vendorSpec == DefaultJvmVendorSpec.any()) {
            return "adoptium";
        }
        return vendorSpec.toString().toLowerCase();
    }

    public String toFilename(JavaToolchainSpec spec) {
        return String.format("%s-%s-%s-%s-%s.%s", this.determineVendor(spec), AdoptOpenJdkRemoteBinary.determineLanguageVersion(spec), this.determineArch(), AdoptOpenJdkRemoteBinary.determineImplementation(spec), this.determineOs(), this.determineFileExtension());
    }

    private String determineFileExtension() {
        if (this.operatingSystem.isWindows()) {
            return "zip";
        }
        return "tar.gz";
    }

    private static JavaLanguageVersion determineLanguageVersion(JavaToolchainSpec spec) {
        return (JavaLanguageVersion)spec.getLanguageVersion().get();
    }

    private String determineArch() {
        switch (this.systemInfo.getArchitecture()) {
            case i386: {
                return "x32";
            }
            case amd64: {
                return "x64";
            }
            case aarch64: {
                return "aarch64";
            }
        }
        return this.systemInfo.getArchitectureName();
    }

    private String determineOs() {
        if (this.operatingSystem.isWindows()) {
            return "windows";
        }
        if (this.operatingSystem.isMacOsX()) {
            return "mac";
        }
        if (this.operatingSystem.isLinux()) {
            return "linux";
        }
        return this.operatingSystem.getFamilyName();
    }

    private static String determineReleaseState() {
        return "ga";
    }

    private String determineServerBaseUri(JavaToolchainSpec spec) {
        String baseUri;
        String string2 = baseUri = AdoptOpenJdkRemoteBinary.adoptiumHasIt(spec) ? this.adoptiumRootUrl.getOrElse(DEFAULT_ADOPTIUM_ROOT_URL) : this.adoptOpenJdkRootUrl.getOrElse(DEFAULT_ADOPTOPENJDK_ROOT_URL);
        if (!baseUri.endsWith("/")) {
            baseUri = baseUri + "/";
        }
        return baseUri;
    }

    private static String determineOrganization(JavaToolchainSpec spec) {
        return AdoptOpenJdkRemoteBinary.adoptiumHasIt(spec) ? "eclipse" : "adoptopenjdk";
    }

    private static boolean adoptiumHasIt(JavaToolchainSpec spec) {
        if (AdoptOpenJdkRemoteBinary.isJ9Requested(spec)) {
            return false;
        }
        int version = AdoptOpenJdkRemoteBinary.determineLanguageVersion(spec).asInt();
        return version == 8 || version == 11 || version >= 16;
    }

    private static boolean isJ9Requested(JavaToolchainSpec spec) {
        if (AdoptOpenJdkRemoteBinary.isJ9ExplicitlyRequested(spec)) {
            return true;
        }
        return AdoptOpenJdkRemoteBinary.isJ9RequestedViaVendor(spec);
    }

    private static boolean isJ9ExplicitlyRequested(JavaToolchainSpec spec) {
        return spec.getImplementation().get() == JvmImplementation.J9;
    }

    private static boolean isJ9RequestedViaVendor(JavaToolchainSpec spec) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        return vendorSpec != DefaultJvmVendorSpec.any() && vendorSpec.test(JvmVendor.KnownJvmVendor.IBM_SEMERU.asJvmVendor());
    }
}

