/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class Int2ObjectMapSerializer<V>
extends AbstractSerializer<Map<Integer, ? extends V>> {
    private final Serializer<Integer> keySerializer = new DefaultSerializer<Integer>();
    private final Serializer<V> valueSerializer;

    public Int2ObjectMapSerializer(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public Map<Integer, V> read(Decoder decoder) throws Exception {
        int size = decoder.readInt();
        Int2ObjectOpenHashMap valueMap = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            Integer key = this.keySerializer.read(decoder);
            V value = this.valueSerializer.read(decoder);
            valueMap.put(key, value);
        }
        return valueMap;
    }

    @Override
    public void write(Encoder encoder, Map<Integer, ? extends V> value) throws Exception {
        encoder.writeInt(value.size());
        for (Map.Entry<Integer, V> entry : value.entrySet()) {
            this.keySerializer.write(encoder, entry.getKey());
            this.valueSerializer.write(encoder, entry.getValue());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Int2ObjectMapSerializer rhs = (Int2ObjectMapSerializer)obj;
        return Objects.equal(this.valueSerializer, rhs.valueSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.keySerializer, this.valueSerializer});
    }
}

