/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.isolated;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.reflect.TypeToken;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.process.ExecOperations;

public class IsolationScheme<IMPLEMENTATION, PARAMS> {
    private final Class<IMPLEMENTATION> interfaceType;
    private final Class<PARAMS> paramsType;
    private final Class<? extends PARAMS> noParamsType;

    public IsolationScheme(Class<IMPLEMENTATION> interfaceType, Class<PARAMS> paramsType, Class<? extends PARAMS> noParamsType) {
        this.interfaceType = interfaceType;
        this.paramsType = paramsType;
        this.noParamsType = noParamsType;
    }

    @Nullable
    public <T extends IMPLEMENTATION, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType) {
        return this.parameterTypeFor(implementationType, 0);
    }

    @Nullable
    public <T extends IMPLEMENTATION, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType, int typeArgumentIndex) {
        if (implementationType == this.interfaceType) {
            return null;
        }
        Class<P> parametersType = this.inferParameterType(implementationType, typeArgumentIndex);
        if (parametersType == this.paramsType) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not create the parameters for ");
            formatter.appendType(implementationType);
            formatter.append(": must use a sub-type of ");
            formatter.appendType(parametersType);
            formatter.append(" as the parameters type. Use ");
            formatter.appendType(this.noParamsType);
            formatter.append(" as the parameters type for implementations that do not take parameters.");
            throw new IllegalArgumentException(formatter.toString());
        }
        if (parametersType == this.noParamsType) {
            return null;
        }
        return parametersType;
    }

    @Nonnull
    private <T extends IMPLEMENTATION, P extends PARAMS> Class<P> inferParameterType(Class<T> implementationType, int typeArgumentIndex) {
        for (Type superType : implementationType.getGenericInterfaces()) {
            Type argument;
            ParameterizedType parameterizedSuperType;
            if (!(superType instanceof ParameterizedType) || !(parameterizedSuperType = (ParameterizedType)superType).getRawType().equals(this.interfaceType) || !((argument = parameterizedSuperType.getActualTypeArguments()[typeArgumentIndex]) instanceof Class)) continue;
            return (Class)Cast.uncheckedCast(argument);
        }
        ParameterizedType superType = (ParameterizedType)TypeToken.of(implementationType).getSupertype(this.interfaceType).getType();
        return (Class)Cast.uncheckedNonnullCast(TypeToken.of((Type)superType.getActualTypeArguments()[typeArgumentIndex]).getRawType());
    }

    public ServiceLookup servicesForImplementation(@Nullable PARAMS params, ServiceLookup allServices) {
        return this.servicesForImplementation(params, allServices, Collections.emptyList(), c -> false);
    }

    public ServiceLookup servicesForImplementation(@Nullable PARAMS params, ServiceLookup allServices, Collection<? extends Class<?>> additionalWhiteListedServices, Spec<Class<?>> whiteListPolicy) {
        return new ServicesForIsolatedObject(this.interfaceType, this.noParamsType, params, allServices, additionalWhiteListedServices, whiteListPolicy);
    }

    private static class ServicesForIsolatedObject
    implements ServiceLookup {
        private final Class<?> interfaceType;
        private final Class<?> noParamsType;
        private final Collection<? extends Class<?>> additionalWhiteListedServices;
        private final ServiceLookup allServices;
        private final Object params;
        private final Spec<Class<?>> whiteListPolicy;

        public ServicesForIsolatedObject(Class<?> interfaceType, Class<?> noParamsType, @Nullable Object params, ServiceLookup allServices, Collection<? extends Class<?>> additionalWhiteListedServices, Spec<Class<?>> whiteListPolicy) {
            this.interfaceType = interfaceType;
            this.noParamsType = noParamsType;
            this.additionalWhiteListedServices = additionalWhiteListedServices;
            this.allServices = allServices;
            this.params = params;
            this.whiteListPolicy = whiteListPolicy;
        }

        @Override
        @Nullable
        public Object find(Type serviceType) throws ServiceLookupException {
            if (serviceType instanceof Class) {
                Class serviceClass = (Class)Cast.uncheckedNonnullCast(serviceType);
                if (serviceClass.isInstance(this.params)) {
                    return this.params;
                }
                if (serviceClass.isAssignableFrom(this.noParamsType)) {
                    throw new ServiceLookupException(String.format("Cannot query the parameters of an instance of %s that takes no parameters.", this.interfaceType.getSimpleName()));
                }
                if (serviceClass.isAssignableFrom(ExecOperations.class)) {
                    return this.allServices.find((Type)((Object)ExecOperations.class));
                }
                if (serviceClass.isAssignableFrom(FileSystemOperations.class)) {
                    return this.allServices.find((Type)((Object)FileSystemOperations.class));
                }
                if (serviceClass.isAssignableFrom(ArchiveOperations.class)) {
                    return this.allServices.find((Type)((Object)ArchiveOperations.class));
                }
                if (serviceClass.isAssignableFrom(ObjectFactory.class)) {
                    return this.allServices.find((Type)((Object)ObjectFactory.class));
                }
                if (serviceClass.isAssignableFrom(ProviderFactory.class)) {
                    return this.allServices.find((Type)((Object)ProviderFactory.class));
                }
                for (Class<?> whiteListedService : this.additionalWhiteListedServices) {
                    if (!serviceClass.isAssignableFrom(whiteListedService)) continue;
                    return this.allServices.find(whiteListedService);
                }
                if (this.whiteListPolicy.isSatisfiedBy(serviceClass)) {
                    return this.allServices.find(serviceClass);
                }
            }
            return null;
        }

        @Override
        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result2 = this.find(serviceType);
            if (result2 == null) {
                this.notFound(serviceType);
            }
            return result2;
        }

        @Override
        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            return this.notFound(serviceType);
        }

        private Object notFound(Type serviceType) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Services of type ");
            formatter.appendType(serviceType);
            formatter.append(" are not available for injection into instances of type ");
            formatter.appendType(this.interfaceType);
            formatter.append(".");
            throw new UnknownServiceException(serviceType, formatter.toString());
        }
    }
}

