/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.DefaultRegularFileSnapshotContext;
import org.gradle.api.internal.changedetection.state.IgnoringResourceHasher;
import org.gradle.api.internal.changedetection.state.LineEndingNormalizingResourceHasher;
import org.gradle.api.internal.changedetection.state.MetaInfAwareClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.PropertiesFileAwareClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.RuntimeClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipHasher;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class ClasspathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    private final NonJarFingerprintingStrategy nonZipFingerprintingStrategy;
    private final ResourceSnapshotterCacheService cacheService;
    private final ResourceHasher classpathResourceHasher;
    private final ZipHasher zipHasher;
    private final Interner<String> stringInterner;
    private final HashCode zipHasherConfigurationHash;

    private ClasspathFingerprintingStrategy(String identifier, NonJarFingerprintingStrategy nonZipFingerprintingStrategy, ResourceHasher classpathResourceHasher, ZipHasher zipHasher, ResourceSnapshotterCacheService cacheService, Interner<String> stringInterner) {
        super(identifier, zipHasher);
        this.nonZipFingerprintingStrategy = nonZipFingerprintingStrategy;
        this.classpathResourceHasher = classpathResourceHasher;
        this.cacheService = cacheService;
        this.stringInterner = stringInterner;
        this.zipHasher = zipHasher;
        Hasher hasher = Hashing.newHasher();
        zipHasher.appendConfigurationToHasher(hasher);
        this.zipHasherConfigurationHash = hasher.hash();
    }

    public static ClasspathFingerprintingStrategy runtimeClasspath(ResourceFilter classpathResourceFilter, ResourceEntryFilter manifestAttributeResourceEntryFilter, Map<String, ResourceEntryFilter> propertiesFileFilters, RuntimeClasspathResourceHasher runtimeClasspathResourceHasher, ResourceSnapshotterCacheService cacheService, Interner<String> stringInterner, LineEndingSensitivity lineEndingSensitivity) {
        ResourceHasher resourceHasher = LineEndingNormalizingResourceHasher.wrap(runtimeClasspathResourceHasher, lineEndingSensitivity);
        resourceHasher = ClasspathFingerprintingStrategy.propertiesFileHasher(resourceHasher, propertiesFileFilters);
        resourceHasher = ClasspathFingerprintingStrategy.metaInfAwareClasspathResourceHasher(resourceHasher, manifestAttributeResourceEntryFilter);
        resourceHasher = ClasspathFingerprintingStrategy.ignoringResourceHasher(resourceHasher, classpathResourceFilter);
        ZipHasher zipHasher = new ZipHasher(resourceHasher);
        return new ClasspathFingerprintingStrategy("CLASSPATH", NonJarFingerprintingStrategy.USE_FILE_HASH, resourceHasher, zipHasher, cacheService, stringInterner);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher classpathResourceHasher, ResourceSnapshotterCacheService cacheService, Interner<String> stringInterner) {
        ZipHasher zipHasher = new ZipHasher(classpathResourceHasher);
        return new ClasspathFingerprintingStrategy("COMPILE_CLASSPATH", NonJarFingerprintingStrategy.IGNORE, classpathResourceHasher, zipHasher, cacheService, stringInterner);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher classpathResourceHasher, ResourceSnapshotterCacheService cacheService, Interner<String> stringInterner, ZipHasher.HashingExceptionReporter hashingExceptionReporter) {
        ZipHasher zipHasher = new ZipHasher(classpathResourceHasher, hashingExceptionReporter);
        return new ClasspathFingerprintingStrategy("COMPILE_CLASSPATH", NonJarFingerprintingStrategy.IGNORE, classpathResourceHasher, zipHasher, cacheService, stringInterner);
    }

    private static ResourceHasher ignoringResourceHasher(ResourceHasher delegate, ResourceFilter resourceFilter) {
        return new IgnoringResourceHasher(delegate, resourceFilter);
    }

    private static ResourceHasher propertiesFileHasher(ResourceHasher delegate, Map<String, ResourceEntryFilter> propertiesFileFilters) {
        return new PropertiesFileAwareClasspathResourceHasher(delegate, propertiesFileFilters);
    }

    private static ResourceHasher metaInfAwareClasspathResourceHasher(ResourceHasher delegate, ResourceEntryFilter manifestAttributeResourceEntryFilter) {
        return new MetaInfAwareClasspathResourceHasher(delegate, manifestAttributeResourceEntryFilter);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot roots) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<String> processedEntries = new HashSet<String>();
        roots.accept(new RelativePathTracker(), new ClasspathFingerprintingVisitor(processedEntries, (ImmutableMap.Builder<String, FileSystemLocationFingerprint>)builder));
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.KEEP_ORDER;
    }

    private class ClasspathFingerprintingVisitor
    implements RelativePathTrackingFileSystemSnapshotHierarchyVisitor {
        private final HashSet<String> processedEntries;
        private final ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder;

        public ClasspathFingerprintingVisitor(HashSet<String> processedEntries, ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder) {
            this.processedEntries = processedEntries;
            this.builder = builder;
        }

        @Override
        public SnapshotVisitResult visitEntry(final FileSystemLocationSnapshot snapshot, final RelativePathSupplier relativePath) {
            snapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                @Override
                public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
                    FileSystemLocationFingerprint fingerprint;
                    HashCode normalizedContentHash = ClasspathFingerprintingVisitor.this.hashContent(fileSnapshot, relativePath);
                    if (normalizedContentHash == null) {
                        return;
                    }
                    String absolutePath = snapshot.getAbsolutePath();
                    if (!ClasspathFingerprintingVisitor.this.processedEntries.add(absolutePath)) {
                        return;
                    }
                    if (relativePath.isRoot()) {
                        fingerprint = IgnoredPathFileSystemLocationFingerprint.create(snapshot.getType(), normalizedContentHash);
                    } else {
                        String internedRelativePath = (String)ClasspathFingerprintingStrategy.this.stringInterner.intern((Object)relativePath.toRelativePath());
                        fingerprint = new DefaultFileSystemLocationFingerprint(internedRelativePath, FileType.RegularFile, normalizedContentHash);
                    }
                    ClasspathFingerprintingVisitor.this.builder.put((Object)absolutePath, (Object)fingerprint);
                }

                @Override
                public void visitMissing(MissingFileSnapshot missingSnapshot) {
                    if (!relativePath.isRoot()) {
                        throw new RuntimeException(String.format("Couldn't read file content: '%s'.", missingSnapshot.getAbsolutePath()));
                    }
                }
            });
            return SnapshotVisitResult.CONTINUE;
        }

        @Nullable
        private HashCode hashContent(RegularFileSnapshot fileSnapshot, RelativePathSupplier relativePath) {
            DefaultRegularFileSnapshotContext fileSnapshotContext = new DefaultRegularFileSnapshotContext(() -> (String[])Iterables.toArray(relativePath.getSegments(), String.class), fileSnapshot);
            try {
                if (ZipHasher.isZipFile(fileSnapshotContext.getSnapshot().getName())) {
                    return ClasspathFingerprintingStrategy.this.cacheService.hashFile(fileSnapshotContext, ClasspathFingerprintingStrategy.this.zipHasher, ClasspathFingerprintingStrategy.this.zipHasherConfigurationHash);
                }
                if (relativePath.isRoot()) {
                    return ClasspathFingerprintingStrategy.this.nonZipFingerprintingStrategy.determineNonJarFingerprint(fileSnapshot.getHash());
                }
                return ClasspathFingerprintingStrategy.this.classpathResourceHasher.hash(fileSnapshotContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(this.failedToNormalize(fileSnapshot), e);
            }
            catch (UncheckedIOException e) {
                throw new UncheckedIOException(this.failedToNormalize(fileSnapshot), e.getCause());
            }
        }

        private String failedToNormalize(RegularFileSnapshot snapshot) {
            return String.format("Failed to normalize content of '%s'.", snapshot.getAbsolutePath());
        }
    }

    public static enum NonJarFingerprintingStrategy {
        IGNORE{

            @Override
            @Nullable
            public HashCode determineNonJarFingerprint(HashCode original) {
                return null;
            }
        }
        ,
        USE_FILE_HASH{

            @Override
            public HashCode determineNonJarFingerprint(HashCode original) {
                return original;
            }
        };


        @Nullable
        public abstract HashCode determineNonJarFingerprint(HashCode var1);
    }
}

