/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint;

import java.util.Collection;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public enum FingerprintHashingStrategy {
    SORT{

        @Override
        public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
            ImmutableList sortedFingerprints = ImmutableList.sortedCopyOf(fingerprints);
            this.appendCollectionToHasherKeepingOrder(hasher, (Collection<FileSystemLocationFingerprint>)sortedFingerprints);
        }
    }
    ,
    KEEP_ORDER{

        @Override
        public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
            this.appendCollectionToHasherKeepingOrder(hasher, fingerprints);
        }
    };


    public abstract void appendToHasher(Hasher var1, Collection<FileSystemLocationFingerprint> var2);

    protected void appendCollectionToHasherKeepingOrder(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
        for (FileSystemLocationFingerprint fingerprint : fingerprints) {
            fingerprint.appendToHasher(hasher);
        }
    }
}

