/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.external.model.ShadowedCapabilityOnly;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class ImmutableCapabilities
implements CapabilitiesMetadata {
    public static final ImmutableCapabilities EMPTY = new ImmutableCapabilities((ImmutableList<? extends Capability>)ImmutableList.of());
    private final ImmutableList<? extends Capability> capabilities;

    public static ImmutableCapabilities of(CapabilitiesMetadata capabilities) {
        if (capabilities instanceof ImmutableCapabilities) {
            return (ImmutableCapabilities)capabilities;
        }
        return ImmutableCapabilities.of(capabilities.getCapabilities());
    }

    public static ImmutableCapabilities of(@Nullable Collection<? extends Capability> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return EMPTY;
        }
        if (capabilities.size() == 1) {
            Capability single = capabilities.iterator().next();
            return ImmutableCapabilities.of(single);
        }
        return new ImmutableCapabilities((ImmutableList<? extends Capability>)ImmutableList.copyOf(capabilities));
    }

    public static ImmutableCapabilities of(@Nullable Capability capability) {
        if (capability == null) {
            return EMPTY;
        }
        if (capability instanceof ShadowedCapability) {
            return new ShadowedSingleImmutableCapabilities(capability);
        }
        return new ImmutableCapabilities((ImmutableList<? extends Capability>)ImmutableList.of((Object)capability));
    }

    public ImmutableCapabilities(ImmutableList<? extends Capability> capabilities) {
        this.capabilities = capabilities;
    }

    public static ImmutableCapabilities copyAsImmutable(Collection<? extends Capability> capabilities) {
        if (capabilities.isEmpty()) {
            return EMPTY;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Capability capability : capabilities) {
            if (capability instanceof ImmutableCapability) {
                builder.add((Object)((ImmutableCapability)capability));
                continue;
            }
            if (capability instanceof ShadowedCapability) {
                builder.add((Object)((ShadowedCapability)capability));
                continue;
            }
            builder.add((Object)new ImmutableCapability(capability.getGroup(), capability.getName(), capability.getVersion()));
        }
        return ImmutableCapabilities.of((Collection<? extends Capability>)builder.build());
    }

    @Override
    public List<? extends Capability> getCapabilities() {
        return this.capabilities;
    }

    private static class ShadowedSingleImmutableCapabilities
    extends ImmutableCapabilities
    implements ShadowedCapabilityOnly {
        public ShadowedSingleImmutableCapabilities(Capability single) {
            super((ImmutableList<? extends Capability>)ImmutableList.of((Object)single));
        }
    }
}

