/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.ivypublish;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.internal.Pair;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.ivypublish.DefaultIvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.internal.CollectionUtils;

public class DefaultIvyModulePublishMetadata
implements IvyModulePublishMetadata {
    private static final Transformer<String, String> VERSION_TRANSFORMER = new IvyVersionTransformer();
    private final ModuleComponentIdentifier id;
    private final String status;
    private final Map<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetadata> artifactsById = new LinkedHashMap<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetadata>();
    private final Map<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();
    private final Set<LocalOriginDependencyMetadata> dependencies = new LinkedHashSet<LocalOriginDependencyMetadata>();
    private final List<Pair<ExcludeMetadata, String>> excludes = Lists.newArrayList();

    public DefaultIvyModulePublishMetadata(ModuleComponentIdentifier id, String status) {
        this.id = id;
        this.status = status;
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return this.id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Map<String, Configuration> getConfigurations() {
        return this.configurations;
    }

    @Override
    public Collection<LocalOriginDependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Pair<ExcludeMetadata, String>> getExcludes() {
        return this.excludes;
    }

    public BuildableLocalConfigurationMetadata addConfiguration(String name, Set<String> extendsFrom, boolean visible, boolean transitive) {
        ArrayList sortedExtends = Lists.newArrayList(extendsFrom);
        Collections.sort(sortedExtends);
        Configuration configuration2 = new Configuration(name, transitive, visible, sortedExtends);
        this.configurations.put(name, configuration2);
        return new ConfigurationMetadata(name);
    }

    private static LocalOriginDependencyMetadata normalizeVersionForIvy(LocalOriginDependencyMetadata dependency) {
        if (dependency.getSelector() instanceof ModuleComponentSelector) {
            ModuleComponentSelector selector = (ModuleComponentSelector)dependency.getSelector();
            VersionConstraint versionConstraint = selector.getVersionConstraint();
            DefaultImmutableVersionConstraint transformedConstraint = new DefaultImmutableVersionConstraint(VERSION_TRANSFORMER.transform(versionConstraint.getPreferredVersion()), VERSION_TRANSFORMER.transform(versionConstraint.getRequiredVersion()), VERSION_TRANSFORMER.transform(versionConstraint.getStrictVersion()), CollectionUtils.collect(versionConstraint.getRejectedVersions(), VERSION_TRANSFORMER), versionConstraint.getBranch());
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), transformedConstraint, selector.getAttributes(), selector.getRequestedCapabilities());
            return dependency.withTarget(newSelector);
        }
        return dependency;
    }

    public void addArtifact(IvyArtifactName artifact, File file) {
        DefaultIvyModuleArtifactPublishMetadata publishMetadata = new DefaultIvyModuleArtifactPublishMetadata(this.id, artifact);
        publishMetadata.setFile(file);
        this.artifactsById.put(publishMetadata.getId(), publishMetadata);
    }

    public void addArtifact(IvyModuleArtifactPublishMetadata artifact) {
        this.artifactsById.put(artifact.getId(), artifact);
    }

    private DefaultIvyModuleArtifactPublishMetadata getOrCreate(IvyArtifactName ivyName) {
        for (IvyModuleArtifactPublishMetadata artifactPublishMetadata : this.artifactsById.values()) {
            if (!artifactPublishMetadata.getArtifactName().equals(ivyName)) continue;
            return (DefaultIvyModuleArtifactPublishMetadata)artifactPublishMetadata;
        }
        DefaultIvyModuleArtifactPublishMetadata artifact = new DefaultIvyModuleArtifactPublishMetadata(this.id, ivyName);
        this.artifactsById.put(artifact.getId(), artifact);
        return artifact;
    }

    @Override
    public Collection<IvyModuleArtifactPublishMetadata> getArtifacts() {
        return this.artifactsById.values();
    }

    public void addArtifact(String configuration2, PublishArtifact artifact) {
        DefaultIvyArtifactName ivyName = DefaultIvyArtifactName.forPublishArtifact(artifact);
        DefaultIvyModuleArtifactPublishMetadata ivyArtifact = this.getOrCreate(ivyName);
        ivyArtifact.setFile(artifact.getFile());
        ivyArtifact.addConfiguration(configuration2);
    }

    private static class IvyVersionTransformer
    implements Transformer<String, String> {
        private IvyVersionTransformer() {
        }

        @Override
        public String transform(String version) {
            if (version != null && version.startsWith("[") && version.endsWith("]") && version.indexOf(44) == -1) {
                return version.substring(1, version.length() - 1);
            }
            return version;
        }
    }

    private class ConfigurationMetadata
    implements BuildableLocalConfigurationMetadata {
        private final String configurationName;

        private ConfigurationMetadata(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return DefaultIvyModulePublishMetadata.this.id;
        }

        @Override
        public void addDependency(LocalOriginDependencyMetadata dependency) {
            assert (dependency.getModuleConfiguration().equals(this.configurationName));
            DefaultIvyModulePublishMetadata.this.dependencies.add(DefaultIvyModulePublishMetadata.normalizeVersionForIvy(dependency));
        }

        @Override
        public void addExclude(ExcludeMetadata exclude) {
            DefaultIvyModulePublishMetadata.this.excludes.add(Pair.of(exclude, this.configurationName));
        }

        @Override
        public void addFiles(LocalFileDependencyMetadata files) {
        }

        @Override
        public void enableLocking() {
        }
    }
}

