/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.callsite.AbstractCallSite;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.wrappers.Wrapper;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classpath.AccessTrackingEnvMap;
import org.gradle.internal.classpath.AccessTrackingProperties;

public class Instrumented {
    private static final Listener NO_OP = new Listener(){

        @Override
        public void systemPropertyQueried(String key, @Nullable Object value, String consumer) {
        }

        @Override
        public void systemPropertyChanged(Object key, @Nullable Object value, String consumer) {
        }

        @Override
        public void systemPropertyRemoved(Object key, String consumer) {
        }

        @Override
        public void systemPropertiesCleared(String consumer) {
        }

        @Override
        public void envVariableQueried(String key, @Nullable String value, String consumer) {
        }

        @Override
        public void externalProcessStarted(String command, String consumer) {
        }

        @Override
        public void fileOpened(File file, String consumer) {
        }

        @Override
        public void fileCollectionObserved(FileCollection fileCollection, String consumer) {
        }
    };
    private static final AtomicReference<Listener> LISTENER = new AtomicReference<Listener>(NO_OP);

    public static void setListener(Listener listener2) {
        LISTENER.set(listener2);
    }

    public static void discardListener() {
        Instrumented.setListener(NO_OP);
    }

    public static void groovyCallSites(CallSiteArray array) {
        block33: for (CallSite callSite : array.array) {
            switch (callSite.getName()) {
                case "getProperty": {
                    array.array[callSite.getIndex()] = new SystemPropertyCallSite(callSite);
                    continue block33;
                }
                case "setProperty": {
                    array.array[callSite.getIndex()] = new SetSystemPropertyCallSite(callSite);
                    continue block33;
                }
                case "setProperties": {
                    array.array[callSite.getIndex()] = new SetSystemPropertiesCallSite(callSite);
                    continue block33;
                }
                case "clearProperty": {
                    array.array[callSite.getIndex()] = new ClearSystemPropertyCallSite(callSite);
                    continue block33;
                }
                case "properties": 
                case "getProperties": {
                    array.array[callSite.getIndex()] = new SystemPropertiesCallSite(callSite);
                    continue block33;
                }
                case "getInteger": {
                    array.array[callSite.getIndex()] = new IntegerSystemPropertyCallSite(callSite);
                    continue block33;
                }
                case "getLong": {
                    array.array[callSite.getIndex()] = new LongSystemPropertyCallSite(callSite);
                    continue block33;
                }
                case "getBoolean": {
                    array.array[callSite.getIndex()] = new BooleanSystemPropertyCallSite(callSite);
                    continue block33;
                }
                case "getenv": {
                    array.array[callSite.getIndex()] = new GetEnvCallSite(callSite);
                    continue block33;
                }
                case "exec": {
                    array.array[callSite.getIndex()] = new ExecCallSite(callSite);
                    continue block33;
                }
                case "execute": {
                    array.array[callSite.getIndex()] = new ExecuteCallSite(callSite);
                    continue block33;
                }
                case "start": {
                    array.array[callSite.getIndex()] = new ProcessBuilderStartCallSite(callSite);
                    continue block33;
                }
                case "startPipeline": {
                    array.array[callSite.getIndex()] = new ProcessBuilderStartPipelineCallSite(callSite);
                    continue block33;
                }
                case "<$constructor$>": {
                    array.array[callSite.getIndex()] = new FileInputStreamConstructorCallSite(callSite);
                }
            }
        }
    }

    public static String systemProperty(String key, String consumer) {
        return Instrumented.systemProperty(key, null, consumer);
    }

    public static String systemProperty(String key, @Nullable String defaultValue, String consumer) {
        String value = System.getProperty(key);
        Instrumented.systemPropertyQueried(key, value, consumer);
        return value == null ? defaultValue : value;
    }

    public static Properties systemProperties(final String consumer) {
        return new AccessTrackingProperties(System.getProperties(), new AccessTrackingProperties.Listener(){

            @Override
            public void onAccess(Object key, @Nullable Object value) {
                if (key instanceof String && (value == null || value instanceof String)) {
                    Instrumented.systemPropertyQueried(Instrumented.convertToString(key), Instrumented.convertToString(value), consumer);
                }
            }

            @Override
            public void onChange(Object key, Object newValue) {
                Instrumented.listener().systemPropertyChanged(key, newValue, consumer);
            }

            @Override
            public void onRemove(Object key) {
                Instrumented.listener().systemPropertyRemoved(key, consumer);
            }

            @Override
            public void onClear() {
                Instrumented.listener().systemPropertiesCleared(consumer);
            }
        });
    }

    public static String setSystemProperty(String key, String value, String consumer) {
        String oldValue = System.setProperty(key, value);
        Instrumented.systemPropertyQueried(key, oldValue, consumer);
        Instrumented.listener().systemPropertyChanged(key, value, consumer);
        return oldValue;
    }

    public static String clearSystemProperty(String key, String consumer) {
        String oldValue = System.clearProperty(key);
        Instrumented.systemPropertyQueried(key, oldValue, consumer);
        Instrumented.listener().systemPropertyRemoved(key, consumer);
        return oldValue;
    }

    public static void setSystemProperties(Properties properties, String consumer) {
        Instrumented.listener().systemPropertiesCleared(consumer);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> Instrumented.listener().systemPropertyChanged(k, v, consumer)));
        System.setProperties(properties);
    }

    public static Integer getInteger(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key);
    }

    public static Integer getInteger(String key, int defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Long getLong(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key);
    }

    public static Long getLong(String key, long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static Long getLong(String key, Long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static boolean getBoolean(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Boolean.getBoolean(key);
    }

    public static String getenv(String key, String consumer) {
        String value = System.getenv(key);
        Instrumented.envVariableQueried(key, value, consumer);
        return value;
    }

    public static Map<String, String> getenv(String consumer) {
        return new AccessTrackingEnvMap((key, value) -> Instrumented.envVariableQueried(Instrumented.convertToString(key), value, consumer));
    }

    public static Process exec(Runtime runtime, String command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command);
    }

    public static Process exec(Runtime runtime, String[] command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command);
    }

    public static Process exec(Runtime runtime, String command, String[] envp, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp);
    }

    public static Process exec(Runtime runtime, String[] command, String[] envp, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp);
    }

    public static Process exec(Runtime runtime, String command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp, dir);
    }

    public static Process exec(Runtime runtime, String[] command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp, dir);
    }

    public static Process execute(String command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command);
    }

    public static Process execute(String[] command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command);
    }

    public static Process execute(List<?> command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command);
    }

    public static Process execute(String command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command, (String[])envp, (File)dir);
    }

    public static Process execute(String command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command, envp, (File)dir);
    }

    public static Process execute(String[] command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command, (String[])envp, (File)dir);
    }

    public static Process execute(String[] command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command, envp, (File)dir);
    }

    public static Process execute(List<?> command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command, (String[])envp, (File)dir);
    }

    public static Process execute(List<?> command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command, envp, (File)dir);
    }

    public static Process start(ProcessBuilder builder, String consumer) throws IOException {
        Instrumented.externalProcessStarted(builder.command(), consumer);
        return builder.start();
    }

    public static List<Process> startPipeline(List<ProcessBuilder> pipeline, String consumer) throws IOException {
        try {
            for (ProcessBuilder builder : pipeline) {
                Instrumented.externalProcessStarted(builder.command(), consumer);
            }
            Object result2 = ProcessBuilder.class.getMethod("startPipeline", List.class).invoke(null, pipeline);
            return (List)result2;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new NoSuchMethodError("Cannot find method ProcessBuilder.startPipeline");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unexpected exception thrown by ProcessBuilder.startPipeline", e);
        }
    }

    public static void fileCollectionObserved(FileCollection fileCollection, String consumer) {
        Instrumented.listener().fileCollectionObserved(fileCollection, consumer);
    }

    public static void fileOpened(File file, String consumer) {
        Instrumented.listener().fileOpened(Instrumented.absoluteFileOf(file), consumer);
    }

    private static File absoluteFileOf(File file) {
        return file.isAbsolute() ? file : new File(Instrumented.currentDir(), file.getPath());
    }

    private static File currentDir() {
        return SystemProperties.getInstance().getCurrentDir();
    }

    public static void fileOpened(String path, String consumer) {
        Instrumented.fileOpened(new File(path), consumer);
    }

    private static void envVariableQueried(String key, String value, String consumer) {
        Instrumented.listener().envVariableQueried(key, value, consumer);
    }

    private static void systemPropertyQueried(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, System.getProperty(key), consumer);
    }

    private static void systemPropertyQueried(String key, @Nullable String value, String consumer) {
        Instrumented.listener().systemPropertyQueried(key, value, consumer);
    }

    private static void externalProcessStarted(String command, String consumer) {
        Instrumented.listener().externalProcessStarted(command, consumer);
    }

    private static void externalProcessStarted(String[] command, String consumer) {
        Instrumented.externalProcessStarted(Instrumented.joinCommand(command), consumer);
    }

    private static void externalProcessStarted(List<?> command, String consumer) {
        Instrumented.externalProcessStarted(Instrumented.joinCommand(command), consumer);
    }

    private static Listener listener() {
        return LISTENER.get();
    }

    private static Object unwrap(Object obj) {
        if (obj instanceof Wrapper) {
            return ((Wrapper)obj).unwrap();
        }
        return obj;
    }

    private static String convertToString(Object arg) {
        if (arg instanceof CharSequence) {
            return ((CharSequence)arg).toString();
        }
        return (String)arg;
    }

    private static String joinCommand(String[] command) {
        return String.join((CharSequence)" ", command);
    }

    private static String joinCommand(List<?> command) {
        return command.stream().map(String::valueOf).collect(Collectors.joining(" "));
    }

    private static class FileInputStreamConstructorCallSite
    extends AbstractCallSite {
        public FileInputStreamConstructorCallSite(CallSite prev) {
            super(prev);
        }

        public Object callConstructor(Object receiver, Object arg1) throws Throwable {
            if (receiver.equals(FileInputStream.class)) {
                Object unwrappedArg1 = Instrumented.unwrap(arg1);
                if (unwrappedArg1 instanceof CharSequence) {
                    String path = Instrumented.convertToString(unwrappedArg1);
                    Instrumented.fileOpened(path, this.array.owner.getName());
                    return new FileInputStream(path);
                }
                if (unwrappedArg1 instanceof File) {
                    File file = (File)unwrappedArg1;
                    Instrumented.fileOpened(file, this.array.owner.getName());
                    return new FileInputStream(file);
                }
            }
            return super.callConstructor(receiver, arg1);
        }
    }

    private static class ProcessBuilderStartPipelineCallSite
    extends AbstractCallSite {
        public ProcessBuilderStartPipelineCallSite(CallSite prev) {
            super(prev);
        }

        public Object call(Object receiver, Object arg1) throws Throwable {
            if (receiver.equals(ProcessBuilder.class) && arg1 instanceof List) {
                return Instrumented.startPipeline((List)arg1, this.array.owner.getName());
            }
            return super.call(receiver, arg1);
        }

        public Object callStatic(Class receiver, Object arg1) throws Throwable {
            if (receiver.equals(ProcessBuilder.class) && arg1 instanceof List) {
                return Instrumented.startPipeline((List)arg1, this.array.owner.getName());
            }
            return super.callStatic(receiver, arg1);
        }
    }

    private static class ProcessBuilderStartCallSite
    extends AbstractCallSite {
        public ProcessBuilderStartCallSite(CallSite prev) {
            super(prev);
        }

        public Object call(Object receiver) throws Throwable {
            if (receiver instanceof ProcessBuilder) {
                return Instrumented.start((ProcessBuilder)receiver, this.array.owner.getName());
            }
            return super.call(receiver);
        }
    }

    private static class ExecuteCallSite
    extends AbstractCallSite {
        public ExecuteCallSite(CallSite prev) {
            super(prev);
        }

        public Object call(Object receiver) throws Throwable {
            Optional<Process> result2 = this.tryCallExecute(receiver, null, null);
            if (result2.isPresent()) {
                return result2.get();
            }
            return super.call(receiver);
        }

        public Object call(Object receiver, Object arg1) throws Throwable {
            Optional<Process> process;
            if (receiver.equals(ProcessGroovyMethods.class) && (process = this.tryCallExecute(arg1, null, null)).isPresent()) {
                return process.get();
            }
            return super.call(receiver, arg1);
        }

        public Object callStatic(Class receiver, Object arg1) throws Throwable {
            Optional<Process> process;
            if (receiver.equals(ProcessGroovyMethods.class) && (process = this.tryCallExecute(arg1, null, null)).isPresent()) {
                return process.get();
            }
            return super.callStatic(receiver, arg1);
        }

        public Object call(Object receiver, @Nullable Object arg1, @Nullable Object arg2) throws Throwable {
            Optional<Process> result2 = this.tryCallExecute(receiver, arg1, arg2);
            if (result2.isPresent()) {
                return result2.get();
            }
            return super.call(receiver, arg1, arg2);
        }

        public Object call(Object receiver, Object arg1, @Nullable Object arg2, @Nullable Object arg3) throws Throwable {
            Optional<Process> result2;
            if (receiver.equals(ProcessGroovyMethods.class) && (result2 = this.tryCallExecute(arg1, arg2, arg3)).isPresent()) {
                return result2.get();
            }
            return super.call(receiver, arg1, arg2, arg3);
        }

        public Object callStatic(Class receiver, Object arg1, @Nullable Object arg2, @Nullable Object arg3) throws Throwable {
            Optional<Process> result2;
            if (receiver.equals(ProcessGroovyMethods.class) && (result2 = this.tryCallExecute(arg1, arg2, arg3)).isPresent()) {
                return result2.get();
            }
            return super.callStatic(receiver, arg1, arg2, arg3);
        }

        private Optional<Process> tryCallExecute(Object commandArg, @Nullable Object envpArg, @Nullable Object fileArg) throws Throwable {
            commandArg = Instrumented.unwrap(commandArg);
            envpArg = Instrumented.unwrap(envpArg);
            if ((fileArg = Instrumented.unwrap(fileArg)) == null || fileArg instanceof File) {
                File file = (File)fileArg;
                if (commandArg instanceof CharSequence) {
                    String command = Instrumented.convertToString(commandArg);
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, this.array.owner.getName()));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, this.array.owner.getName()));
                    }
                } else if (commandArg instanceof String[]) {
                    String[] command = (String[])commandArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, this.array.owner.getName()));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, this.array.owner.getName()));
                    }
                } else if (commandArg instanceof List) {
                    List command = (List)commandArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, this.array.owner.getName()));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, this.array.owner.getName()));
                    }
                }
            }
            return Optional.empty();
        }
    }

    private static class ExecCallSite
    extends AbstractCallSite {
        public ExecCallSite(CallSite prev) {
            super(prev);
        }

        public Object call(Object receiver, Object arg1) throws Throwable {
            Optional<Process> result2 = this.tryCallExec(receiver, arg1, null, null);
            if (result2.isPresent()) {
                return result2.get();
            }
            return super.call(receiver, arg1);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            Optional<Process> result2 = this.tryCallExec(receiver, arg1, arg2, null);
            if (result2.isPresent()) {
                return result2.get();
            }
            return super.call(receiver, arg1, arg2);
        }

        public Object call(Object receiver, Object arg1, Object arg2, Object arg3) throws Throwable {
            Optional<Process> result2 = this.tryCallExec(receiver, arg1, arg2, arg3);
            if (result2.isPresent()) {
                return result2.get();
            }
            return super.call(receiver, arg1, arg2, arg3);
        }

        private Optional<Process> tryCallExec(Object runtimeArg, Object commandArg, @Nullable Object envpArg, @Nullable Object fileArg) throws Throwable {
            runtimeArg = Instrumented.unwrap(runtimeArg);
            commandArg = Instrumented.unwrap(commandArg);
            envpArg = Instrumented.unwrap(envpArg);
            fileArg = Instrumented.unwrap(fileArg);
            if (runtimeArg instanceof Runtime) {
                Runtime runtime = (Runtime)runtimeArg;
                if (fileArg == null || fileArg instanceof File) {
                    File file = (File)fileArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        String[] envp = (String[])envpArg;
                        if (commandArg instanceof CharSequence) {
                            String command = Instrumented.convertToString(commandArg);
                            return Optional.of(Instrumented.exec(runtime, command, envp, file, this.array.owner.getName()));
                        }
                        if (commandArg instanceof String[]) {
                            String[] command = (String[])commandArg;
                            return Optional.of(Instrumented.exec(runtime, command, envp, file, this.array.owner.getName()));
                        }
                    }
                }
            }
            return Optional.empty();
        }
    }

    private static class GetEnvCallSite
    extends AbstractCallSite {
        public GetEnvCallSite(CallSite prev) {
            super(prev);
        }

        public Object call(Object receiver) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.getenv(this.array.owner.getName());
            }
            return super.call(receiver);
        }

        public Object call(Object receiver, Object arg1) throws Throwable {
            if (receiver.equals(System.class) && arg1 instanceof CharSequence) {
                return Instrumented.getenv(Instrumented.convertToString(arg1), this.array.owner.getName());
            }
            return super.call(receiver, arg1);
        }
    }

    private static class SystemPropertiesCallSite
    extends AbstractCallSite {
        public SystemPropertiesCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object callGetProperty(Object receiver) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperties(this.array.owner.getName());
            }
            return super.callGetProperty(receiver);
        }

        public Object call(Object receiver) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperties(this.array.owner.getName());
            }
            return super.call(receiver);
        }

        public Object callStatic(Class receiver) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperties(this.array.owner.getName());
            }
            return super.callStatic(receiver);
        }
    }

    private static class ClearSystemPropertyCallSite
    extends AbstractCallSite {
        public ClearSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg1) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.clearSystemProperty(Instrumented.convertToString(arg1), this.array.owner.getName());
            }
            return super.call(receiver, arg1);
        }

        public Object callStatic(Class receiver, Object arg1) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.clearSystemProperty(Instrumented.convertToString(arg1), this.array.owner.getName());
            }
            return super.callStatic(receiver, arg1);
        }
    }

    private static class SetSystemPropertiesCallSite
    extends AbstractCallSite {
        public SetSystemPropertiesCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg1) throws Throwable {
            if (receiver.equals(System.class) && arg1 instanceof Properties) {
                Instrumented.setSystemProperties((Properties)arg1, this.array.owner.getName());
                return null;
            }
            return super.call(receiver, arg1);
        }

        public Object callStatic(Class receiver, Object arg1) throws Throwable {
            if (receiver.equals(System.class) && arg1 instanceof Properties) {
                Instrumented.setSystemProperties((Properties)arg1, this.array.owner.getName());
                return null;
            }
            return super.callStatic(receiver, arg1);
        }
    }

    private static class SetSystemPropertyCallSite
    extends AbstractCallSite {
        public SetSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.setSystemProperty(Instrumented.convertToString(arg1), Instrumented.convertToString(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }

        public Object callStatic(Class receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.setSystemProperty(Instrumented.convertToString(arg1), Instrumented.convertToString(arg2), this.array.owner.getName());
            }
            return super.callStatic(receiver, arg1, arg2);
        }
    }

    private static class SystemPropertyCallSite
    extends AbstractCallSite {
        public SystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object callStatic(Class receiver, Object arg1) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty(arg1.toString(), this.array.owner.getName());
            }
            return super.callStatic(receiver, arg1);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty(arg1.toString(), Instrumented.convertToString(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }

        public Object callStatic(Class receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty(arg1.toString(), Instrumented.convertToString(arg2), this.array.owner.getName());
            }
            return super.callStatic(receiver, arg1, arg2);
        }
    }

    private static class BooleanSystemPropertyCallSite
    extends AbstractCallSite {
        public BooleanSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Boolean.class)) {
                return Instrumented.getBoolean(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }
    }

    private static class LongSystemPropertyCallSite
    extends AbstractCallSite {
        public LongSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Long.class)) {
                return Instrumented.getLong(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(Long.class)) {
                return Instrumented.getLong(arg1.toString(), (Long)Instrumented.unwrap(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    private static class IntegerSystemPropertyCallSite
    extends AbstractCallSite {
        public IntegerSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Integer.class)) {
                return Instrumented.getInteger(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(Integer.class)) {
                return Instrumented.getInteger(arg1.toString(), (Integer)Instrumented.unwrap(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    public static interface Listener {
        public void systemPropertyQueried(String var1, @Nullable Object var2, String var3);

        public void systemPropertyChanged(Object var1, @Nullable Object var2, String var3);

        public void systemPropertyRemoved(Object var1, String var2);

        public void systemPropertiesCleared(String var1);

        public void envVariableQueried(String var1, @Nullable String var2, String var3);

        public void externalProcessStarted(String var1, String var2);

        public void fileOpened(File var1, String var2);

        public void fileCollectionObserved(FileCollection var1, String var2);
    }
}

