/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.execution.plan.BuildWorkPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.BuildWorkGraphController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Runnables;

public class DefaultBuildWorkGraphController
implements BuildWorkGraphController {
    private final TaskNodeFactory taskNodeFactory;
    private final BuildLifecycleController controller;
    private final Map<String, DefaultExportedTaskNode> nodesByPath = new ConcurrentHashMap<String, DefaultExportedTaskNode>();
    private final Object lock = new Object();
    private DefaultBuildWorkGraph current;

    public DefaultBuildWorkGraphController(TaskNodeFactory taskNodeFactory, BuildLifecycleController controller) {
        this.taskNodeFactory = taskNodeFactory;
        this.controller = controller;
    }

    @Override
    public ExportedTaskNode locateTask(TaskIdentifier taskIdentifier) {
        DefaultExportedTaskNode node = this.doLocate(taskIdentifier);
        if (taskIdentifier instanceof TaskIdentifier.TaskBasedTaskIdentifier) {
            node.maybeBindTask(((TaskIdentifier.TaskBasedTaskIdentifier)taskIdentifier).getTask());
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildWorkGraph newWorkGraph() {
        Object object = this.lock;
        synchronized (object) {
            if (this.current != null) {
                throw new IllegalStateException("This build's work graph is currently in use by another thread.");
            }
            this.current = new DefaultBuildWorkGraph();
            return this.current;
        }
    }

    private DefaultExportedTaskNode doLocate(TaskIdentifier taskIdentifier) {
        return this.nodesByPath.computeIfAbsent(taskIdentifier.getTaskPath(), x$0 -> new DefaultExportedTaskNode((String)x$0));
    }

    @Nullable
    private TaskInternal findTaskNode(String taskPath) {
        for (Task task : this.taskNodeFactory.getTasks()) {
            if (!task.getPath().equals(taskPath)) continue;
            return (TaskInternal)task;
        }
        return null;
    }

    private class DefaultExportedTaskNode
    implements ExportedTaskNode {
        final String taskPath;
        TaskNode taskNode;
        Runnable action = Runnables.doNothing();

        DefaultExportedTaskNode(String taskPath) {
            this.taskPath = taskPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeBindTask(TaskInternal task) {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                if (this.taskNode == null) {
                    this.taskNode = DefaultBuildWorkGraphController.this.taskNodeFactory.getOrCreateNode(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(Runnable action) {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                Runnable previous = this.action;
                this.action = () -> {
                    previous.run();
                    action.run();
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskInternal getTask() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                if (this.taskNode == null) {
                    TaskInternal task = DefaultBuildWorkGraphController.this.findTaskNode(this.taskPath);
                    if (task == null) {
                        throw new IllegalStateException("Task '" + this.taskPath + "' was never scheduled for execution.");
                    }
                    this.taskNode = DefaultBuildWorkGraphController.this.taskNodeFactory.getOrCreateNode(task);
                }
                return this.taskNode.getTask();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IncludedBuildTaskResource.State getTaskState() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                if (this.taskNode == null) {
                    TaskInternal task = DefaultBuildWorkGraphController.this.findTaskNode(this.taskPath);
                    if (task == null) {
                        return IncludedBuildTaskResource.State.Waiting;
                    }
                    this.taskNode = DefaultBuildWorkGraphController.this.taskNodeFactory.getOrCreateNode(task);
                }
                if (this.taskNode.isExecuted() && this.taskNode.isSuccessful()) {
                    return IncludedBuildTaskResource.State.Success;
                }
                if (this.taskNode.isComplete()) {
                    return IncludedBuildTaskResource.State.Failed;
                }
                return IncludedBuildTaskResource.State.Waiting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean shouldSchedule() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                return this.taskNode == null || !this.taskNode.isRequired();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String healthDiagnostics() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                return "exportedTaskState=" + (Object)((Object)this.getTaskState());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireCompleted() {
            Object object = DefaultBuildWorkGraphController.this.lock;
            synchronized (object) {
                this.action.run();
                this.action = Runnables.doNothing();
            }
        }
    }

    private class DefaultBuildWorkGraph
    implements BuildWorkGraph {
        private final Thread owner = Thread.currentThread();
        BuildWorkPlan plan;

        @Override
        public void stop() {
            if (this.plan != null) {
                this.plan.stop();
            }
        }

        @Override
        public boolean schedule(Collection<ExportedTaskNode> taskNodes) {
            this.assertIsOwner();
            ArrayList<TaskInternal> tasks = new ArrayList<TaskInternal>();
            for (ExportedTaskNode taskNode : taskNodes) {
                DefaultExportedTaskNode node = (DefaultExportedTaskNode)taskNode;
                if (DefaultBuildWorkGraphController.this.nodesByPath.get(node.taskPath) != taskNode) {
                    throw new IllegalArgumentException();
                }
                if (!node.shouldSchedule()) continue;
                tasks.add(node.getTask());
            }
            if (tasks.isEmpty()) {
                return false;
            }
            DefaultBuildWorkGraphController.this.controller.getGradle().getOwner().getProjects().withMutableStateOfAllProjects(() -> {
                this.createPlan();
                DefaultBuildWorkGraphController.this.controller.populateWorkGraph(this.plan, workGraph -> workGraph.addEntryTasks(tasks));
            });
            return true;
        }

        @Override
        public void populateWorkGraph(Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
            this.assertIsOwner();
            this.createPlan();
            DefaultBuildWorkGraphController.this.controller.populateWorkGraph(this.plan, action);
        }

        private void createPlan() {
            if (this.plan == null) {
                DefaultBuildWorkGraphController.this.controller.prepareToScheduleTasks();
                this.plan = DefaultBuildWorkGraphController.this.controller.newWorkGraph();
                this.plan.onComplete(this::nodeComplete);
            }
        }

        private void nodeComplete(LocalTaskNode node) {
            DefaultExportedTaskNode exportedNode = (DefaultExportedTaskNode)DefaultBuildWorkGraphController.this.nodesByPath.get(node.getTask().getPath());
            if (exportedNode != null) {
                exportedNode.fireCompleted();
            }
        }

        @Override
        public void finalizeGraph() {
            this.assertIsOwner();
            if (this.plan != null) {
                DefaultBuildWorkGraphController.this.controller.finalizeWorkGraph(this.plan);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecutionResult<Void> runWork() {
            try {
                if (this.plan != null) {
                    ExecutionResult<Void> executionResult = DefaultBuildWorkGraphController.this.controller.executeTasks(this.plan);
                    return executionResult;
                }
                ExecutionResult<Void> executionResult = ExecutionResult.succeeded();
                return executionResult;
            }
            finally {
                Object object = DefaultBuildWorkGraphController.this.lock;
                synchronized (object) {
                    DefaultBuildWorkGraphController.this.current = null;
                }
            }
        }

        private void assertIsOwner() {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException("Current thread is not the owner of this work graph.");
            }
        }
    }
}

