/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildToolingModelControllerFactory;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.DefaultBuildLifecycleController;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.service.scopes.BuildScopeListenerManagerAction;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultBuildLifecycleControllerFactory
implements BuildLifecycleControllerFactory {
    private final StateTransitionControllerFactory stateTransitionControllerFactory;
    private final BuildToolingModelControllerFactory buildToolingModelControllerFactory;
    private final ExceptionAnalyser exceptionAnalyser;

    public DefaultBuildLifecycleControllerFactory(StateTransitionControllerFactory stateTransitionControllerFactory, BuildToolingModelControllerFactory buildToolingModelControllerFactory, ExceptionAnalyser exceptionAnalyser) {
        this.stateTransitionControllerFactory = stateTransitionControllerFactory;
        this.buildToolingModelControllerFactory = buildToolingModelControllerFactory;
        this.exceptionAnalyser = exceptionAnalyser;
    }

    @Override
    public BuildLifecycleController newInstance(BuildDefinition buildDefinition, BuildScopeServices buildScopeServices) {
        File customBuildFile;
        StartParameterInternal startParameter = buildDefinition.getStartParameter();
        ListenerManager listenerManager = buildScopeServices.get(ListenerManager.class);
        for (Action action : buildScopeServices.getAll(BuildScopeListenerManagerAction.class)) {
            action.execute(listenerManager);
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener(usageLocationReporter);
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(false);
            }
        }
        DeprecationLogger.init(usageLocationReporter, startParameter.getWarningMode(), buildScopeServices.get(BuildOperationProgressEventEmitter.class));
        File customSettingsFile = startParameter.getSettingsFile();
        if (customSettingsFile != null) {
            DeprecationLogger.deprecateAction("Specifying custom settings file location").willBeRemovedInGradle8().withUpgradeGuideSection(7, "configuring_custom_build_layout").nagUser();
        }
        if ((customBuildFile = startParameter.getBuildFile()) != null) {
            DeprecationLogger.deprecateAction("Specifying custom build file location").willBeRemovedInGradle8().withUpgradeGuideSection(7, "configuring_custom_build_layout").nagUser();
        }
        GradleInternal gradle = buildScopeServices.get(GradleInternal.class);
        BuildModelController buildModelController = buildScopeServices.get(BuildModelController.class);
        return new DefaultBuildLifecycleController(gradle, buildModelController, this.exceptionAnalyser, gradle.getBuildListenerBroadcaster(), listenerManager.getBroadcaster(InternalBuildFinishedListener.class), gradle.getServices().get(BuildWorkPreparer.class), gradle.getServices().get(BuildWorkExecutor.class), this.buildToolingModelControllerFactory, this.stateTransitionControllerFactory);
    }
}

