/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

public class BuildLayoutParametersBuildOptions
extends BuildOptionSet<BuildLayoutParameters> {
    private static List<BuildOption<? super BuildLayoutParameters>> options;

    @Override
    public List<BuildOption<? super BuildLayoutParameters>> getAllOptions() {
        return options;
    }

    static {
        ArrayList<StringBuildOption> options = new ArrayList<StringBuildOption>();
        options.add(new GradleUserHomeOption());
        options.add(new ProjectDirOption());
        BuildLayoutParametersBuildOptions.options = Collections.unmodifiableList(options);
    }

    public static class ProjectDirOption
    extends StringBuildOption<BuildLayoutParameters> {
        public ProjectDirOption() {
            super((String)null, CommandLineOptionConfiguration.create("project-dir", "p", "Specifies the start directory for Gradle. Defaults to current directory."));
        }

        @Override
        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            File projectDir = (File)resolver.transform(value);
            settings.setCurrentDir(projectDir);
            settings.setProjectDir(projectDir);
        }
    }

    public static class GradleUserHomeOption
    extends StringBuildOption<BuildLayoutParameters> {
        public GradleUserHomeOption() {
            super("gradle.user.home", CommandLineOptionConfiguration.create("gradle-user-home", "g", "Specifies the Gradle user home directory. Defaults to ~/.gradle"));
        }

        @Override
        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setGradleUserHomeDir((File)resolver.transform(value));
        }
    }
}

