/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.ide.xcode.internal.xcodeproj.PBXProjectItem;
import org.gradle.ide.xcode.internal.xcodeproj.XCBuildConfiguration;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class XCConfigurationList
extends PBXProjectItem {
    private final LoadingCache<String, XCBuildConfiguration> buildConfigurationsByName;
    private List<XCBuildConfiguration> buildConfigurations = Lists.newArrayList();
    private Optional<String> defaultConfigurationName = Optional.absent();
    private boolean defaultConfigurationIsVisible = false;

    public XCConfigurationList() {
        this.buildConfigurationsByName = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, XCBuildConfiguration>(){

            public XCBuildConfiguration load(String key) throws Exception {
                XCBuildConfiguration configuration2 = new XCBuildConfiguration(key);
                XCConfigurationList.this.buildConfigurations.add(configuration2);
                return configuration2;
            }
        });
    }

    public LoadingCache<String, XCBuildConfiguration> getBuildConfigurationsByName() {
        return this.buildConfigurationsByName;
    }

    @Override
    public String isa() {
        return "XCConfigurationList";
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        Collections.sort(this.buildConfigurations, new Comparator<XCBuildConfiguration>(){

            @Override
            public int compare(XCBuildConfiguration o1, XCBuildConfiguration o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        s.addField("buildConfigurations", this.buildConfigurations);
        if (this.defaultConfigurationName.isPresent()) {
            s.addField("defaultConfigurationName", (String)this.defaultConfigurationName.get());
        }
        s.addField("defaultConfigurationIsVisible", this.defaultConfigurationIsVisible);
    }
}

