/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.IdentityHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.execution.plan.ActionNode;
import org.gradle.execution.plan.DependencyResolver;
import org.gradle.execution.plan.Node;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class WorkNodeDependencyResolver
implements DependencyResolver {
    private final Map<WorkNodeAction, ActionNode> nodesForAction = new IdentityHashMap<WorkNodeAction, ActionNode>();

    @Override
    public boolean resolve(Task task, Object node, Action<? super Node> resolveAction) {
        if (!(node instanceof WorkNodeAction)) {
            return false;
        }
        WorkNodeAction action = (WorkNodeAction)node;
        ActionNode actionNode = this.actionNodeFor(action);
        resolveAction.execute(actionNode);
        return true;
    }

    private ActionNode actionNodeFor(WorkNodeAction action) {
        ActionNode actionNode = this.nodesForAction.get(action);
        if (actionNode == null) {
            actionNode = new ActionNode(action);
            this.nodesForAction.put(action, actionNode);
        }
        return actionNode;
    }
}

