/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.OrdinalNode;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Streams;

public class OrdinalNodeAccess {
    private final List<OrdinalGroup> groups = new ArrayList<OrdinalGroup>();
    private final Map<OrdinalGroup, OrdinalNode> destroyerLocationNodes = Maps.newHashMap();
    private final Map<OrdinalGroup, OrdinalNode> producerLocationNodes = Maps.newHashMap();

    OrdinalNode getOrCreateDestroyableLocationNode(OrdinalGroup ordinal) {
        return this.destroyerLocationNodes.computeIfAbsent(ordinal, i -> this.createDestroyerLocationNode(ordinal));
    }

    OrdinalNode getOrCreateOutputLocationNode(OrdinalGroup ordinal) {
        return this.producerLocationNodes.computeIfAbsent(ordinal, i -> this.createProducerLocationNode(ordinal));
    }

    List<OrdinalGroup> getAllGroups() {
        return this.groups;
    }

    List<OrdinalNode> getAllNodes() {
        return Streams.concat((Stream[])new Stream[]{this.destroyerLocationNodes.values().stream(), this.producerLocationNodes.values().stream()}).collect(Collectors.toList());
    }

    void createInterNodeRelationships() {
        this.destroyerLocationNodes.forEach((ordinal, destroyer) -> {
            for (int i = 0; i < ordinal.getOrdinal(); ++i) {
                Node precedingNode = this.destroyerLocationNodes.get(this.group(i));
                if (precedingNode == null) continue;
                destroyer.addDependencySuccessor(precedingNode);
            }
        });
        this.producerLocationNodes.forEach((ordinal, producer) -> {
            for (int i = 0; i < ordinal.getOrdinal(); ++i) {
                Node precedingNode = this.producerLocationNodes.get(this.group(i));
                if (precedingNode == null) continue;
                producer.addDependencySuccessor(precedingNode);
            }
        });
    }

    private OrdinalNode createDestroyerLocationNode(OrdinalGroup ordinal) {
        return this.createOrdinalNode(OrdinalNode.Type.DESTROYER, ordinal);
    }

    private OrdinalNode createProducerLocationNode(OrdinalGroup ordinal) {
        return this.createOrdinalNode(OrdinalNode.Type.PRODUCER, ordinal);
    }

    private OrdinalNode createOrdinalNode(OrdinalNode.Type type, OrdinalGroup ordinal) {
        OrdinalNode ordinalNode = new OrdinalNode(type, ordinal);
        ordinalNode.require();
        return ordinalNode;
    }

    public OrdinalGroup group(int ordinal) {
        if (ordinal > this.groups.size()) {
            throw new IllegalArgumentException("Unexpected group requested");
        }
        if (ordinal == this.groups.size()) {
            this.groups.add(new OrdinalGroup(ordinal));
        }
        return this.groups.get(ordinal);
    }

    @Nullable
    public Node getPrecedingProducerLocationNode(OrdinalGroup ordinal) {
        if (ordinal.getOrdinal() == 0) {
            return null;
        }
        return this.getOrCreateOutputLocationNode(this.group(ordinal.getOrdinal() - 1));
    }

    @Nullable
    public Node getPrecedingDestroyerLocationNode(OrdinalGroup ordinal) {
        if (ordinal.getOrdinal() == 0) {
            return null;
        }
        return this.getOrCreateDestroyableLocationNode(this.group(ordinal.getOrdinal() - 1));
    }

    public void reset() {
        this.groups.clear();
        this.destroyerLocationNodes.clear();
        this.producerLocationNodes.clear();
    }
}

