/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskExecutionContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchies;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchy;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeExecutor;
import org.gradle.execution.plan.OrdinalNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.TextUtil;

public class LocalTaskNodeExecutor
implements NodeExecutor {
    private final ExecutionNodeAccessHierarchy outputHierarchy;

    public LocalTaskNodeExecutor(ExecutionNodeAccessHierarchy outputHierarchy) {
        this.outputHierarchy = outputHierarchy;
    }

    @Override
    public boolean execute(Node node, NodeExecutionContext context) {
        if (node instanceof LocalTaskNode) {
            LocalTaskNode localTaskNode = (LocalTaskNode)node;
            TaskInternal task = localTaskNode.getTask();
            TaskStateInternal state2 = task.getState();
            ExecutionNodeAccessHierarchies.InputNodeAccessHierarchy inputHierarchy = context.getService(ExecutionNodeAccessHierarchies.InputNodeAccessHierarchy.class);
            DefaultTaskExecutionContext ctx = new DefaultTaskExecutionContext(localTaskNode, localTaskNode.getTaskProperties(), localTaskNode.getValidationContext(), (historyMaintained, typeValidationContext) -> this.detectMissingDependencies(localTaskNode, historyMaintained, inputHierarchy, typeValidationContext));
            TaskExecuter taskExecuter = context.getService(TaskExecuter.class);
            taskExecuter.execute(task, state2, ctx);
            return true;
        }
        return false;
    }

    private void detectMissingDependencies(LocalTaskNode node, boolean historyMaintained, ExecutionNodeAccessHierarchies.InputNodeAccessHierarchy inputHierarchy, TypeValidationContext validationContext) {
        for (String outputPath : node.getMutationInfo().outputPaths) {
            inputHierarchy.getNodesAccessing(outputPath).stream().filter(consumerNode -> this.hasNoSpecifiedOrder(node, (Node)consumerNode)).filter(LocalTaskNodeExecutor::isEnabled).forEach(consumerWithoutDependency -> this.collectValidationProblem(node, (Node)consumerWithoutDependency, validationContext, outputPath));
        }
        final LinkedHashSet<String> taskInputs = new LinkedHashSet<String>();
        final LinkedHashSet filteredFileTreeTaskInputs = new LinkedHashSet();
        node.getTaskProperties().getInputFileProperties().forEach(spec -> {
            try {
                spec.getPropertyFiles().visitStructure(new FileCollectionStructureVisitor(){

                    @Override
                    public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                        contents.forEach(location -> taskInputs.add(location.getAbsolutePath()));
                    }

                    @Override
                    public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                        fileTree.forEach(location -> taskInputs.add(location.getAbsolutePath()));
                    }

                    @Override
                    public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                        if (patterns.isEmpty()) {
                            taskInputs.add(root.getAbsolutePath());
                        } else {
                            filteredFileTreeTaskInputs.add(new FilteredTree(root.getAbsolutePath(), patterns));
                        }
                    }

                    @Override
                    public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                        taskInputs.add(file.getAbsolutePath());
                    }
                });
            }
            catch (Exception e) {
                if (historyMaintained) {
                    throw e;
                }
                validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.UNRESOLVABLE_INPUT)).forProperty(spec.getPropertyName()).reportAs(Severity.WARNING)).withDescription(() -> String.format("cannot be resolved:%n%s%n", TextUtil.indent(e.getMessage(), "  ")))).happensBecause("An input file collection couldn't be resolved, making it impossible to determine task inputs")).addPossibleSolution("Consider using Task.dependsOn instead")).documentedAt("validation_problems", "unresolvable_input"));
            }
        });
        inputHierarchy.recordNodeAccessingLocations(node, taskInputs);
        for (String locationConsumedByThisTask : taskInputs) {
            this.collectValidationProblemsForConsumer(node, validationContext, locationConsumedByThisTask, (Collection<Node>)this.outputHierarchy.getNodesAccessing(locationConsumedByThisTask));
        }
        for (FilteredTree filteredFileTreeInput : filteredFileTreeTaskInputs) {
            Spec<FileTreeElement> spec2 = filteredFileTreeInput.getPatterns().getAsSpec();
            inputHierarchy.recordNodeAccessingFileTree(node, filteredFileTreeInput.getRoot(), spec2);
            this.collectValidationProblemsForConsumer(node, validationContext, filteredFileTreeInput.getRoot(), (Collection<Node>)this.outputHierarchy.getNodesAccessing(filteredFileTreeInput.getRoot(), spec2));
        }
    }

    private void collectValidationProblemsForConsumer(LocalTaskNode consumer, TypeValidationContext validationContext, String locationConsumedByThisTask, Collection<Node> producers) {
        producers.stream().filter(producerNode -> this.hasNoSpecifiedOrder((Node)producerNode, consumer)).filter(LocalTaskNodeExecutor::isEnabled).forEach(producerWithoutDependency -> this.collectValidationProblem((Node)producerWithoutDependency, consumer, validationContext, locationConsumedByThisTask));
    }

    private static boolean isEnabled(Node node) {
        if (node instanceof LocalTaskNode) {
            TaskInternal task = ((LocalTaskNode)node).getTask();
            return task.getOnlyIf().isSatisfiedBy(task);
        }
        return false;
    }

    private boolean hasNoSpecifiedOrder(Node producerNode, Node consumerNode) {
        return LocalTaskNodeExecutor.missesDependency(producerNode, consumerNode) && LocalTaskNodeExecutor.missesDependency(consumerNode, producerNode);
    }

    private static boolean missesDependency(Node producer, Node consumer) {
        if (consumer == producer) {
            return false;
        }
        if (consumer.getDependencySuccessors().contains(producer)) {
            return false;
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        HashSet<Node> seenNodes = new HashSet<Node>();
        LocalTaskNodeExecutor.addHardSuccessorTasksToQueue(consumer, seenNodes, queue);
        while (!queue.isEmpty()) {
            Node dependency = (Node)queue.removeFirst();
            if (dependency == producer) {
                return false;
            }
            LocalTaskNodeExecutor.addHardSuccessorTasksToQueue(dependency, seenNodes, queue);
        }
        return true;
    }

    private static void addHardSuccessorTasksToQueue(Node node, Set<Node> seenNodes, Queue<Node> queue) {
        node.getHardSuccessors().forEach(successor -> {
            if (successor instanceof TaskNode || successor instanceof OrdinalNode) {
                if (seenNodes.add((Node)successor)) {
                    queue.add((Node)successor);
                }
            } else {
                LocalTaskNodeExecutor.addHardSuccessorTasksToQueue(successor, seenNodes, queue);
            }
        });
    }

    private void collectValidationProblem(Node producer, Node consumer, TypeValidationContext validationContext, String consumerProducerPath) {
        validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.IMPLICIT_DEPENDENCY)).reportAs(Severity.WARNING)).withDescription(() -> "Gradle detected a problem with the following location: '" + consumerProducerPath + "'")).happensBecause(() -> String.format("Task '%s' uses this output of task '%s' without declaring an explicit or implicit dependency. This can lead to incorrect results being produced, depending on what order the tasks are executed", consumer, producer))).addPossibleSolution(() -> "Declare task '" + producer + "' as an input of '" + consumer + "'")).addPossibleSolution(() -> "Declare an explicit dependency on '" + producer + "' from '" + consumer + "' using Task#dependsOn")).addPossibleSolution(() -> "Declare an explicit dependency on '" + producer + "' from '" + consumer + "' using Task#mustRunAfter")).documentedAt("validation_problems", "implicit_dependency")).typeIsIrrelevantInErrorMessage());
    }

    private static class FilteredTree {
        private final String root;
        private final PatternSet patterns;

        private FilteredTree(String root, PatternSet patterns) {
            this.root = root;
            this.patterns = patterns;
        }

        public String getRoot() {
            return this.root;
        }

        public PatternSet getPatterns() {
            return this.patterns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilteredTree that = (FilteredTree)o;
            return this.root.equals(that.root) && this.patterns.equals(that.patterns);
        }

        public int hashCode() {
            return Objects.hash(this.root, this.patterns);
        }
    }
}

