/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.execution.plan.WorkSource;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Cast;
import org.gradle.internal.MutableReference;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultPlanExecutor
implements PlanExecutor,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPlanExecutor.class);
    private final int executorCount;
    private final WorkerLeaseService workerLeaseService;
    private final BuildCancellationToken cancellationToken;
    private final ResourceLockCoordinationService coordinationService;
    private final ManagedExecutor executor;
    private final MergedQueues queue;
    private final AtomicBoolean workersStarted = new AtomicBoolean();

    public DefaultPlanExecutor(ParallelismConfiguration parallelismConfiguration, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        this.cancellationToken = cancellationToken;
        this.coordinationService = coordinationService;
        int numberOfParallelExecutors = parallelismConfiguration.getMaxWorkerCount();
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
        this.workerLeaseService = workerLeaseService;
        this.queue = new MergedQueues(coordinationService, false);
        this.executor = executorFactory.create("Execution worker");
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable(this.queue, this.executor).stop();
    }

    @Override
    public <T> ExecutionResult<Void> process(WorkSource<T> workSource, Action<T> worker) {
        PlanDetails planDetails = new PlanDetails((WorkSource)Cast.uncheckedCast(workSource), (Action)Cast.uncheckedCast(worker));
        this.queue.add(planDetails);
        this.maybeStartWorkers(this.queue, this.executor);
        WorkerLeaseRegistry.WorkerLease currentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
        MergedQueues thisPlanOnly = new MergedQueues(this.coordinationService, true);
        thisPlanOnly.add(planDetails);
        new ExecutorWorker(thisPlanOnly, currentWorkerLease, this.cancellationToken, this.coordinationService, this.workerLeaseService).run();
        ArrayList failures = new ArrayList();
        this.awaitCompletion(workSource, currentWorkerLease, failures);
        return ExecutionResult.maybeFailed(failures);
    }

    @Override
    public void assertHealthy() {
        this.coordinationService.withStateLock(this.queue::assertHealthy);
    }

    private void awaitCompletion(WorkSource<?> workSource, WorkerLeaseRegistry.WorkerLease workerLease, Collection<? super Throwable> failures) {
        this.coordinationService.withStateLock(resourceLockState -> {
            if (workSource.allExecutionComplete()) {
                if (!workerLease.isLockedByCurrentThread() && !workerLease.tryLock()) {
                    return ResourceLockState.Disposition.RETRY;
                }
                workSource.collectFailures(failures);
                this.queue.removeFinishedPlans();
                return ResourceLockState.Disposition.FINISHED;
            }
            workerLease.unlock();
            return ResourceLockState.Disposition.RETRY;
        });
    }

    private void maybeStartWorkers(MergedQueues queue, Executor executor) {
        if (this.workersStarted.compareAndSet(false, true)) {
            LOGGER.debug("Using {} parallel executor threads", (Object)this.executorCount);
            for (int i = 1; i < this.executorCount; ++i) {
                executor.execute(new ExecutorWorker(queue, null, this.cancellationToken, this.coordinationService, this.workerLeaseService));
            }
        }
    }

    private static class ExecutorWorker
    implements Runnable {
        private final MergedQueues queue;
        private WorkerLeaseRegistry.WorkerLease workerLease;
        private final BuildCancellationToken cancellationToken;
        private final ResourceLockCoordinationService coordinationService;
        private final WorkerLeaseService workerLeaseService;

        private ExecutorWorker(MergedQueues queue, @Nullable WorkerLeaseRegistry.WorkerLease workerLease, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService, WorkerLeaseService workerLeaseService) {
            this.queue = queue;
            this.workerLease = workerLease;
            this.cancellationToken = cancellationToken;
            this.coordinationService = coordinationService;
            this.workerLeaseService = workerLeaseService;
        }

        @Override
        public void run() {
            WorkItem workItem;
            boolean releaseLeaseOnCompletion;
            AtomicLong busy = new AtomicLong(0L);
            Timer totalTimer = Time.startTimer();
            Timer executionTimer = Time.startTimer();
            if (this.workerLease == null) {
                this.workerLease = this.workerLeaseService.newWorkerLease();
                releaseLeaseOnCompletion = true;
            } else {
                releaseLeaseOnCompletion = false;
            }
            while ((workItem = this.getNextItem(this.workerLease)) != null) {
                Object selected = workItem.selection.getItem();
                LOGGER.info("{} ({}) started.", selected, (Object)Thread.currentThread());
                executionTimer.reset();
                this.execute(selected, workItem.plan, workItem.executor);
                long duration = executionTimer.getElapsedMillis();
                busy.addAndGet(duration);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("{} ({}) completed. Took {}.", new Object[]{selected, Thread.currentThread(), TimeFormatting.formatDurationVerbose(duration)});
            }
            if (releaseLeaseOnCompletion) {
                this.coordinationService.withStateLock(() -> this.workerLease.unlock());
            }
            long total = totalTimer.getElapsedMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Execution worker [{}] finished, busy: {}, idle: {}", new Object[]{Thread.currentThread(), TimeFormatting.formatDurationVerbose(busy.get()), TimeFormatting.formatDurationVerbose(total - busy.get())});
            }
        }

        @Nullable
        private WorkItem getNextItem(WorkerLeaseRegistry.WorkerLease workerLease) {
            MutableReference selected = MutableReference.empty();
            this.coordinationService.withStateLock(resourceLockState -> {
                WorkSource.Selection<WorkItem> workItem;
                WorkSource.State state2;
                if (this.cancellationToken.isCancellationRequested()) {
                    this.queue.cancelExecution();
                }
                if ((state2 = this.queue.executionState()) == WorkSource.State.NoMoreWorkToStart) {
                    return ResourceLockState.Disposition.FINISHED;
                }
                if (state2 == WorkSource.State.NoWorkReadyToStart) {
                    if (workerLease.isLockedByCurrentThread()) {
                        workerLease.unlock();
                    }
                    return ResourceLockState.Disposition.RETRY;
                }
                boolean hasWorkerLease = workerLease.isLockedByCurrentThread();
                if (!hasWorkerLease && !workerLease.tryLock()) {
                    return ResourceLockState.Disposition.RETRY;
                }
                try {
                    workItem = this.queue.selectNext();
                }
                catch (Throwable t) {
                    resourceLockState.releaseLocks();
                    this.queue.abortAllAndFail(t);
                    return ResourceLockState.Disposition.FINISHED;
                }
                if (workItem.isNoMoreWorkToStart()) {
                    return ResourceLockState.Disposition.FINISHED;
                }
                if (workItem.isNoWorkReadyToStart()) {
                    workerLease.unlock();
                    return ResourceLockState.Disposition.RETRY;
                }
                selected.set(workItem.getItem());
                return ResourceLockState.Disposition.FINISHED;
            });
            return (WorkItem)selected.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Object selected, WorkSource<Object> executionPlan, Action<Object> worker) {
            Throwable failure = null;
            try {
                try {
                    worker.execute(selected);
                }
                catch (Throwable t) {
                    failure = t;
                }
            }
            finally {
                this.markFinished(selected, executionPlan, failure);
            }
        }

        private void markFinished(Object selected, WorkSource<Object> executionPlan, @Nullable Throwable failure) {
            this.coordinationService.withStateLock(() -> {
                try {
                    executionPlan.finishedExecuting(selected, failure);
                }
                catch (Throwable t) {
                    this.queue.abortAllAndFail(t);
                }
                this.coordinationService.notifyStateChange();
            });
        }
    }

    private static class MergedQueues
    implements Closeable {
        private final ResourceLockCoordinationService coordinationService;
        private final boolean autoFinish;
        private boolean finished;
        private final LinkedList<PlanDetails> queues = new LinkedList();

        public MergedQueues(ResourceLockCoordinationService coordinationService, boolean autoFinish) {
            this.coordinationService = coordinationService;
            this.autoFinish = autoFinish;
        }

        public WorkSource.State executionState() {
            this.coordinationService.assertHasStateLock();
            Iterator iterator = this.queues.iterator();
            while (iterator.hasNext()) {
                PlanDetails details = (PlanDetails)iterator.next();
                WorkSource.State state2 = details.source.executionState();
                if (state2 == WorkSource.State.NoMoreWorkToStart) {
                    if (!details.source.allExecutionComplete()) continue;
                    iterator.remove();
                    continue;
                }
                if (state2 != WorkSource.State.MaybeWorkReadyToStart) continue;
                return WorkSource.State.MaybeWorkReadyToStart;
            }
            if (this.nothingMoreToStart()) {
                return WorkSource.State.NoMoreWorkToStart;
            }
            return WorkSource.State.NoWorkReadyToStart;
        }

        public WorkSource.Selection<WorkItem> selectNext() {
            this.coordinationService.assertHasStateLock();
            Iterator iterator = this.queues.iterator();
            while (iterator.hasNext()) {
                PlanDetails details = (PlanDetails)iterator.next();
                WorkSource.Selection<Object> selection = details.source.selectNext();
                if (selection.isNoMoreWorkToStart()) {
                    if (!details.source.allExecutionComplete()) continue;
                    iterator.remove();
                    continue;
                }
                if (selection.isNoWorkReadyToStart()) continue;
                return WorkSource.Selection.of(new WorkItem(selection, details.source, details.worker));
            }
            if (this.nothingMoreToStart()) {
                return WorkSource.Selection.noMoreWorkToStart();
            }
            return WorkSource.Selection.noWorkReadyToStart();
        }

        private boolean nothingMoreToStart() {
            return this.finished || this.autoFinish && this.queues.isEmpty();
        }

        public void add(PlanDetails planDetails) {
            this.coordinationService.withStateLock(() -> {
                if (this.finished) {
                    throw new IllegalStateException("This queue has been closed.");
                }
                this.queues.addFirst(planDetails);
                this.coordinationService.notifyStateChange();
            });
        }

        public void removeFinishedPlans() {
            this.coordinationService.assertHasStateLock();
            this.queues.removeIf(details -> details.source.allExecutionComplete());
        }

        @Override
        public void close() throws IOException {
            this.coordinationService.withStateLock(() -> {
                this.finished = true;
                if (!this.queues.isEmpty()) {
                    throw new IllegalStateException("Not all work has completed.");
                }
                this.coordinationService.notifyStateChange();
            });
        }

        public void cancelExecution() {
            this.coordinationService.assertHasStateLock();
            for (PlanDetails details : this.queues) {
                details.source.cancelExecution();
            }
        }

        public void abortAllAndFail(Throwable t) {
            this.coordinationService.assertHasStateLock();
            for (PlanDetails details : this.queues) {
                details.source.abortAllAndFail(t);
            }
        }

        public void assertHealthy() {
            this.coordinationService.assertHasStateLock();
            if (this.queues.isEmpty()) {
                return;
            }
            for (PlanDetails planDetails : this.queues) {
                if (!planDetails.source.canMakeProgress()) continue;
                return;
            }
            ArrayList<WorkSource.Diagnostics> allDiagnostics = new ArrayList<WorkSource.Diagnostics>(this.queues.size());
            for (PlanDetails planDetails : this.queues) {
                allDiagnostics.add(planDetails.source.healthDiagnostics());
            }
            TreeFormatter treeFormatter = new TreeFormatter();
            treeFormatter.node("Unable to make progress running work. The following items are queued for execution but none of them can be started:");
            treeFormatter.startChildren();
            for (WorkSource.Diagnostics diagnostics : allDiagnostics) {
                diagnostics.describeTo(treeFormatter);
            }
            treeFormatter.endChildren();
            System.out.println(treeFormatter);
            IllegalStateException illegalStateException = new IllegalStateException("Unable to make progress running work. There are items queued for execution but none of them can be started");
            this.abortAllAndFail(illegalStateException);
            this.coordinationService.notifyStateChange();
        }
    }

    private static class WorkItem {
        final WorkSource.Selection<Object> selection;
        final WorkSource<Object> plan;
        final Action<Object> executor;

        public WorkItem(WorkSource.Selection<Object> selection, WorkSource<Object> plan, Action<Object> executor) {
            this.selection = selection;
            this.plan = plan;
            this.executor = executor;
        }
    }

    private static class PlanDetails {
        final WorkSource<Object> source;
        final Action<Object> worker;

        public PlanDetails(WorkSource<Object> source, Action<Object> worker) {
            this.source = source;
            this.worker = worker;
        }
    }
}

