/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import javax.annotation.Nullable;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.resources.ResourceLock;

public class ActionNode
extends Node
implements SelfExecutingNode {
    private WorkNodeAction action;
    private final ProjectInternal owningProject;
    private final ProjectInternal projectToLock;

    public ActionNode(WorkNodeAction action) {
        this.action = action;
        this.owningProject = (ProjectInternal)action.getOwningProject();
        this.projectToLock = this.owningProject != null && action.usesMutableProjectState() ? this.owningProject : null;
    }

    @Override
    @Nullable
    public Throwable getNodeFailure() {
        return null;
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
        TaskDependencyContainer dependencies = this.action::visitDependencies;
        for (Node node : dependencyResolver.resolveDependenciesFor(null, dependencies)) {
            this.addDependencySuccessor(node);
        }
    }

    public WorkNodeAction getAction() {
        return this.action;
    }

    @Override
    public String toString() {
        return "work action " + this.action;
    }

    @Override
    public int compareTo(Node other) {
        if (other instanceof LocalTaskNode) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isPriority() {
        return this.getProjectToLock() != null;
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        if (this.projectToLock != null) {
            return this.projectToLock.getOwner().getAccessLock();
        }
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return this.owningProject;
    }

    @Override
    public void execute(NodeExecutionContext context) {
        try {
            this.action.run(context);
        }
        finally {
            this.action = null;
        }
    }
}

