/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultBuildConfigurationActionExecuter
implements BuildConfigurationActionExecuter {
    private List<? extends BuildConfigurationAction> taskSelectors;

    public DefaultBuildConfigurationActionExecuter(Iterable<? extends BuildConfigurationAction> defaultTaskSelectors) {
        this.taskSelectors = Lists.newArrayList(defaultTaskSelectors);
    }

    @Override
    public void select(GradleInternal gradle, ExecutionPlan plan) {
        gradle.getOwner().getProjects().withMutableStateOfAllProjects(() -> this.configure(this.taskSelectors, gradle, plan, 0));
    }

    @Override
    public void setTaskSelectors(List<? extends BuildConfigurationAction> taskSelectors) {
        this.taskSelectors = taskSelectors;
    }

    private void configure(final List<? extends BuildConfigurationAction> processingConfigurationActions, final GradleInternal gradle, final ExecutionPlan plan, final int index) {
        if (index >= processingConfigurationActions.size()) {
            return;
        }
        processingConfigurationActions.get(index).configure(new BuildExecutionContext(){

            @Override
            public GradleInternal getGradle() {
                return gradle;
            }

            @Override
            public ExecutionPlan getExecutionPlan() {
                return plan;
            }

            @Override
            public void proceed() {
                DefaultBuildConfigurationActionExecuter.this.configure(processingConfigurationActions, gradle, plan, index + 1);
            }
        });
    }
}

