/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configurationcache.initialization.ConfigurationCacheProblemsListener;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyProblemKt;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.internal.DisplayName;
import org.gradle.internal.execution.TaskExecutionTracker;
import org.gradle.internal.impldep.org.jetbrains.annotations.NotNull;
import org.gradle.internal.impldep.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gradle/configurationcache/initialization/DefaultConfigurationCacheProblemsListener;", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheProblemsListener;", "problems", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "userCodeApplicationContext", "Lorg/gradle/configuration/internal/UserCodeApplicationContext;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "taskExecutionTracker", "Lorg/gradle/internal/execution/TaskExecutionTracker;", "featurePreviews", "Lorg/gradle/api/internal/FeaturePreviews;", "(Lorg/gradle/configurationcache/problems/ProblemsListener;Lorg/gradle/configuration/internal/UserCodeApplicationContext;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/internal/execution/TaskExecutionTracker;Lorg/gradle/api/internal/FeaturePreviews;)V", "atConfigurationTime", "", "isBuildSrcBuild", "invocationSource", "", "listenerRegistrationProblem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "trace", "Lorg/gradle/configurationcache/problems/PropertyTrace;", "invocationDescription", "", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "onBuildScopeListenerRegistration", "", "listener", "onExternalProcessStarted", "command", "consumer", "onProjectAccess", "task", "Lorg/gradle/api/internal/TaskInternal;", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "problemsListenerFor", "propertyTraceForTask", "configuration-cache"})
public final class DefaultConfigurationCacheProblemsListener
implements ConfigurationCacheProblemsListener {
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final UserCodeApplicationContext userCodeApplicationContext;
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final TaskExecutionTracker taskExecutionTracker;
    @NotNull
    private final FeaturePreviews featurePreviews;

    public DefaultConfigurationCacheProblemsListener(@NotNull ProblemsListener problems, @NotNull UserCodeApplicationContext userCodeApplicationContext, @NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull TaskExecutionTracker taskExecutionTracker, @NotNull FeaturePreviews featurePreviews) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)userCodeApplicationContext, (String)"userCodeApplicationContext");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)taskExecutionTracker, (String)"taskExecutionTracker");
        Intrinsics.checkNotNullParameter((Object)featurePreviews, (String)"featurePreviews");
        this.problems = problems;
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.taskExecutionTracker = taskExecutionTracker;
        this.featurePreviews = featurePreviews;
    }

    @Override
    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.atConfigurationTime()) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    @Override
    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.atConfigurationTime()) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    @Override
    public void onExternalProcessStarted(@NotNull String command, @Nullable String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.STABLE_CONFIGURATION_CACHE) || !this.atConfigurationTime() || this.taskExecutionTracker.getCurrentTask().isPresent()) {
            return;
        }
        this.problems.onProblem(new PropertyProblem(PropertyProblemKt.location(this.userCodeApplicationContext, consumer), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(command){
            final /* synthetic */ String $command;
            {
                this.$command = $command;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("external process started ");
                $this$build.reference(this.$command);
            }
        })), new InvalidUserCodeException("Starting an external process '" + command + "' during configuration time is unsupported."), DocumentationSection.RequirementsExternalProcess));
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task) {
        this.problemsListenerFor(task).onProblem(new PropertyProblem(this.propertyTraceForTask(task), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;
            {
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("invocation of ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" at execution time is unsupported.");
            }
        })), new InvalidUserCodeException("Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported."), DocumentationSection.RequirementsUseProjectDuringExecution));
    }

    private final ProblemsListener problemsListenerFor(TaskInternal task) {
        return task.isCompatibleWithConfigurationCache() ? this.problems : this.problems.forIncompatibleType();
    }

    private final PropertyTrace propertyTraceForTask(TaskInternal task) {
        PropertyTrace propertyTrace;
        DisplayName displayName;
        UserCodeApplicationContext.Application application = this.userCodeApplicationContext.current();
        if (application != null && (displayName = application.getDisplayName()) != null) {
            DisplayName p0 = displayName;
            boolean bl = false;
            propertyTrace = new PropertyTrace.BuildLogic(p0);
        } else {
            Class<?> clazz = GeneratedSubclasses.unpackType(task);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"unpackType(task)");
            String string2 = task.getIdentityPath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
            propertyTrace = new PropertyTrace.Task(clazz, string2);
        }
        return propertyTrace;
    }

    @Override
    public void onBuildScopeListenerRegistration(@NotNull Object listener2, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (this.isBuildSrcBuild(invocationSource)) {
            return;
        }
        this.problems.onProblem(this.listenerRegistrationProblem(PropertyProblemKt.location(this.userCodeApplicationContext, null), invocationDescription, new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.")));
    }

    private final PropertyProblem listenerRegistrationProblem(PropertyTrace trace, String invocationDescription, InvalidUserCodeException exception) {
        return new PropertyProblem(trace, StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;
            {
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
        })), exception, DocumentationSection.RequirementsBuildListeners);
    }

    private final boolean isBuildSrcBuild(Object invocationSource) {
        boolean bl;
        GradleInternal gradleInternal = invocationSource instanceof GradleInternal ? (GradleInternal)invocationSource : null;
        if (gradleInternal != null) {
            GradleInternal $this$isBuildSrcBuild_u24lambda_u2d0 = gradleInternal;
            boolean bl2 = false;
            bl = !$this$isBuildSrcBuild_u24lambda_u2d0.isRootBuild() && Intrinsics.areEqual((Object)$this$isBuildSrcBuild_u24lambda_u2d0.getIdentityPath().getName(), (Object)"buildSrc");
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean atConfigurationTime() {
        return this.configurationTimeBarrier.isAtConfigurationTime();
    }
}

