/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CleanupActionFactory;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.internal.streams.DefaultValueStore;
import org.gradle.cache.internal.streams.ValueStore;
import org.gradle.cache.scopes.BuildTreeScopedCache;
import org.gradle.configurationcache.ConfigurationCacheRepository;
import org.gradle.configurationcache.ConfigurationCacheStateFile;
import org.gradle.configurationcache.ConfigurationCacheStateStore;
import org.gradle.configurationcache.StateType;
import org.gradle.configurationcache.extensions.StringExtensionsKt;
import org.gradle.configurationcache.extensions.UnsafeLazyKt;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;
import org.gradle.internal.impldep.org.jetbrains.annotations.NotNull;
import org.gradle.internal.impldep.org.jetbrains.annotations.Nullable;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001:\u0006789:;<B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001fH\u0002J\b\u0010*\u001a\u00020\u001dH\u0016J/\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u00020\u001f2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H,0/H\u0002\u00a2\u0006\u0002\u00100J\u0014\u00101\u001a\u00020\u001f*\u00020\f2\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0014\u0010)\u001a\u00020\u001f*\u00020\u001f2\u0006\u00102\u001a\u00020\u0019H\u0002J\u0014\u00103\u001a\u000204*\u0002042\u0006\u00105\u001a\u00020\u0005H\u0002J\f\u00106\u001a\u000204*\u000204H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006="}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheRepository;", "Lorg/gradle/internal/concurrent/Stoppable;", "cacheRepository", "Lorg/gradle/cache/scopes/BuildTreeScopedCache;", "cacheCleanupFactory", "Lorg/gradle/cache/internal/CleanupActionFactory;", "fileAccessTimeJournal", "Lorg/gradle/internal/file/FileAccessTimeJournal;", "fileSystem", "Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;", "(Lorg/gradle/cache/scopes/BuildTreeScopedCache;Lorg/gradle/cache/internal/CleanupActionFactory;Lorg/gradle/internal/file/FileAccessTimeJournal;Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;)V", "cache", "Lorg/gradle/cache/PersistentCache;", "cleanupDepth", "", "cleanupMaxAgeDays", "", "fileAccessTracker", "Lorg/gradle/internal/file/impl/SingleDepthFileAccessTracker;", "getFileAccessTracker", "()Lorg/gradle/internal/file/impl/SingleDepthFileAccessTracker;", "fileAccessTracker$delegate", "Lkotlin/Lazy;", "fileBaseName", "", "Lorg/gradle/configurationcache/StateType;", "getFileBaseName", "(Lorg/gradle/configurationcache/StateType;)Ljava/lang/String;", "chmod", "", "file", "Ljava/io/File;", "mode", "forKey", "Lorg/gradle/configurationcache/ConfigurationCacheStateStore;", "cacheKey", "includedBuildFileFor", "parentStateFile", "build", "Lorg/gradle/api/internal/BuildDefinition;", "markAccessed", "stateFile", "stop", "withExclusiveAccessToCache", "T", "baseDir", "action", "Lkotlin/Function1;", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "baseDirFor", "stateType", "withLruCacheCleanup", "Lorg/gradle/cache/CacheBuilder;", "cleanupActionFactory", "withOnDemandLockMode", "Layout", "ReadableConfigurationCacheStateFile", "ReadableLayout", "StoreImpl", "WriteableConfigurationCacheStateFile", "WriteableLayout", "configuration-cache"})
public final class ConfigurationCacheRepository
implements Stoppable {
    @NotNull
    private final FileAccessTimeJournal fileAccessTimeJournal;
    @NotNull
    private final FileSystem fileSystem;
    private final int cleanupDepth;
    private final long cleanupMaxAgeDays;
    @NotNull
    private final PersistentCache cache;
    @NotNull
    private final Lazy fileAccessTracker$delegate;

    public ConfigurationCacheRepository(@NotNull BuildTreeScopedCache cacheRepository, @NotNull CleanupActionFactory cacheCleanupFactory, @NotNull FileAccessTimeJournal fileAccessTimeJournal, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)cacheRepository, (String)"cacheRepository");
        Intrinsics.checkNotNullParameter((Object)cacheCleanupFactory, (String)"cacheCleanupFactory");
        Intrinsics.checkNotNullParameter((Object)fileAccessTimeJournal, (String)"fileAccessTimeJournal");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileAccessTimeJournal = fileAccessTimeJournal;
        this.fileSystem = fileSystem;
        this.cleanupDepth = 1;
        this.cleanupMaxAgeDays = 7L;
        CacheBuilder cacheBuilder = cacheRepository.crossVersionCache("configuration-cache").withDisplayName("Configuration Cache");
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"cacheRepository\n        \u2026me(\"Configuration Cache\")");
        PersistentCache persistentCache = this.withLruCacheCleanup(this.withOnDemandLockMode(cacheBuilder), cacheCleanupFactory).open();
        Intrinsics.checkNotNullExpressionValue((Object)persistentCache, (String)"cacheRepository\n        \u2026pFactory)\n        .open()");
        this.cache = persistentCache;
        this.fileAccessTracker$delegate = UnsafeLazyKt.unsafeLazy((Function0)new Function0<SingleDepthFileAccessTracker>(this){
            final /* synthetic */ ConfigurationCacheRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SingleDepthFileAccessTracker invoke() {
                return new SingleDepthFileAccessTracker(ConfigurationCacheRepository.access$getFileAccessTimeJournal$p(this.this$0), ConfigurationCacheRepository.access$getCache$p(this.this$0).getBaseDir(), ConfigurationCacheRepository.access$getCleanupDepth$p(this.this$0));
            }
        });
    }

    @NotNull
    public final ConfigurationCacheStateStore forKey(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return new StoreImpl(this.baseDirFor(this.cache, cacheKey));
    }

    @Override
    public void stop() {
        this.cache.close();
    }

    private final File includedBuildFileFor(File parentStateFile, BuildDefinition build) {
        File $this$includedBuildFileFor_u24lambda_u2d0 = parentStateFile;
        boolean bl = false;
        return FilesKt.resolveSibling((File)$this$includedBuildFileFor_u24lambda_u2d0, (String)($this$includedBuildFileFor_u24lambda_u2d0.getName() + '.' + build.getName()));
    }

    private final CacheBuilder withOnDemandLockMode(CacheBuilder $this$withOnDemandLockMode) {
        CacheBuilder cacheBuilder = $this$withOnDemandLockMode.withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand));
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"withLockOptions(LockOpti\u2026nager.LockMode.OnDemand))");
        return cacheBuilder;
    }

    private final CacheBuilder withLruCacheCleanup(CacheBuilder $this$withLruCacheCleanup, CleanupActionFactory cleanupActionFactory) {
        CacheBuilder cacheBuilder = $this$withLruCacheCleanup.withCleanup(cleanupActionFactory.create(new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(this.cleanupDepth), this.fileAccessTimeJournal, this.cleanupMaxAgeDays)));
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"withCleanup(\n           \u2026)\n            )\n        )");
        return cacheBuilder;
    }

    private final SingleDepthFileAccessTracker getFileAccessTracker() {
        Lazy lazy = this.fileAccessTracker$delegate;
        return (SingleDepthFileAccessTracker)lazy.getValue();
    }

    private final void chmod(File file, int mode) {
        this.fileSystem.chmod(file, mode);
    }

    private final void markAccessed(File stateFile) {
        this.getFileAccessTracker().markAccessed(stateFile);
    }

    private final <T> T withExclusiveAccessToCache(File baseDir, Function1<? super File, ? extends T> action) {
        return this.cache.withFileLock(new Factory(action, baseDir){
            final /* synthetic */ Function1<File, T> $action;
            final /* synthetic */ File $baseDir;
            {
                this.$action = $action;
                this.$baseDir = $baseDir;
            }

            @Nullable
            public final T create() {
                return (T)this.$action.invoke((Object)this.$baseDir);
            }
        });
    }

    private final File baseDirFor(PersistentCache $this$baseDirFor, String cacheKey) {
        File file = $this$baseDirFor.getBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"baseDir");
        return FilesKt.resolve((File)file, (String)cacheKey);
    }

    private final String getFileBaseName(StateType $this$fileBaseName) {
        return StringExtensionsKt.toDefaultLowerCase($this$fileBaseName.name());
    }

    private final File stateFile(File $this$stateFile, StateType stateType) {
        return FilesKt.resolve((File)$this$stateFile, (String)(this.getFileBaseName(stateType) + ".bin"));
    }

    public static final /* synthetic */ void access$chmod(ConfigurationCacheRepository $this, File file, int mode) {
        $this.chmod(file, mode);
    }

    public static final /* synthetic */ FileAccessTimeJournal access$getFileAccessTimeJournal$p(ConfigurationCacheRepository $this) {
        return $this.fileAccessTimeJournal;
    }

    public static final /* synthetic */ PersistentCache access$getCache$p(ConfigurationCacheRepository $this) {
        return $this.cache;
    }

    public static final /* synthetic */ int access$getCleanupDepth$p(ConfigurationCacheRepository $this) {
        return $this.cleanupDepth;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\b"}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheRepository$Layout;", "", "()V", "fileFor", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "stateType", "Lorg/gradle/configurationcache/StateType;", "fileForRead", "configuration-cache"})
    public static abstract class Layout {
        @NotNull
        public abstract ConfigurationCacheStateFile fileForRead(@NotNull StateType var1);

        @NotNull
        public abstract ConfigurationCacheStateFile fileFor(@NotNull StateType var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheRepository$WriteableLayout;", "Lorg/gradle/configurationcache/ConfigurationCacheRepository$Layout;", "cacheDir", "Ljava/io/File;", "onFileAccess", "Lkotlin/Function1;", "", "(Lorg/gradle/configurationcache/ConfigurationCacheRepository;Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "fileFor", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "stateType", "Lorg/gradle/configurationcache/StateType;", "fileForRead", "Lorg/gradle/configurationcache/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile;", "Lorg/gradle/configurationcache/ConfigurationCacheRepository;", "configuration-cache"})
    private final class WriteableLayout
    extends Layout {
        @NotNull
        private final File cacheDir;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public WriteableLayout(@NotNull File cacheDir, Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.cacheDir = cacheDir;
            this.onFileAccess = onFileAccess;
        }

        @Override
        @NotNull
        public ReadableConfigurationCacheStateFile fileForRead(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepository.this.stateFile(this.cacheDir, stateType));
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileFor(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepository.this.stateFile(this.cacheDir, stateType), this.onFileAccess);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheRepository$ReadableLayout;", "Lorg/gradle/configurationcache/ConfigurationCacheRepository$Layout;", "cacheDir", "Ljava/io/File;", "(Lorg/gradle/configurationcache/ConfigurationCacheRepository;Ljava/io/File;)V", "fileFor", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "stateType", "Lorg/gradle/configurationcache/StateType;", "fileForRead", "configuration-cache"})
    private final class ReadableLayout
    extends Layout {
        @NotNull
        private final File cacheDir;

        public ReadableLayout(File cacheDir) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            this.cacheDir = cacheDir;
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileForRead(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return this.fileFor(stateType);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileFor(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepository.this.stateFile(this.cacheDir, stateType));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile;", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "file", "Ljava/io/File;", "(Lorg/gradle/configurationcache/ConfigurationCacheRepository;Ljava/io/File;)V", "exists", "", "getExists", "()Z", "delete", "", "inputStream", "Ljava/io/InputStream;", "moveFrom", "outputStream", "Ljava/io/OutputStream;", "stateFileForIncludedBuild", "build", "Lorg/gradle/api/internal/BuildDefinition;", "configuration-cache"})
    private final class ReadableConfigurationCacheStateFile
    implements ConfigurationCacheStateFile {
        @NotNull
        private final File file;

        public ReadableConfigurationCacheStateFile(File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
        }

        @Override
        public boolean getExists() {
            return this.file.isFile();
        }

        @Override
        @NotNull
        public OutputStream outputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public InputStream inputStream() {
            File file = this.file;
            ConfigurationCacheRepository configurationCacheRepository = ConfigurationCacheRepository.this;
            File p0 = file;
            boolean bl = false;
            configurationCacheRepository.markAccessed(p0);
            return new FileInputStream(file);
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveFrom(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForIncludedBuild(@NotNull BuildDefinition build) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepository.this.includedBuildFileFor(this.file, build));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheRepository$WriteableConfigurationCacheStateFile;", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "file", "Ljava/io/File;", "onFileAccess", "Lkotlin/Function1;", "", "(Lorg/gradle/configurationcache/ConfigurationCacheRepository;Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "exists", "", "getExists", "()Z", "delete", "inputStream", "Ljava/io/InputStream;", "moveFrom", "outputStream", "Ljava/io/OutputStream;", "stateFileForIncludedBuild", "build", "Lorg/gradle/api/internal/BuildDefinition;", "configuration-cache"})
    private final class WriteableConfigurationCacheStateFile
    implements ConfigurationCacheStateFile {
        @NotNull
        private final File file;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public WriteableConfigurationCacheStateFile(@NotNull File file, Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.file = file;
            this.onFileAccess = onFileAccess;
        }

        @Override
        public boolean getExists() {
            return false;
        }

        @Override
        @NotNull
        public OutputStream outputStream() {
            File file = this.file;
            this.onFileAccess.invoke((Object)file);
            return new FileOutputStream(file);
        }

        @Override
        @NotNull
        public InputStream inputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete() {
            if (this.file.exists()) {
                Files.delete(this.file.toPath());
            }
        }

        @Override
        public void moveFrom(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(file.toPath(), this.file.toPath(), copyOptionArray);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForIncludedBuild(@NotNull BuildDefinition build) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepository.this.includedBuildFileFor(this.file, build), this.onFileAccess);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J8\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0016J+\u0010\u000f\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\n0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J3\u0010\u000f\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\n0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00180\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheRepository$StoreImpl;", "Lorg/gradle/configurationcache/ConfigurationCacheStateStore;", "baseDir", "Ljava/io/File;", "(Lorg/gradle/configurationcache/ConfigurationCacheRepository;Ljava/io/File;)V", "assignSpoolFile", "stateType", "Lorg/gradle/configurationcache/StateType;", "createValueStore", "Lorg/gradle/cache/internal/streams/ValueStore;", "T", "writer", "Lorg/gradle/cache/internal/streams/ValueStore$Writer;", "reader", "Lorg/gradle/cache/internal/streams/ValueStore$Reader;", "useForStateLoad", "", "action", "Lkotlin/Function1;", "Lorg/gradle/configurationcache/ConfigurationCacheRepository$Layout;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/gradle/configurationcache/ConfigurationCacheStateFile;", "(Lorg/gradle/configurationcache/StateType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useForStore", "", "configuration-cache"})
    private final class StoreImpl
    implements ConfigurationCacheStateStore {
        @NotNull
        private final File baseDir;

        public StoreImpl(File baseDir) {
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            this.baseDir = baseDir;
        }

        @Override
        @NotNull
        public File assignSpoolFile(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Files.createDirectories(this.baseDir.toPath(), new FileAttribute[0]);
            File file = Files.createTempFile(this.baseDir.toPath(), ConfigurationCacheRepository.this.getFileBaseName(stateType), ".tmp", new FileAttribute[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(baseDir.t\u2026aseName, \".tmp\").toFile()");
            return file;
        }

        @Override
        @NotNull
        public <T> ValueStore<T> createValueStore(@NotNull StateType stateType, @NotNull ValueStore.Writer<T> writer2, @NotNull ValueStore.Reader<T> reader2) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(writer2, (String)"writer");
            Intrinsics.checkNotNullParameter(reader2, (String)"reader");
            return new DefaultValueStore<T>(this.baseDir, ConfigurationCacheRepository.this.getFileBaseName(stateType), writer2, reader2);
        }

        @Override
        @NotNull
        public <T> T useForStateLoad(@NotNull StateType stateType, @NotNull Function1<? super ConfigurationCacheStateFile, ? extends T> action) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return this.useForStateLoad((Function1)new Function1<Layout, T>(action, stateType){
                final /* synthetic */ Function1<ConfigurationCacheStateFile, T> $action;
                final /* synthetic */ StateType $stateType;
                {
                    this.$action = $action;
                    this.$stateType = $stateType;
                    super(1);
                }

                @NotNull
                public final T invoke(@NotNull Layout layout2) {
                    Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
                    return (T)this.$action.invoke((Object)layout2.fileFor(this.$stateType));
                }
            });
        }

        @Override
        @NotNull
        public <T> T useForStateLoad(@NotNull Function1<? super Layout, ? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return (T)ConfigurationCacheRepository.this.withExclusiveAccessToCache(this.baseDir, new Function1<File, T>(action, ConfigurationCacheRepository.this){
                final /* synthetic */ Function1<Layout, T> $action;
                final /* synthetic */ ConfigurationCacheRepository this$0;
                {
                    this.$action = $action;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final T invoke(@NotNull File cacheDir) {
                    Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
                    return (T)this.$action.invoke((Object)this.this$0.new ReadableLayout(cacheDir));
                }
            });
        }

        @Override
        public void useForStore(@NotNull Function1<? super Layout, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            ConfigurationCacheRepository.this.withExclusiveAccessToCache(this.baseDir, (Function1)new Function1<File, Unit>(ConfigurationCacheRepository.this, action){
                final /* synthetic */ ConfigurationCacheRepository this$0;
                final /* synthetic */ Function1<Layout, Unit> $action;
                {
                    this.this$0 = $receiver;
                    this.$action = $action;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull File cacheDir) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
                    Files.createDirectories(cacheDir.toPath(), new FileAttribute[0]);
                    ConfigurationCacheRepository.access$chmod(this.this$0, cacheDir, 448);
                    ConfigurationCacheRepository.access$markAccessed(this.this$0, cacheDir);
                    List stateFiles = new ArrayList<E>();
                    WriteableLayout layout2 = this.this$0.new WriteableLayout(cacheDir, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>((Object)stateFiles){

                        public final void invoke(@NotNull File p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((List)useForStore.layout.1.access$getReceiver$p(this)).add(p0);
                        }

                        public static final /* synthetic */ Object access$getReceiver$p(useForStore.layout.1 $this) {
                            return $this.receiver;
                        }
                    }));
                    try {
                        this.$action.invoke((Object)layout2);
                    }
                    catch (Throwable throwable) {
                        void $this$forEach$iv2;
                        Sequence sequence2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)stateFiles), (Function1)useForStore.1.INSTANCE);
                        ConfigurationCacheRepository configurationCacheRepository = this.this$0;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv2) {
                            File it = (File)element$iv;
                            boolean bl = false;
                            ConfigurationCacheRepository.access$chmod(configurationCacheRepository, it, 384);
                        }
                        throw throwable;
                    }
                    Sequence sequence3 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)stateFiles), (Function1)useForStore.1.INSTANCE);
                    ConfigurationCacheRepository configurationCacheRepository = this.this$0;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        File it = (File)element$iv;
                        boolean bl = false;
                        ConfigurationCacheRepository.access$chmod(configurationCacheRepository, it, 384);
                    }
                }
            });
        }
    }
}

