/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleControllerFactory;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.util.Path;

class DefaultNestedBuild
extends AbstractBuildState
implements StandAloneNestedBuild {
    private final Path identityPath;
    private final BuildState owner;
    private final BuildIdentifier buildIdentifier;
    private final BuildDefinition buildDefinition;
    private final BuildTreeLifecycleController buildTreeLifecycleController;

    DefaultNestedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, BuildState owner, BuildTreeState buildTree) {
        super(buildTree, buildDefinition, owner);
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.owner = owner;
        BuildScopeServices buildScopeServices = this.getBuildServices();
        ExceptionAnalyser exceptionAnalyser = buildScopeServices.get(ExceptionAnalyser.class);
        BuildModelParameters modelParameters = buildScopeServices.get(BuildModelParameters.class);
        DefaultBuildTreeWorkExecutor workExecutor = new DefaultBuildTreeWorkExecutor();
        BuildTreeLifecycleControllerFactory buildTreeLifecycleControllerFactory = buildScopeServices.get(BuildTreeLifecycleControllerFactory.class);
        BuildTreeFinishExecutor finishExecutor = modelParameters.isRequiresBuildModel() ? new DoNothingBuildFinishExecutor(exceptionAnalyser) : new FinishThisBuildOnlyFinishExecutor(exceptionAnalyser);
        this.buildTreeLifecycleController = buildTreeLifecycleControllerFactory.createController(this.getBuildController(), workExecutor, finishExecutor);
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public boolean isImplicitBuild() {
        return true;
    }

    @Override
    public ExecutionResult<Void> finishBuild() {
        return this.getBuildController().finishBuild(null);
    }

    @Override
    public <T> T run(Function<? super BuildTreeLifecycleController, T> buildAction) {
        return buildAction.apply(this.buildTreeLifecycleController);
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildDefinition.getName());
    }

    @Override
    public Path calculateIdentityPathForProject(Path projectPath) {
        return this.getBuildController().getGradle().getIdentityPath().append(projectPath);
    }

    @Override
    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    private class FinishThisBuildOnlyFinishExecutor
    implements BuildTreeFinishExecutor {
        private final ExceptionAnalyser exceptionAnalyser;

        public FinishThisBuildOnlyFinishExecutor(ExceptionAnalyser exceptionAnalyser) {
            this.exceptionAnalyser = exceptionAnalyser;
        }

        @Override
        @Nullable
        public RuntimeException finishBuildTree(List<Throwable> failures) {
            RuntimeException reportable = this.exceptionAnalyser.transform(failures);
            ExecutionResult<Void> finishResult = DefaultNestedBuild.this.getBuildController().finishBuild(reportable);
            return this.exceptionAnalyser.transform(ExecutionResult.maybeFailed(reportable).withFailures(finishResult).getFailures());
        }
    }

    private static class DoNothingBuildFinishExecutor
    implements BuildTreeFinishExecutor {
        private final ExceptionAnalyser exceptionAnalyser;

        public DoNothingBuildFinishExecutor(ExceptionAnalyser exceptionAnalyser) {
            this.exceptionAnalyser = exceptionAnalyser;
        }

        @Override
        @Nullable
        public RuntimeException finishBuildTree(List<Throwable> failures) {
            return this.exceptionAnalyser.transform(failures);
        }
    }
}

