/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.internal.build.BuildState;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final BuildTreeWorkGraphController buildTreeWorkGraphController;
    private final BuildState currentBuild;

    public CompositeBuildClassPathInitializer(BuildTreeWorkGraphController buildTreeWorkGraphController, BuildState currentBuild) {
        this.buildTreeWorkGraphController = buildTreeWorkGraphController;
        this.currentBuild = currentBuild;
    }

    @Override
    public void execute(Configuration classpath) {
        ArrayList<TaskIdentifier.TaskBasedTaskIdentifier> tasksToBuild = new ArrayList<TaskIdentifier.TaskBasedTaskIdentifier>();
        for (Task task : classpath.getBuildDependencies().getDependencies(null)) {
            if (task.getState().getExecuted()) continue;
            BuildState targetBuild = ((ProjectInternal)task.getProject()).getOwner().getOwner();
            assert (targetBuild != this.currentBuild);
            tasksToBuild.add(TaskIdentifier.of(targetBuild.getBuildIdentifier(), (TaskInternal)task));
        }
        if (!tasksToBuild.isEmpty()) {
            this.buildTreeWorkGraphController.withNewWorkGraph(graph -> {
                graph.scheduleWork(builder -> {
                    for (TaskIdentifier taskIdentifier : tasksToBuild) {
                        this.buildTreeWorkGraphController.locateTask(taskIdentifier).queueForExecution();
                    }
                });
                graph.runWork().rethrow();
                return null;
            });
        }
    }
}

