/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.authentication.Authentication;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.http.HttpBuildCache;
import org.gradle.caching.http.HttpBuildCacheCredentials;
import org.gradle.caching.http.internal.HttpBuildCacheRequestCustomizer;
import org.gradle.caching.http.internal.HttpBuildCacheService;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;

public class DefaultHttpBuildCacheServiceFactory
implements BuildCacheServiceFactory<HttpBuildCache> {
    private static final int MAX_REDIRECTS = Integer.getInteger("org.gradle.cache.http.max-redirects", 10);
    private final SslContextFactory sslContextFactory;
    private final HttpBuildCacheRequestCustomizer requestCustomizer;
    private final HttpClientHelper.Factory httpClientHelperFactory;

    @Inject
    public DefaultHttpBuildCacheServiceFactory(SslContextFactory sslContextFactory, HttpBuildCacheRequestCustomizer requestCustomizer, HttpClientHelper.Factory httpClientHelperFactory) {
        this.sslContextFactory = sslContextFactory;
        this.requestCustomizer = requestCustomizer;
        this.httpClientHelperFactory = httpClientHelperFactory;
    }

    @Override
    public BuildCacheService createBuildCacheService(HttpBuildCache configuration2, BuildCacheServiceFactory.Describer describer) {
        URI url = configuration2.getUrl();
        if (url == null) {
            throw new IllegalStateException("HTTP build cache has no URL configured");
        }
        URI noUserInfoUrl = DefaultHttpBuildCacheServiceFactory.stripUserInfo(url);
        HttpBuildCacheCredentials credentials = configuration2.getCredentials();
        if (!DefaultHttpBuildCacheServiceFactory.credentialsPresent(credentials) && url.getUserInfo() != null) {
            credentials = DefaultHttpBuildCacheServiceFactory.extractCredentialsFromUserInfo(url);
        }
        List<Authentication> authentications = Collections.emptyList();
        if (DefaultHttpBuildCacheServiceFactory.credentialsPresent(credentials)) {
            DefaultBasicAuthentication basicAuthentication = new DefaultBasicAuthentication("basic");
            basicAuthentication.setCredentials(credentials);
            basicAuthentication.addHost(url.getHost(), url.getPort());
            authentications = Collections.singleton(basicAuthentication);
        }
        boolean authenticated = !authentications.isEmpty();
        boolean allowUntrustedServer = configuration2.isAllowUntrustedServer();
        boolean allowInsecureProtocol = configuration2.isAllowInsecureProtocol();
        boolean useExpectContinue = configuration2.isUseExpectContinue();
        HttpRedirectVerifier redirectVerifier = this.createRedirectVerifier(noUserInfoUrl, allowInsecureProtocol);
        DefaultHttpSettings.Builder builder = DefaultHttpSettings.builder().withAuthenticationSettings(authentications).maxRedirects(MAX_REDIRECTS).withRedirectMethodHandlingStrategy(HttpSettings.RedirectMethodHandlingStrategy.ALLOW_FOLLOW_FOR_MUTATIONS).withRedirectVerifier(redirectVerifier);
        if (allowUntrustedServer) {
            builder.allowUntrustedConnections();
        } else {
            builder.withSslContextFactory(this.sslContextFactory);
        }
        HttpClientHelper httpClientHelper = this.httpClientHelperFactory.create(builder.build());
        describer.type("HTTP").config("url", noUserInfoUrl.toASCIIString()).config("authenticated", Boolean.toString(authenticated)).config("allowUntrustedServer", Boolean.toString(allowUntrustedServer)).config("allowInsecureProtocol", Boolean.toString(allowInsecureProtocol)).config("useExpectContinue", Boolean.toString(useExpectContinue));
        return new HttpBuildCacheService(httpClientHelper, noUserInfoUrl, this.requestCustomizer, useExpectContinue);
    }

    private HttpRedirectVerifier createRedirectVerifier(URI url, boolean allowInsecureProtocol) {
        return HttpRedirectVerifierFactory.create(url, allowInsecureProtocol, () -> {
            String message2 = "Using insecure protocols with remote build cache, without explicit opt-in, is unsupported. Switch remote build cache to a secure protocol (like HTTPS) or allow insecure protocols. " + Documentation.dslReference(HttpBuildCache.class, "allowInsecureProtocol").consultDocumentationMessage();
            throw new InvalidUserCodeException(message2);
        }, redirect -> {
            throw new IllegalStateException("Redirects are unsupported by the build cache.");
        });
    }

    @VisibleForTesting
    static HttpBuildCacheCredentials extractCredentialsFromUserInfo(URI url) {
        HttpBuildCacheCredentials credentials = new HttpBuildCacheCredentials();
        String userInfo = url.getUserInfo();
        int indexOfSeparator = userInfo.indexOf(58);
        if (indexOfSeparator > -1) {
            String username = userInfo.substring(0, indexOfSeparator);
            String password = userInfo.substring(indexOfSeparator + 1);
            credentials.setUsername(username);
            credentials.setPassword(password);
        }
        return credentials;
    }

    private static URI stripUserInfo(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new GradleException("Error constructing URL for http build cache", e);
        }
    }

    private static boolean credentialsPresent(HttpBuildCacheCredentials credentials) {
        return credentials.getUsername() != null && credentials.getPassword() != null;
    }
}

