/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.CppProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ModuleNameBuilder;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

public abstract class SwiftProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final TemplateOperationFactory templateOperationFactory;
    private final DocumentationRegistry documentationRegistry;

    public SwiftProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, DocumentationRegistry documentationRegistry) {
        this.templateOperationFactory = templateOperationFactory;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public Language getLanguage() {
        return Language.SWIFT;
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.fileComment("This generated file contains a sample Swift project to get you started.").fileComment("For more details take a look at the Building Swift applications and libraries chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("building_swift_projects"));
        this.configureBuildScript(settings, buildScriptBuilder);
    }

    @Override
    public void generateConventionPluginBuildScript(String conventionPluginName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    @Override
    public void generateSources(InitSettings settings, TemplateFactory templateFactory) {
        TemplateOperation sourceTemplate = this.sourceTemplateOperation(settings);
        TemplateOperation testSourceTemplate = this.testTemplateOperation(settings);
        TemplateOperation testEntryPointTemplate = this.testEntryPointTemplateOperation(settings);
        templateFactory.whenNoSourcesAvailable(sourceTemplate, testSourceTemplate, testEntryPointTemplate).generate();
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Sets.newHashSet();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return null;
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.of(this.documentationRegistry.getSampleFor("building_swift_" + this.getComponentType().pluralName()));
    }

    protected abstract TemplateOperation sourceTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation testTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation testEntryPointTemplateOperation(InitSettings var1);

    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    protected String getHostTargetMachineDefinition() {
        DefaultNativePlatform host = DefaultNativePlatform.host();
        assert (!host.getOperatingSystem().isWindows());
        return CppProjectInitDescriptor.buildNativeHostTargetDefinition(host);
    }

    protected void configureTargetMachineDefinition(ScriptBlockBuilder buildScriptBuilder) {
        if (OperatingSystem.current().isWindows()) {
            buildScriptBuilder.methodInvocation("Swift tool chain does not support Windows. The following targets macOS and Linux:", "targetMachines.add", buildScriptBuilder.propertyExpression("machines.macOS.x86_64"));
            buildScriptBuilder.methodInvocation(null, "targetMachines.add", buildScriptBuilder.propertyExpression("machines.linux.x86_64"));
        } else {
            buildScriptBuilder.methodInvocation("Set the target operating system and architecture for this library", "targetMachines.add", buildScriptBuilder.propertyExpression(this.getHostTargetMachineDefinition()));
        }
    }

    TemplateOperation fromSwiftTemplate(String template, InitSettings settings, String sourceSetName, String sourceDir) {
        String targetFileName = template.substring(template.lastIndexOf("/") + 1).replace(".template", "");
        return this.fromSwiftTemplate(template, targetFileName, settings, sourceSetName, sourceDir);
    }

    TemplateOperation fromSwiftTemplate(String template, String targetFileName, InitSettings settings, String sourceSetName, String sourceDir) {
        if (settings == null || settings.getProjectName().isEmpty()) {
            throw new IllegalArgumentException("Project name cannot be empty for a Swift project");
        }
        String moduleName = ModuleNameBuilder.toModuleName(settings.getSubprojects().get(0));
        return this.templateOperationFactory.newTemplateOperation().withTemplate(template).withTarget(settings.getTarget().file(settings.getSubprojects().get(0) + "/src/" + sourceSetName + "/" + sourceDir + "/" + targetFileName).getAsFile()).withBinding("projectName", settings.getProjectName()).withBinding("moduleName", moduleName).create();
    }
}

