/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.configurations.model;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportArtifact;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportAttribute;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportCapability;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportSecondaryVariant;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public final class ReportConfiguration {
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final Type type;
    private final ImmutableList<ReportAttribute> attributes;
    private final ImmutableList<ReportCapability> capabilities;
    private final ImmutableList<ReportArtifact> artifacts;
    private final ImmutableList<ReportSecondaryVariant> variants;
    private final ImmutableList<ReportConfiguration> extendedConfigurations;

    ReportConfiguration(String name, @Nullable String description, @Nullable Type type, List<ReportAttribute> attributes, List<ReportCapability> capabilities, List<ReportArtifact> artifacts2, List<ReportSecondaryVariant> variants, List<ReportConfiguration> extendedConfigurations) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.attributes = ImmutableList.copyOf(attributes);
        this.capabilities = ImmutableList.copyOf(capabilities);
        this.artifacts = ImmutableList.copyOf(artifacts2);
        this.variants = ImmutableList.copyOf(variants);
        this.extendedConfigurations = ImmutableList.copyOf(extendedConfigurations);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    public List<ReportAttribute> getAttributes() {
        return this.attributes;
    }

    public List<ReportCapability> getCapabilities() {
        return this.capabilities;
    }

    public List<ReportArtifact> getArtifacts() {
        return this.artifacts;
    }

    public List<ReportSecondaryVariant> getSecondaryVariants() {
        return this.variants;
    }

    public List<ReportConfiguration> getExtendedConfigurations() {
        return this.extendedConfigurations;
    }

    public boolean isPurelyConsumable() {
        return Type.CONSUMABLE == this.type;
    }

    public boolean isPurelyResolvable() {
        return Type.RESOLVABLE == this.type;
    }

    public boolean isLegacy() {
        return Type.LEGACY == this.type;
    }

    public boolean hasIncubatingAttributes() {
        return this.attributes.stream().anyMatch(ReportAttribute::isIncubating);
    }

    public boolean hasVariants() {
        return !this.variants.isEmpty();
    }

    public static enum Type {
        CONSUMABLE,
        RESOLVABLE,
        LEGACY;

    }
}

