/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.internal.VersionNumber;

public class PmdPlugin
extends AbstractCodeQualityPlugin<Pmd> {
    public static final String DEFAULT_PMD_VERSION = "6.39.0";
    private static final String PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION = "pmdAux";
    private PmdExtension extension;

    @Inject
    protected JvmPluginServices getJvmPluginServices() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getToolName() {
        return "PMD";
    }

    @Override
    protected Class<Pmd> getTaskType() {
        return Pmd.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("pmd", PmdExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_PMD_VERSION);
        this.extension.setRuleSets(new ArrayList<String>(Collections.singletonList("category/java/errorprone.xml")));
        this.extension.setRuleSetFiles(this.project.getLayout().files(new Object[0]));
        PmdPlugin.conventionMappingOf(this.extension).map("targetJdk", () -> this.getDefaultTargetJdk(this.getJavaPluginExtension().getSourceCompatibility()));
        return this.extension;
    }

    public TargetJdk getDefaultTargetJdk(JavaVersion javaVersion) {
        try {
            return TargetJdk.toVersion(javaVersion.toString());
        }
        catch (IllegalArgumentException ignored) {
            return TargetJdk.VERSION_1_4;
        }
    }

    @Override
    protected void createConfigurations() {
        super.createConfigurations();
        this.project.getConfigurations().create(PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION, additionalAuxDepsConfiguration -> {
            additionalAuxDepsConfiguration.setDescription("The additional libraries that are available for type resolution during analysis");
            additionalAuxDepsConfiguration.setCanBeResolved(false);
            additionalAuxDepsConfiguration.setCanBeConsumed(false);
            additionalAuxDepsConfiguration.setVisible(false);
        });
    }

    @Override
    protected void configureConfiguration(Configuration configuration2) {
        this.configureDefaultDependencies(configuration2);
    }

    @Override
    protected void configureTaskDefaults(Pmd task, String baseName) {
        Configuration configuration2 = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration2, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration2) {
        configuration2.defaultDependencies(dependencies -> {
            VersionNumber version = VersionNumber.parse(this.extension.getToolVersion());
            String dependency = this.calculateDefaultDependencyNotation(version);
            dependencies.add(this.project.getDependencies().create(dependency));
        });
    }

    private void configureTaskConventionMapping(Configuration configuration2, Pmd task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("pmdClasspath", () -> configuration2);
        taskMapping.map("ruleSets", () -> this.extension.getRuleSets());
        taskMapping.map("ruleSetConfig", () -> this.extension.getRuleSetConfig());
        taskMapping.map("ruleSetFiles", () -> this.extension.getRuleSetFiles());
        taskMapping.map("ignoreFailures", () -> this.extension.isIgnoreFailures());
        taskMapping.map("consoleOutput", () -> this.extension.isConsoleOutput());
        taskMapping.map("targetJdk", () -> this.extension.getTargetJdk());
        task.getRulesMinimumPriority().convention(this.extension.getRulesMinimumPriority());
        task.getMaxFailures().convention(this.extension.getMaxFailures());
        task.getIncrementalAnalysis().convention(this.extension.getIncrementalAnalysis());
        task.getThreads().convention(this.extension.getThreads());
    }

    private void configureReportsConventionMapping(Pmd task, String baseName) {
        ProjectLayout layout2 = this.project.getLayout();
        ProviderFactory providers = this.project.getProviders();
        Provider<RegularFile> reportsDir = layout2.file(providers.provider(() -> this.extension.getReportsDir()));
        task.getReports().all(SerializableLambdas.action(report2 -> {
            report2.getRequired().convention(true);
            report2.getOutputLocation().convention(layout2.getProjectDirectory().file(providers.provider(() -> {
                String reportFileName = baseName + "." + report2.getName();
                return new File(((RegularFile)reportsDir.get()).getAsFile(), reportFileName).getAbsolutePath();
            })));
        }));
    }

    private String calculateDefaultDependencyNotation(VersionNumber toolVersion) {
        if (toolVersion.compareTo(VersionNumber.version(5)) < 0) {
            return "pmd:pmd:" + this.extension.getToolVersion();
        }
        if (toolVersion.compareTo(VersionNumber.parse("5.2.0")) < 0) {
            return "net.sourceforge.pmd:pmd:" + this.extension.getToolVersion();
        }
        return "net.sourceforge.pmd:pmd-java:" + this.extension.getToolVersion();
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Pmd task) {
        task.setDescription("Run PMD analysis for " + sourceSet.getName() + " classes");
        task.setSource(sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        ConfigurationContainer configurations = this.project.getConfigurations();
        Configuration compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        Configuration pmdAdditionalAuxDepsConfiguration = configurations.getByName(PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION);
        Configuration pmdAuxClasspath = (Configuration)configurations.create(sourceSet.getName() + "PmdAuxClasspath");
        pmdAuxClasspath.extendsFrom(compileClasspath, pmdAdditionalAuxDepsConfiguration);
        pmdAuxClasspath.setCanBeConsumed(false);
        pmdAuxClasspath.setVisible(false);
        this.getJvmPluginServices().configureAsRuntimeClasspath(pmdAuxClasspath);
        taskMapping.map("classpath", () -> {
            FileCollection nonConfigurationClasspathEntries = sourceSet.getCompileClasspath().minus(compileClasspath);
            return sourceSet.getOutput().plus(nonConfigurationClasspathEntries).plus(pmdAuxClasspath);
        });
    }
}

