/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.catalog.DependencyBundleValueSource;
import org.gradle.api.internal.provider.DefaultValueSourceProviderFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.JvmComponentDependencies;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.internal.Cast;

public class DefaultJvmComponentDependencies
implements JvmComponentDependencies {
    private final Configuration implementation;
    private final Configuration compileOnly;
    private final Configuration runtimeOnly;
    private final Configuration annotationProcessor;

    @Inject
    public DefaultJvmComponentDependencies(Configuration implementation, Configuration compileOnly, Configuration runtimeOnly, Configuration annotationProcessor) {
        this.implementation = implementation;
        this.compileOnly = compileOnly;
        this.runtimeOnly = runtimeOnly;
        this.annotationProcessor = annotationProcessor;
    }

    @Inject
    protected DependencyHandler getDependencyHandler() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void implementation(Object dependency) {
        this.implementation(dependency, null);
    }

    @Override
    public void implementation(Object dependency, @Nullable Action<? super Dependency> configuration2) {
        this.doAdd(this.implementation, dependency, configuration2);
    }

    @Override
    public void runtimeOnly(Object dependency) {
        this.runtimeOnly(dependency, null);
    }

    @Override
    public void runtimeOnly(Object dependency, @Nullable Action<? super Dependency> configuration2) {
        this.doAdd(this.runtimeOnly, dependency, configuration2);
    }

    @Override
    public void compileOnly(Object dependency) {
        this.compileOnly(dependency, null);
    }

    @Override
    public void compileOnly(Object dependency, @Nullable Action<? super Dependency> configuration2) {
        this.doAdd(this.compileOnly, dependency, configuration2);
    }

    @Override
    public void annotationProcessor(Object dependency) {
        this.annotationProcessor(dependency, null);
    }

    @Override
    public void annotationProcessor(Object dependency, @Nullable Action<? super Dependency> configuration2) {
        this.doAdd(this.annotationProcessor, dependency, configuration2);
    }

    private void doAdd(Configuration bucket, Object dependency, @Nullable Action<? super Dependency> configuration2) {
        if (dependency instanceof ProviderConvertible) {
            this.doAddLazy(bucket, ((ProviderConvertible)dependency).asProvider(), configuration2);
        } else if (dependency instanceof Provider) {
            this.doAddLazy(bucket, (Provider)dependency, configuration2);
        } else {
            this.doAddEager(bucket, dependency, configuration2);
        }
    }

    private void doAddEager(Configuration bucket, Object dependency, @Nullable Action<? super Dependency> configuration2) {
        Dependency created = this.create(dependency, configuration2);
        bucket.getDependencies().add(created);
    }

    private void doAddLazy(Configuration bucket, Provider<?> dependencyProvider, @Nullable Action<? super Dependency> configuration2) {
        Class valueSourceType;
        if (dependencyProvider instanceof DefaultValueSourceProviderFactory.ValueSourceProvider && (valueSourceType = ((DefaultValueSourceProviderFactory.ValueSourceProvider)dependencyProvider).getValueSourceType()).isAssignableFrom(DependencyBundleValueSource.class)) {
            this.doAddListProvider(bucket, dependencyProvider, configuration2);
            return;
        }
        Provider<Dependency> lazyDependency = dependencyProvider.map(this.mapDependencyProvider(bucket, configuration2));
        bucket.getDependencies().addLater(lazyDependency);
    }

    private void doAddListProvider(Configuration bucket, Provider<?> dependency, @Nullable Action<? super Dependency> configuration2) {
        ListProperty<Dependency> dependencies = this.getObjectFactory().listProperty(Dependency.class);
        dependencies.set(dependency.map(notation -> {
            List deps = (List)Cast.uncheckedCast(notation);
            return deps.stream().map(d -> this.create(d, configuration2)).collect(Collectors.toList());
        }));
        bucket.getDependencies().addAllLater(dependencies);
    }

    private <T> Transformer<Dependency, T> mapDependencyProvider(Configuration bucket, @Nullable Action<? super Dependency> configuration2) {
        return lazyNotation -> {
            if (lazyNotation instanceof Configuration) {
                throw new InvalidUserDataException("Adding a configuration as a dependency using a provider isn't supported. You should call " + bucket.getName() + ".extendsFrom(" + ((Configuration)lazyNotation).getName() + ") instead");
            }
            return this.create(lazyNotation, configuration2);
        };
    }

    private Dependency create(Object dependency, @Nullable Action<? super Dependency> configuration2) {
        Dependency created = this.getDependencyHandler().create(dependency);
        if (configuration2 != null) {
            configuration2.execute(created);
        }
        return created;
    }
}

