/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import java.io.File;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.antlr.internal.AntlrExecuter;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class AntlrWorkerManager {
    public AntlrResult runWorker(File workingDir, WorkerProcessFactory workerFactory, FileCollection antlrClasspath, AntlrSpec spec) {
        RequestHandler<AntlrSpec, AntlrResult> antlrWorker = this.createWorkerProcess(workingDir, workerFactory, antlrClasspath, spec);
        return antlrWorker.run(spec);
    }

    private RequestHandler<AntlrSpec, AntlrResult> createWorkerProcess(File workingDir, WorkerProcessFactory workerFactory, FileCollection antlrClasspath, AntlrSpec spec) {
        SingleRequestWorkerProcessBuilder builder = workerFactory.singleRequestWorker(AntlrExecuter.class);
        builder.setBaseName("Gradle ANTLR Worker");
        if (antlrClasspath != null) {
            builder.applicationClasspath(antlrClasspath);
        }
        builder.sharedPackages("antlr", "org.antlr");
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(workingDir);
        javaCommand.setMaxHeapSize(spec.getMaxHeapSize());
        javaCommand.systemProperty("ANTLR_DO_NOT_EXIT", "true");
        javaCommand.redirectErrorStream();
        return builder.build();
    }
}

