/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.function.BiFunction;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.api.tasks.javadoc.GroovydocAccess;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class GroovyBasePlugin
implements Plugin<Project> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final ObjectFactory objectFactory;
    private final ModuleRegistry moduleRegistry;
    private final JvmPluginServices jvmPluginServices;
    private Project project;
    private GroovyRuntime groovyRuntime;

    @Inject
    public GroovyBasePlugin(ObjectFactory objectFactory, ModuleRegistry moduleRegistry, JvmEcosystemUtilities jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.moduleRegistry = moduleRegistry;
        this.jvmPluginServices = (JvmPluginServices)jvmPluginServices;
    }

    @Override
    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureGroovyRuntimeExtension();
        this.configureCompileDefaults();
        this.configureSourceSetDefaults();
        this.configureGroovydoc();
    }

    private void configureGroovyRuntimeExtension() {
        this.groovyRuntime = this.project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, this.project);
    }

    private void configureCompileDefaults() {
        this.project.getTasks().withType(GroovyCompile.class).configureEach(compile -> compile.getConventionMapping().map("groovyClasspath", () -> this.groovyRuntime.inferGroovyClasspath(compile.getClasspath())));
    }

    private void configureSourceSetDefaults() {
        this.javaPluginExtension().getSourceSets().all(sourceSet -> {
            DefaultGroovySourceSet groovySourceSet = new DefaultGroovySourceSet("groovy", ((DefaultSourceSet)sourceSet).getDisplayName(), this.objectFactory);
            this.addSourceSetExtension((SourceSet)sourceSet, groovySourceSet);
            GroovySourceDirectorySet groovySource = groovySourceSet.getGroovy();
            groovySource.srcDir("src/" + sourceSet.getName() + "/groovy");
            GroovySourceDirectorySet groovySourceFiles = groovySource;
            sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(element -> groovySourceFiles.contains(element.getFile())));
            sourceSet.getAllJava().source(groovySource);
            sourceSet.getAllSource().source(groovySource);
            NamedDomainObjectProvider compileTask = this.project.getTasks().register(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, compile -> {
                JvmPluginsHelper.configureForSourceSet(sourceSet, groovySource, compile, compile.getOptions(), this.project);
                compile.setDescription("Compiles the " + sourceSet.getName() + " Groovy source.");
                compile.setSource(groovySource);
                compile.getJavaLauncher().convention(this.getToolchainTool(this.project, JavaToolchainService::launcherFor));
                compile.getGroovyOptions().getDisabledGlobalASTTransformations().convention((Iterable)Sets.newHashSet((Object[])new String[]{"groovy.grape.GrabAnnotationTransformation"}));
            });
            String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
            JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, (SourceDirectorySet)groovySource, this.project, (TaskProvider<? extends AbstractCompile>)compileTask, compileTask.map(GroovyCompile::getOptions));
            this.useDefaultTargetPlatformInference((TaskProvider<GroovyCompile>)compileTask, compileClasspathConfigurationName);
            this.useDefaultTargetPlatformInference((TaskProvider<GroovyCompile>)compileTask, sourceSet.getRuntimeClasspathConfigurationName());
            this.project.getTasks().named(sourceSet.getClassesTaskName(), arg_0 -> GroovyBasePlugin.lambda$configureSourceSetDefaults$3((TaskProvider)compileTask, arg_0));
            this.project.getConfigurations().getByName(compileClasspathConfigurationName).attributes(attrs -> attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.project.getObjects().named(LibraryElements.class, "classes+resources")));
        });
    }

    private void addSourceSetExtension(SourceSet sourceSet, DefaultGroovySourceSet groovySourceSet) {
        new DslObject(sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet);
        sourceSet.getExtensions().add(GroovySourceDirectorySet.class, "groovy", groovySourceSet.getGroovy());
    }

    private void useDefaultTargetPlatformInference(TaskProvider<GroovyCompile> compileTask, String configurationName) {
        this.jvmPluginServices.useDefaultTargetPlatformInference(this.project.getConfigurations().getByName(configurationName), compileTask);
    }

    private void configureGroovydoc() {
        this.project.getTasks().withType(Groovydoc.class).configureEach(groovydoc -> {
            groovydoc.getConventionMapping().map("groovyClasspath", () -> {
                FileCollection groovyClasspath = this.groovyRuntime.inferGroovyClasspath(groovydoc.getClasspath());
                ConfigurableFileCollection jansi = this.project.getObjects().fileCollection().from(this.moduleRegistry.getExternalModule("jansi").getImplementationClasspath().getAsFiles());
                return groovyClasspath.plus(jansi);
            });
            groovydoc.getConventionMapping().map("destinationDir", () -> this.javaPluginExtension().getDocsDir().dir("groovydoc").get().getAsFile());
            groovydoc.getConventionMapping().map("docTitle", () -> this.projectExtension(ReportingExtension.class).getApiDocTitle());
            groovydoc.getConventionMapping().map("windowTitle", () -> this.projectExtension(ReportingExtension.class).getApiDocTitle());
            groovydoc.getAccess().convention(GroovydocAccess.PROTECTED);
            groovydoc.getIncludeAuthor().convention(false);
            groovydoc.getProcessScripts().convention(true);
            groovydoc.getIncludeMainForScripts().convention(true);
        });
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper) {
        JavaPluginExtension extension = this.extensionOf(project, JavaPluginExtension.class);
        JavaToolchainService service = this.extensionOf(project, JavaToolchainService.class);
        return toolMapper.apply(service, extension.getToolchain());
    }

    private JavaPluginExtension javaPluginExtension() {
        return this.projectExtension(JavaPluginExtension.class);
    }

    private <T> T projectExtension(Class<T> type) {
        return this.extensionOf(this.project, type);
    }

    private <T> T extensionOf(ExtensionAware extensionAware, Class<T> type) {
        return extensionAware.getExtensions().getByType(type);
    }

    private static /* synthetic */ void lambda$configureSourceSetDefaults$3(TaskProvider compileTask, Task task) {
        task.dependsOn(compileTask);
    }
}

