/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertySpec;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.CompileClasspathNormalizer;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.InputExecutionState;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.AbsolutePathInputNormalizer;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.IgnoredPathInputNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.NameOnlyInputNormalizer;
import org.gradle.internal.fingerprint.RelativePathInputNormalizer;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class SnapshotTaskInputsBuildOperationResult
implements SnapshotTaskInputsBuildOperationType.Result,
CustomOperationTraceSerialization {
    private static final Map<Class<? extends FileNormalizer>, String> FINGERPRINTING_STRATEGIES_BY_NORMALIZER = ImmutableMap.builder().put(ClasspathNormalizer.class, (Object)"CLASSPATH").put(CompileClasspathNormalizer.class, (Object)"COMPILE_CLASSPATH").put(AbsolutePathInputNormalizer.class, (Object)"ABSOLUTE_PATH").put(RelativePathInputNormalizer.class, (Object)"RELATIVE_PATH").put(NameOnlyInputNormalizer.class, (Object)"NAME_ONLY").put(IgnoredPathInputNormalizer.class, (Object)"IGNORED_PATH").build();
    @VisibleForTesting
    final CachingState cachingState;
    private final Map<String, InputFilePropertySpec> propertySpecsByName;

    public SnapshotTaskInputsBuildOperationResult(CachingState cachingState, Set<InputFilePropertySpec> inputFileProperties) {
        this.cachingState = cachingState;
        this.propertySpecsByName = Maps.uniqueIndex(inputFileProperties, PropertySpec::getPropertyName);
    }

    @Override
    public Map<String, byte[]> getInputValueHashesBytes() {
        return this.getBeforeExecutionState().map(InputExecutionState::getInputProperties).filter(inputValueFingerprints -> !inputValueFingerprints.isEmpty()).map(inputValueFingerprints -> inputValueFingerprints.entrySet().stream().collect(SnapshotTaskInputsBuildOperationResult.toLinkedHashMap(valueSnapshot -> {
            Hasher hasher = Hashing.newHasher();
            valueSnapshot.appendToHasher(hasher);
            return hasher.hash().toByteArray();
        }))).orElse(null);
    }

    private InputFilePropertySpec propertySpec(String propertyName) {
        InputFilePropertySpec propertySpec = this.propertySpecsByName.get(propertyName);
        if (propertySpec == null) {
            throw new IllegalStateException("Unknown input property '" + propertyName + "' (known: " + this.propertySpecsByName.keySet() + ")");
        }
        return propertySpec;
    }

    @Override
    public void visitInputFileProperties(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
        this.getBeforeExecutionState().map(BeforeExecutionState::getInputFileProperties).ifPresent(inputFileProperties -> {
            State state2 = new State(visitor);
            for (Map.Entry entry : inputFileProperties.entrySet()) {
                CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)entry.getValue();
                state2.propertyName = (String)entry.getKey();
                state2.propertyHash = fingerprint.getHash();
                state2.fingerprints = fingerprint.getFingerprints();
                visitor.preProperty(state2);
                fingerprint.getSnapshot().accept(state2);
                visitor.postProperty();
            }
        });
    }

    @Override
    @Nullable
    public Set<String> getInputPropertiesLoadedByUnknownClassLoader() {
        return null;
    }

    @Override
    public byte[] getClassLoaderHashBytes() {
        return this.getBeforeExecutionState().map(InputExecutionState::getImplementation).map(ImplementationSnapshot::getClassLoaderHash).map(HashCode::toByteArray).orElse(null);
    }

    @Override
    public List<byte[]> getActionClassLoaderHashesBytes() {
        return this.getBeforeExecutionState().map(InputExecutionState::getAdditionalImplementations).filter(additionalImplementation -> !additionalImplementation.isEmpty()).map(additionalImplementations -> additionalImplementations.stream().map(input -> input.getClassLoaderHash() == null ? null : input.getClassLoaderHash().toByteArray()).collect(Collectors.toList())).orElse(null);
    }

    @Override
    @Nullable
    public List<String> getActionClassNames() {
        return this.getBeforeExecutionState().map(InputExecutionState::getAdditionalImplementations).filter(additionalImplementations -> !additionalImplementations.isEmpty()).map(additionalImplementations -> additionalImplementations.stream().map(ImplementationSnapshot::getTypeName).collect(Collectors.toList())).orElse(null);
    }

    @Override
    @Nullable
    public List<String> getOutputPropertyNames() {
        return this.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).map(ImmutableSortedMap::keySet).filter(outputPropertyNames -> !outputPropertyNames.isEmpty()).map(ImmutableSet::asList).orElse(null);
    }

    @Override
    public byte[] getHashBytes() {
        return this.getKey().map(BuildCacheKey::toByteArray).orElse(null);
    }

    @Override
    public Object getCustomOperationTraceSerializableModel() {
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        List<byte[]> actionClassLoaderHashesBytes = this.getActionClassLoaderHashesBytes();
        if (actionClassLoaderHashesBytes != null) {
            List actionClassloaderHashes = this.getActionClassLoaderHashesBytes().stream().map(hash -> hash == null ? null : HashCode.fromBytes(hash).toString()).collect(Collectors.toList());
            model.put("actionClassLoaderHashes", actionClassloaderHashes);
        } else {
            model.put("actionClassLoaderHashes", null);
        }
        model.put("actionClassNames", this.getActionClassNames());
        byte[] hashBytes = this.getHashBytes();
        if (hashBytes != null) {
            model.put("hash", HashCode.fromBytes(hashBytes).toString());
        } else {
            model.put("hash", null);
        }
        byte[] classLoaderHashBytes = this.getClassLoaderHashBytes();
        if (classLoaderHashBytes != null) {
            model.put("classLoaderHash", HashCode.fromBytes(classLoaderHashBytes).toString());
        } else {
            model.put("classLoaderHash", null);
        }
        model.put("inputFileProperties", this.fileProperties());
        Map<String, byte[]> inputValueHashesBytes = this.getInputValueHashesBytes();
        if (inputValueHashesBytes != null) {
            Map inputValueHashes = inputValueHashesBytes.entrySet().stream().collect(SnapshotTaskInputsBuildOperationResult.toLinkedHashMap(value -> value == null ? null : HashCode.fromBytes(value).toString()));
            model.put("inputValueHashes", inputValueHashes);
        } else {
            model.put("inputValueHashes", null);
        }
        model.put("outputPropertyNames", this.getOutputPropertyNames());
        return model;
    }

    private static <K, V, U> Collector<Map.Entry<K, V>, ?, LinkedHashMap<K, U>> toLinkedHashMap(Function<? super V, ? extends U> valueMapper) {
        return Collectors.toMap(Map.Entry::getKey, entry -> valueMapper.apply((Object)entry.getValue()), (a, b) -> b, LinkedHashMap::new);
    }

    protected Map<String, Object> fileProperties() {
        final TreeMap<String, Object> fileProperties = new TreeMap<String, Object>();
        this.visitInputFileProperties(new SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor(){
            Property property;
            final Deque<DirEntry> dirStack = new ArrayDeque<DirEntry>();

            @Override
            public void preProperty(SnapshotTaskInputsBuildOperationType.Result.VisitState state2) {
                this.property = new Property(HashCode.fromBytes(state2.getPropertyHashBytes()).toString(), state2.getPropertyNormalizationStrategyName(), state2.getPropertyAttributes());
                fileProperties.put(state2.getPropertyName(), this.property);
            }

            @Override
            public void preRoot(SnapshotTaskInputsBuildOperationType.Result.VisitState state2) {
            }

            @Override
            public void preDirectory(SnapshotTaskInputsBuildOperationType.Result.VisitState state2) {
                boolean isRoot = this.dirStack.isEmpty();
                DirEntry dir = new DirEntry(isRoot ? state2.getPath() : state2.getName());
                if (isRoot) {
                    this.property.roots.add(dir);
                } else {
                    this.dirStack.peek().children.add(dir);
                }
                this.dirStack.push(dir);
            }

            @Override
            public void file(SnapshotTaskInputsBuildOperationType.Result.VisitState state2) {
                boolean isRoot = this.dirStack.isEmpty();
                FileEntry file = new FileEntry(isRoot ? state2.getPath() : state2.getName(), HashCode.fromBytes(state2.getHashBytes()).toString());
                if (isRoot) {
                    this.property.roots.add(file);
                } else {
                    this.dirStack.peek().children.add(file);
                }
            }

            @Override
            public void postDirectory() {
                this.dirStack.pop();
            }

            @Override
            public void postRoot() {
            }

            @Override
            public void postProperty() {
            }

            class DirEntry
            extends Entry {
                private final List<Entry> children;

                DirEntry(String path) {
                    super(path);
                    this.children = new ArrayList<Entry>();
                }

                public Collection<Entry> getChildren() {
                    return this.children;
                }
            }

            class FileEntry
            extends Entry {
                private final String hash;

                FileEntry(String path, String hash) {
                    super(path);
                    this.hash = hash;
                }

                public String getHash() {
                    return this.hash;
                }
            }

            abstract class Entry {
                private final String path;

                public Entry(String path) {
                    this.path = path;
                }

                public String getPath() {
                    return this.path;
                }
            }

            class Property {
                private final String hash;
                private final String normalization;
                private final Set<String> attributes;
                private final List<Entry> roots = new ArrayList<Entry>();

                public Property(String hash, String normalization, Set<String> attributes) {
                    this.hash = hash;
                    this.normalization = normalization;
                    this.attributes = attributes;
                }

                public String getHash() {
                    return this.hash;
                }

                public String getNormalization() {
                    return this.normalization;
                }

                public Set<String> getAttributes() {
                    return this.attributes;
                }

                public Collection<Entry> getRoots() {
                    return this.roots;
                }
            }
        });
        return fileProperties;
    }

    private Optional<BeforeExecutionState> getBeforeExecutionState() {
        return this.cachingState.fold(enabled -> Optional.of(enabled.getBeforeExecutionState()), CachingState.Disabled::getBeforeExecutionState);
    }

    private Optional<BuildCacheKey> getKey() {
        return this.cachingState.fold(enabled -> Optional.of(enabled.getKey()), CachingState.Disabled::getKey);
    }

    static enum FilePropertyAttribute {
        FINGERPRINTING_STRATEGY_ABSOLUTE_PATH,
        FINGERPRINTING_STRATEGY_NAME_ONLY,
        FINGERPRINTING_STRATEGY_RELATIVE_PATH,
        FINGERPRINTING_STRATEGY_IGNORED_PATH,
        FINGERPRINTING_STRATEGY_CLASSPATH,
        FINGERPRINTING_STRATEGY_COMPILE_CLASSPATH,
        DIRECTORY_SENSITIVITY_DEFAULT,
        DIRECTORY_SENSITIVITY_IGNORE_DIRECTORIES,
        LINE_ENDING_SENSITIVITY_DEFAULT,
        LINE_ENDING_SENSITIVITY_NORMALIZE_LINE_ENDINGS;

        private static final Map<Class<? extends FileNormalizer>, FilePropertyAttribute> BY_NORMALIZER_CLASS;
        private static final Map<DirectorySensitivity, FilePropertyAttribute> BY_DIRECTORY_SENSITIVITY;
        private static final Map<LineEndingSensitivity, FilePropertyAttribute> BY_LINE_ENDING_SENSITIVITY;

        private static <T> FilePropertyAttribute findFor(T value, Map<T, FilePropertyAttribute> mapping) {
            FilePropertyAttribute attribute = mapping.get(value);
            if (attribute == null) {
                throw new IllegalStateException("Did not find property attribute mapping for '" + value + "' (from: " + mapping.keySet() + ")");
            }
            return attribute;
        }

        static FilePropertyAttribute fromNormalizerClass(Class<? extends FileNormalizer> normalizerClass) {
            return FilePropertyAttribute.findFor(normalizerClass, BY_NORMALIZER_CLASS);
        }

        static FilePropertyAttribute from(DirectorySensitivity directorySensitivity) {
            return FilePropertyAttribute.findFor(directorySensitivity, BY_DIRECTORY_SENSITIVITY);
        }

        static FilePropertyAttribute from(LineEndingSensitivity lineEndingSensitivity) {
            return FilePropertyAttribute.findFor(lineEndingSensitivity, BY_LINE_ENDING_SENSITIVITY);
        }

        static {
            BY_NORMALIZER_CLASS = ImmutableMap.builder().put(ClasspathNormalizer.class, (Object)FINGERPRINTING_STRATEGY_CLASSPATH).put(CompileClasspathNormalizer.class, (Object)FINGERPRINTING_STRATEGY_COMPILE_CLASSPATH).put(AbsolutePathInputNormalizer.class, (Object)FINGERPRINTING_STRATEGY_ABSOLUTE_PATH).put(RelativePathInputNormalizer.class, (Object)FINGERPRINTING_STRATEGY_RELATIVE_PATH).put(NameOnlyInputNormalizer.class, (Object)FINGERPRINTING_STRATEGY_NAME_ONLY).put(IgnoredPathInputNormalizer.class, (Object)FINGERPRINTING_STRATEGY_IGNORED_PATH).build();
            BY_DIRECTORY_SENSITIVITY = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)DirectorySensitivity.DEFAULT, (Object)DIRECTORY_SENSITIVITY_DEFAULT).put((Object)DirectorySensitivity.UNSPECIFIED, (Object)DIRECTORY_SENSITIVITY_DEFAULT).put((Object)DirectorySensitivity.IGNORE_DIRECTORIES, (Object)DIRECTORY_SENSITIVITY_IGNORE_DIRECTORIES).build());
            BY_LINE_ENDING_SENSITIVITY = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)LineEndingSensitivity.DEFAULT, (Object)LINE_ENDING_SENSITIVITY_DEFAULT).put((Object)LineEndingSensitivity.NORMALIZE_LINE_ENDINGS, (Object)LINE_ENDING_SENSITIVITY_NORMALIZE_LINE_ENDINGS).build());
        }
    }

    private static class DirectoryVisitState
    implements SnapshotTaskInputsBuildOperationType.Result.VisitState {
        private final SnapshotTaskInputsBuildOperationType.Result.VisitState delegate;
        private final DirectorySnapshot directorySnapshot;

        public DirectoryVisitState(DirectorySnapshot unvisited, SnapshotTaskInputsBuildOperationType.Result.VisitState delegate) {
            this.directorySnapshot = unvisited;
            this.delegate = delegate;
        }

        @Override
        public String getPath() {
            return this.directorySnapshot.getAbsolutePath();
        }

        @Override
        public String getName() {
            return this.directorySnapshot.getName();
        }

        @Override
        public byte[] getHashBytes() {
            throw new UnsupportedOperationException("Cannot query hash for directories");
        }

        @Override
        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        @Override
        public byte[] getPropertyHashBytes() {
            return this.delegate.getPropertyHashBytes();
        }

        @Override
        public String getPropertyNormalizationStrategyName() {
            return this.delegate.getPropertyNormalizationStrategyName();
        }

        @Override
        public Set<String> getPropertyAttributes() {
            return this.delegate.getPropertyAttributes();
        }
    }

    @NonNullApi
    private final class State
    implements SnapshotTaskInputsBuildOperationType.Result.VisitState,
    FileSystemSnapshotHierarchyVisitor {
        final SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor;
        final Deque<DirectorySnapshot> unvisitedDirectories = new ArrayDeque<DirectorySnapshot>();
        Map<String, FileSystemLocationFingerprint> fingerprints;
        String propertyName;
        HashCode propertyHash;
        String name;
        String path;
        HashCode hash;
        int depth;

        public State(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public byte[] getPropertyHashBytes() {
            return this.propertyHash.toByteArray();
        }

        @Override
        public Set<String> getPropertyAttributes() {
            InputFilePropertySpec propertySpec = SnapshotTaskInputsBuildOperationResult.this.propertySpec(this.propertyName);
            return ImmutableSortedSet.of((Comparable)((Object)FilePropertyAttribute.fromNormalizerClass(propertySpec.getNormalizer()).name()), (Comparable)((Object)FilePropertyAttribute.from(propertySpec.getDirectorySensitivity()).name()), (Comparable)((Object)FilePropertyAttribute.from(propertySpec.getLineEndingNormalization()).name()));
        }

        @Override
        @Deprecated
        public String getPropertyNormalizationStrategyName() {
            InputFilePropertySpec propertySpec = SnapshotTaskInputsBuildOperationResult.this.propertySpec(this.propertyName);
            Class<? extends FileNormalizer> normalizer = propertySpec.getNormalizer();
            String normalizationStrategy = (String)FINGERPRINTING_STRATEGIES_BY_NORMALIZER.get(normalizer);
            if (normalizationStrategy == null) {
                throw new IllegalStateException("No strategy name for " + normalizer);
            }
            return normalizationStrategy;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public byte[] getHashBytes() {
            return this.hash.toByteArray();
        }

        @Override
        public void enterDirectory(DirectorySnapshot physicalSnapshot) {
            FileSystemLocationFingerprint fingerprint;
            this.path = physicalSnapshot.getAbsolutePath();
            this.name = physicalSnapshot.getName();
            this.hash = null;
            if (this.depth++ == 0) {
                this.visitor.preRoot(this);
            }
            if ((fingerprint = this.fingerprints.get(this.path)) == null) {
                this.unvisitedDirectories.add(physicalSnapshot);
            } else {
                this.visitUnvisitedDirectories();
                this.visitor.preDirectory(this);
            }
        }

        @Override
        public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
            boolean isRoot;
            if (snapshot.getType() == FileType.Directory) {
                return SnapshotVisitResult.CONTINUE;
            }
            FileSystemLocationFingerprint fingerprint = this.fingerprints.get(snapshot.getAbsolutePath());
            if (fingerprint == null) {
                return SnapshotVisitResult.CONTINUE;
            }
            this.visitUnvisitedDirectories();
            this.path = snapshot.getAbsolutePath();
            this.name = snapshot.getName();
            this.hash = fingerprint.getNormalizedContentHash();
            boolean bl = isRoot = this.depth == 0;
            if (isRoot) {
                this.visitor.preRoot(this);
            }
            this.visitor.file(this);
            if (isRoot) {
                this.visitor.postRoot();
            }
            return SnapshotVisitResult.CONTINUE;
        }

        @Override
        public void leaveDirectory(DirectorySnapshot directorySnapshot) {
            DirectorySnapshot lastUnvisitedDirectory = this.unvisitedDirectories.pollLast();
            if (lastUnvisitedDirectory == null) {
                this.visitor.postDirectory();
            }
            if (--this.depth == 0) {
                this.visitor.postRoot();
            }
        }

        private void visitUnvisitedDirectories() {
            DirectorySnapshot unvisited;
            while ((unvisited = this.unvisitedDirectories.poll()) != null) {
                this.visitor.preDirectory(new DirectoryVisitState(unvisited, this));
            }
        }
    }
}

