/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependencyCapabilitiesHandler;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.DefaultProjectDependencyFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyVariant;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.notations.DependencyConstraintProjectNotationConverter;
import org.gradle.api.internal.notations.DependencyMapNotationConverter;
import org.gradle.api.internal.notations.DependencyStringNotationConverter;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class DependencyConstraintNotationParser {
    public static NotationParser<Object, DependencyConstraint> parser(Instantiator instantiator, DefaultProjectDependencyFactory dependencyFactory, Interner<String> stringInterner, ImmutableAttributesFactory attributesFactory) {
        return NotationParserBuilder.toType(DependencyConstraint.class).fromType(MinimalExternalModuleDependency.class, new MinimalExternalDependencyNotationConverter(instantiator, attributesFactory)).fromCharSequence(new DependencyStringNotationConverter<DefaultDependencyConstraint>(instantiator, DefaultDependencyConstraint.class, stringInterner)).converter(new DependencyMapNotationConverter<DefaultDependencyConstraint>(instantiator, DefaultDependencyConstraint.class)).fromType(Project.class, new DependencyConstraintProjectNotationConverter(dependencyFactory)).converter(new ProjectDependencyNotationConverter()).invalidNotationMessage("Comprehensive documentation on dependency notations is available in DSL reference for DependencyHandler type.").toComposite();
    }

    private static final class UnsupportedCapabilitiesHandler
    implements ModuleDependencyCapabilitiesHandler {
        private static final UnsupportedCapabilitiesHandler INSTANCE = new UnsupportedCapabilitiesHandler();

        private UnsupportedCapabilitiesHandler() {
        }

        @Override
        public void requireCapability(Object capabilityNotation) {
            throw new InvalidUserDataException("Capabilities are not supported by dependency constraints");
        }

        @Override
        public void requireCapabilities(Object ... capabilityNotations) {
            throw new InvalidUserDataException("Capabilities are not supported by dependency constraints");
        }
    }

    private static class MinimalExternalDependencyNotationConverter
    implements NotationConverter<MinimalExternalModuleDependency, DefaultDependencyConstraint> {
        private final Instantiator instantiator;
        private final ImmutableAttributesFactory attributesFactory;

        public MinimalExternalDependencyNotationConverter(Instantiator instantiator, ImmutableAttributesFactory attributesFactory) {
            this.instantiator = instantiator;
            this.attributesFactory = attributesFactory;
        }

        @Override
        public void convert(MinimalExternalModuleDependency notation, NotationConvertResult<? super DefaultDependencyConstraint> result2) throws TypeConversionException {
            DefaultDependencyConstraint dependencyConstraint = this.instantiator.newInstance(DefaultDependencyConstraint.class, notation.getModule(), notation.getVersionConstraint());
            if (notation instanceof DependencyVariant) {
                dependencyConstraint.setAttributesFactory(this.attributesFactory);
                DependencyVariant dependencyVariant = (DependencyVariant)((Object)notation);
                dependencyConstraint.attributes(dependencyVariant::mutateAttributes);
                dependencyVariant.mutateCapabilities(UnsupportedCapabilitiesHandler.INSTANCE);
                String classifier = dependencyVariant.getClassifier();
                String artifactType = dependencyVariant.getArtifactType();
                if (classifier != null || artifactType != null) {
                    throw new InvalidUserDataException("Classifier and artifact types aren't supported by dependency constraints");
                }
            }
            result2.converted(dependencyConstraint);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
        }
    }

    private static class ProjectDependencyNotationConverter
    extends TypedNotationConverter<ProjectDependency, DependencyConstraint> {
        public ProjectDependencyNotationConverter() {
            super(ProjectDependency.class);
        }

        @Override
        protected DependencyConstraint parseType(ProjectDependency notation) {
            return new DefaultProjectDependencyConstraint(notation);
        }
    }
}

