/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.impldep.org.apache.commons.io.input.CloseShieldInputStream;

public class LineEndingNormalizingInputStreamHasher {
    private static final HashCode SIGNATURE = Hashing.signature(LineEndingNormalizingInputStreamHasher.class);
    private static final int BUFFER_SIZE = 8192;

    public Optional<HashCode> hashContent(InputStream inputStream) throws IOException {
        return this.hash(inputStream);
    }

    public Optional<HashCode> hashContent(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Optional<HashCode> optional = this.hashContent(inputStream);
            return optional;
        }
    }

    private Optional<HashCode> hash(InputStream inputStream) throws IOException {
        PrimitiveHasher hasher = Hashing.newPrimitiveHasher();
        hasher.putHash(SIGNATURE);
        try (BufferedInputStream input = new BufferedInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)inputStream), 8192);){
            int peekAhead = -1;
            while (true) {
                int next;
                if ((next = peekAhead) != -1) {
                    peekAhead = -1;
                } else {
                    next = input.read();
                }
                if (next == -1) {
                    break;
                }
                if (LineEndingNormalizingInputStreamHasher.isControlCharacter(next)) {
                    Optional<HashCode> optional = Optional.empty();
                    return optional;
                }
                if (next == 13) {
                    peekAhead = input.read();
                    if (peekAhead == 10) {
                        peekAhead = -1;
                    }
                    next = 10;
                }
                hasher.putByte((byte)next);
            }
        }
        return Optional.of(hasher.hash());
    }

    private static boolean isControlCharacter(int c) {
        return LineEndingNormalizingInputStreamHasher.isInControlRange(c) && LineEndingNormalizingInputStreamHasher.isNotCommonTextChar(c);
    }

    private static boolean isInControlRange(int c) {
        return c >= 0 && c < 32;
    }

    private static boolean isNotCommonTextChar(int c) {
        return !Character.isWhitespace(c);
    }
}

