/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.internal.catalog.AliasNormalizer;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.PluginModel;
import org.gradle.api.internal.catalog.VersionModel;

public class DefaultVersionCatalog
implements Serializable {
    private final String name;
    private final String description;
    private final Map<String, DependencyModel> libraries;
    private final Map<String, BundleModel> bundles;
    private final Map<String, VersionModel> versions;
    private final Map<String, PluginModel> plugins;
    private final int hashCode;

    public DefaultVersionCatalog(String name, String description, Map<String, DependencyModel> libraries, Map<String, BundleModel> bundles, Map<String, VersionModel> versions, Map<String, PluginModel> plugins) {
        this.name = name;
        this.description = description;
        this.libraries = libraries;
        this.bundles = bundles;
        this.versions = versions;
        this.plugins = plugins;
        this.hashCode = this.doComputeHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getLibraryAliases() {
        return this.libraries.keySet().stream().sorted().collect(Collectors.toList());
    }

    public List<String> getBundleAliases() {
        return this.bundles.keySet().stream().sorted().collect(Collectors.toList());
    }

    public DependencyModel getDependencyData(String alias) {
        return this.libraries.get(AliasNormalizer.normalize(alias));
    }

    public List<String> getVersionAliases() {
        return this.versions.keySet().stream().sorted().collect(Collectors.toList());
    }

    public List<String> getPluginAliases() {
        return this.plugins.keySet().stream().sorted().collect(Collectors.toList());
    }

    public BundleModel getBundle(String name) {
        return this.bundles.get(AliasNormalizer.normalize(name));
    }

    public VersionModel getVersion(String name) {
        return this.versions.get(AliasNormalizer.normalize(name));
    }

    public PluginModel getPlugin(String name) {
        return this.plugins.get(AliasNormalizer.normalize(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultVersionCatalog that = (DefaultVersionCatalog)o;
        if (!this.libraries.equals(that.libraries)) {
            return false;
        }
        if (!this.bundles.equals(that.bundles)) {
            return false;
        }
        if (!this.versions.equals(that.versions)) {
            return false;
        }
        return this.plugins.equals(that.plugins);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int doComputeHashCode() {
        int result2 = this.libraries.hashCode();
        result2 = 31 * result2 + this.bundles.hashCode();
        result2 = 31 * result2 + this.versions.hashCode();
        result2 = 31 * result2 + this.plugins.hashCode();
        return result2;
    }

    public boolean isNotEmpty() {
        return !this.libraries.isEmpty() || !this.bundles.isEmpty() || !this.versions.isEmpty() || !this.plugins.isEmpty();
    }
}

