/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.AttributeSelectionUtils;
import org.gradle.internal.component.model.ComponentAttributeMatcher;
import org.gradle.internal.component.model.DefaultCompatibilityCheckResult;
import org.gradle.internal.component.model.DefaultMultipleCandidateResult;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;

public class DefaultAttributesSchema
implements AttributesSchemaInternal,
AttributesSchema {
    private final ComponentAttributeMatcher componentAttributeMatcher;
    private final InstantiatorFactory instantiatorFactory;
    private final Map<Attribute<?>, AttributeMatchingStrategy<?>> strategies = new HashMap();
    private final Map<String, Attribute<?>> attributesByName = new HashMap();
    private final DefaultAttributeMatcher matcher;
    private final IsolatableFactory isolatableFactory;
    private final Map<ExtraAttributesEntry, Attribute<?>[]> extraAttributesCache = new HashMap<ExtraAttributesEntry, Attribute<?>[]>();
    private final List<AttributeDescriber> consumerAttributeDescribers = new ArrayList<AttributeDescriber>();
    private final Set<Attribute<?>> precedence = new LinkedHashSet();

    public DefaultAttributesSchema(ComponentAttributeMatcher componentAttributeMatcher, InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory) {
        this.componentAttributeMatcher = componentAttributeMatcher;
        this.instantiatorFactory = instantiatorFactory;
        this.matcher = new DefaultAttributeMatcher(componentAttributeMatcher, this.mergeWith(EmptySchema.INSTANCE));
        this.isolatableFactory = isolatableFactory;
    }

    @Override
    public <T> AttributeMatchingStrategy<T> getMatchingStrategy(Attribute<T> attribute) {
        AttributeMatchingStrategy<?> strategy = this.strategies.get(attribute);
        if (strategy == null) {
            throw new IllegalArgumentException("Unable to find matching strategy for " + attribute);
        }
        return (AttributeMatchingStrategy)Cast.uncheckedCast(strategy);
    }

    @Override
    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute) {
        return this.attribute(attribute, null);
    }

    @Override
    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute, Action<? super AttributeMatchingStrategy<T>> configureAction) {
        AttributeMatchingStrategy strategy = (AttributeMatchingStrategy)Cast.uncheckedCast(this.strategies.get(attribute));
        if (strategy == null) {
            strategy = (AttributeMatchingStrategy)Cast.uncheckedCast(this.instantiatorFactory.decorateLenient().newInstance(DefaultAttributeMatchingStrategy.class, this.instantiatorFactory, this.isolatableFactory));
            this.strategies.put(attribute, strategy);
            this.attributesByName.put(attribute.getName(), attribute);
        }
        if (configureAction != null) {
            configureAction.execute(strategy);
        }
        return strategy;
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    @Override
    public boolean hasAttribute(Attribute<?> key) {
        return this.strategies.containsKey(key);
    }

    AttributeSelectionSchema mergeWith(AttributesSchemaInternal producerSchema) {
        return new MergedSchema(producerSchema);
    }

    @Override
    public AttributeMatcher withProducer(AttributesSchemaInternal producerSchema) {
        return new DefaultAttributeMatcher(this.componentAttributeMatcher, this.mergeWith(producerSchema));
    }

    @Override
    public AttributeMatcher matcher() {
        return this.matcher;
    }

    @Override
    public CompatibilityRule<Object> compatibilityRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (CompatibilityRule)Cast.uncheckedCast(matchingStrategy.getCompatibilityRules());
        }
        return EmptySchema.INSTANCE.compatibilityRules(attribute);
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (DisambiguationRule)Cast.uncheckedCast(matchingStrategy.getDisambiguationRules());
        }
        return EmptySchema.INSTANCE.disambiguationRules(attribute);
    }

    @Override
    public List<AttributeDescriber> getConsumerDescribers() {
        return this.consumerAttributeDescribers;
    }

    @Override
    public void addConsumerDescriber(AttributeDescriber describer) {
        this.consumerAttributeDescribers.add(describer);
    }

    @Override
    public void attributeDisambiguationPrecedence(Attribute<?> ... attributes) {
        for (Attribute<?> attribute : attributes) {
            if (this.precedence.add(attribute)) continue;
            throw new IllegalArgumentException(String.format("Attribute '%s' precedence has already been set.", attribute.getName()));
        }
    }

    @Override
    public void setAttributeDisambiguationPrecedence(Collection<Attribute<?>> attributes) {
        this.precedence.clear();
        this.attributeDisambiguationPrecedence(attributes.toArray(new Attribute[0]));
    }

    @Override
    public Collection<Attribute<?>> getAttributeDisambiguationPrecedence() {
        return Collections.unmodifiableCollection(this.precedence);
    }

    private static class ExtraAttributesEntry {
        private final ImmutableAttributes[] candidateAttributeSets;
        private final ImmutableAttributes requestedAttributes;
        private final int hashCode;

        private ExtraAttributesEntry(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requestedAttributes) {
            this.candidateAttributeSets = candidateAttributeSets;
            this.requestedAttributes = requestedAttributes;
            int hash = Arrays.hashCode(candidateAttributeSets);
            this.hashCode = hash = 31 * hash + requestedAttributes.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraAttributesEntry that = (ExtraAttributesEntry)o;
            if (this.requestedAttributes != that.requestedAttributes) {
                return false;
            }
            if (this.candidateAttributeSets.length != that.candidateAttributeSets.length) {
                return false;
            }
            for (int i = 0; i < this.candidateAttributeSets.length; ++i) {
                if (this.candidateAttributeSets[i] == that.candidateAttributeSets[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class MergedSchema
    implements AttributeSelectionSchema {
        private final AttributesSchemaInternal producerSchema;

        MergedSchema(AttributesSchemaInternal producerSchema) {
            this.producerSchema = producerSchema;
        }

        @Override
        public boolean hasAttribute(Attribute<?> attribute) {
            return DefaultAttributesSchema.this.getAttributes().contains(attribute) || this.producerSchema.getAttributes().contains(attribute);
        }

        @Override
        public Set<Object> disambiguate(Attribute<?> attribute, @Nullable Object requested, Set<Object> candidates) {
            DefaultMultipleCandidateResult<Object> result2 = null;
            DisambiguationRule<Object> rules = DefaultAttributesSchema.this.disambiguationRules(attribute);
            if (rules.doesSomething()) {
                result2 = new DefaultMultipleCandidateResult<Object>(requested, candidates);
                rules.execute(result2);
                if (result2.hasResult()) {
                    return result2.getMatches();
                }
            }
            if ((rules = this.producerSchema.disambiguationRules(attribute)).doesSomething()) {
                if (result2 == null) {
                    result2 = new DefaultMultipleCandidateResult<Object>(requested, candidates);
                }
                rules.execute(result2);
                if (result2.hasResult()) {
                    return result2.getMatches();
                }
            }
            if (requested != null && candidates.contains(requested)) {
                return Collections.singleton(requested);
            }
            return candidates;
        }

        @Override
        public boolean matchValue(Attribute<?> attribute, Object requested, Object candidate) {
            if (requested.equals(candidate)) {
                return true;
            }
            DefaultCompatibilityCheckResult<Object> result2 = null;
            CompatibilityRule<Object> rules = DefaultAttributesSchema.this.compatibilityRules(attribute);
            if (rules.doesSomething()) {
                result2 = new DefaultCompatibilityCheckResult<Object>(requested, candidate);
                rules.execute(result2);
                if (result2.hasResult()) {
                    return result2.isCompatible();
                }
            }
            if ((rules = this.producerSchema.compatibilityRules(attribute)).doesSomething()) {
                if (result2 == null) {
                    result2 = new DefaultCompatibilityCheckResult<Object>(requested, candidate);
                }
                rules.execute(result2);
                if (result2.hasResult()) {
                    return result2.isCompatible();
                }
            }
            return false;
        }

        @Override
        public Attribute<?> getAttribute(String name) {
            Attribute attribute = (Attribute)DefaultAttributesSchema.this.attributesByName.get(name);
            if (attribute != null) {
                return attribute;
            }
            if (this.producerSchema instanceof DefaultAttributesSchema) {
                return (Attribute)((DefaultAttributesSchema)this.producerSchema).attributesByName.get(name);
            }
            for (Attribute<?> producerAttribute : this.producerSchema.getAttributes()) {
                if (!producerAttribute.getName().equals(name)) continue;
                return producerAttribute;
            }
            return null;
        }

        @Override
        public Attribute<?>[] collectExtraAttributes(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requested) {
            ExtraAttributesEntry entry = new ExtraAttributesEntry(candidateAttributeSets, requested);
            Attribute[] attributes = (Attribute[])DefaultAttributesSchema.this.extraAttributesCache.get(entry);
            if (attributes == null) {
                attributes = AttributeSelectionUtils.collectExtraAttributes(this, candidateAttributeSets, requested);
                DefaultAttributesSchema.this.extraAttributesCache.put(entry, attributes);
            }
            return attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergedSchema that = (MergedSchema)o;
            return this.producerSchema.equals(that.producerSchema);
        }

        @Override
        public AttributeSelectionSchema.PrecedenceResult orderByPrecedence(ImmutableAttributes requested) {
            if (DefaultAttributesSchema.this.precedence.isEmpty() && this.producerSchema.getAttributeDisambiguationPrecedence().isEmpty()) {
                return new AttributeSelectionSchema.PrecedenceResult(IntStream.range(0, requested.keySet().size()).boxed().collect(Collectors.toList()));
            }
            LinkedHashMap<String, Integer> remaining = new LinkedHashMap<String, Integer>();
            int position = 0;
            for (Attribute requestedAttribute : requested.keySet()) {
                remaining.put(requestedAttribute.getName(), position++);
            }
            ArrayList<Integer> sorted = new ArrayList<Integer>(remaining.size());
            for (Attribute preferredAttribute : DefaultAttributesSchema.this.precedence) {
                if (!requested.contains(preferredAttribute)) continue;
                sorted.add((Integer)remaining.remove(preferredAttribute.getName()));
            }
            for (Attribute preferredAttribute : this.producerSchema.getAttributeDisambiguationPrecedence()) {
                if (!remaining.containsKey(preferredAttribute.getName()) || !requested.contains(preferredAttribute)) continue;
                sorted.add((Integer)remaining.remove(preferredAttribute.getName()));
            }
            if (sorted.isEmpty()) {
                return new AttributeSelectionSchema.PrecedenceResult(remaining.values());
            }
            return new AttributeSelectionSchema.PrecedenceResult(sorted, remaining.values());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.producerSchema});
        }
    }

    private static class DefaultAttributeMatcher
    implements AttributeMatcher {
        private final ComponentAttributeMatcher componentAttributeMatcher;
        private final AttributeSelectionSchema effectiveSchema;

        DefaultAttributeMatcher(ComponentAttributeMatcher componentAttributeMatcher, AttributeSelectionSchema effectiveSchema) {
            this.componentAttributeMatcher = componentAttributeMatcher;
            this.effectiveSchema = effectiveSchema;
        }

        @Override
        public boolean isMatching(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
            return this.componentAttributeMatcher.isMatching(this.effectiveSchema, candidate, requested);
        }

        @Override
        public <T> boolean isMatching(Attribute<T> attribute, T candidate, T requested) {
            return this.effectiveSchema.matchValue(attribute, requested, candidate);
        }

        @Override
        public <T extends HasAttributes> List<T> matches(Collection<? extends T> candidates, AttributeContainerInternal requested, AttributeMatchingExplanationBuilder explanationBuilder) {
            return this.matches(candidates, requested, null, explanationBuilder);
        }

        @Override
        public <T extends HasAttributes> List<T> matches(Collection<? extends T> candidates, AttributeContainerInternal requested, @Nullable T fallback, AttributeMatchingExplanationBuilder explanationBuilder) {
            return this.componentAttributeMatcher.match(this.effectiveSchema, candidates, requested, fallback, explanationBuilder);
        }

        @Override
        public List<AttributeMatcher.MatchingDescription<?>> describeMatching(AttributeContainerInternal candidate, AttributeContainerInternal requested) {
            return this.componentAttributeMatcher.describeMatching(this.effectiveSchema, candidate, requested);
        }
    }
}

