/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.util.List;
import java.util.Map;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class DefaultMavenImmutableAttributesFactory
implements MavenImmutableAttributesFactory {
    private final ImmutableAttributesFactory delegate;
    private final NamedObjectInstantiator objectInstantiator;
    private final Map<List<Object>, ImmutableAttributes> concatCache = Maps.newConcurrentMap();

    public DefaultMavenImmutableAttributesFactory(ImmutableAttributesFactory delegate, NamedObjectInstantiator objectInstantiator) {
        this.delegate = delegate;
        this.objectInstantiator = objectInstantiator;
    }

    @Override
    public AttributeContainerInternal mutable() {
        return this.delegate.mutable();
    }

    @Override
    public AttributeContainerInternal mutable(AttributeContainerInternal parent) {
        return this.delegate.mutable(parent);
    }

    @Override
    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.delegate.of(key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, T value) {
        return this.delegate.concat(node, key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        return this.delegate.concat(node, key, value);
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) {
        return this.delegate.concat(attributes1, attributes2);
    }

    @Override
    public ImmutableAttributes safeConcat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) throws AttributeMergingException {
        return this.delegate.safeConcat(attributes1, attributes2);
    }

    @Override
    public ImmutableAttributes libraryWithUsage(ImmutableAttributes original, String usage) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"library", (Object)usage);
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result2 = original;
            result2 = this.concat(result2, (Attribute<T>)USAGE_ATTRIBUTE, new CoercingStringValueSnapshot(usage, this.objectInstantiator));
            result2 = this.concat(result2, (Attribute<T>)FORMAT_ATTRIBUTE, new CoercingStringValueSnapshot("jar", this.objectInstantiator));
            result2 = this.concat(result2, (Attribute<T>)CATEGORY_ATTRIBUTE, new CoercingStringValueSnapshot("library", this.objectInstantiator));
            return result2;
        });
    }

    @Override
    public ImmutableAttributes platformWithUsage(ImmutableAttributes original, String usage, boolean enforced) {
        String componentType = enforced ? "enforced-platform" : "platform";
        ImmutableList key = ImmutableList.of((Object)original, (Object)componentType, (Object)usage);
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result2 = original;
            result2 = this.concat(result2, (Attribute<T>)USAGE_ATTRIBUTE, new CoercingStringValueSnapshot(usage, this.objectInstantiator));
            result2 = this.concat(result2, (Attribute<T>)CATEGORY_ATTRIBUTE, new CoercingStringValueSnapshot(componentType, this.objectInstantiator));
            return result2;
        });
    }

    @Override
    public ImmutableAttributes sourcesVariant(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"documentation", (Object)"java-runtime", (Object)"sources");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result2 = original;
            result2 = this.concat(result2, (Attribute<T>)CATEGORY_ATTRIBUTE, new CoercingStringValueSnapshot("documentation", this.objectInstantiator));
            result2 = this.concat(result2, Bundling.BUNDLING_ATTRIBUTE, this.objectInstantiator.named(Bundling.class, "external"));
            result2 = this.concat(result2, DocsType.DOCS_TYPE_ATTRIBUTE, this.objectInstantiator.named(DocsType.class, "sources"));
            result2 = this.concat(result2, (Attribute<T>)USAGE_ATTRIBUTE, new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            return result2;
        });
    }

    @Override
    public ImmutableAttributes javadocVariant(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"documentation", (Object)"java-runtime", (Object)"javadoc");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result2 = original;
            result2 = this.concat(result2, (Attribute<T>)CATEGORY_ATTRIBUTE, new CoercingStringValueSnapshot("documentation", this.objectInstantiator));
            result2 = this.concat(result2, Bundling.BUNDLING_ATTRIBUTE, this.objectInstantiator.named(Bundling.class, "external"));
            result2 = this.concat(result2, DocsType.DOCS_TYPE_ATTRIBUTE, this.objectInstantiator.named(DocsType.class, "javadoc"));
            result2 = this.concat(result2, (Attribute<T>)USAGE_ATTRIBUTE, new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            return result2;
        });
    }
}

