/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.result.AbstractDependencyResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedDependencyResult;
import org.gradle.api.internal.artifacts.result.DefaultUnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ResolvedComponentResultSerializer
implements Serializer<ResolvedComponentResult> {
    private final Serializer<ModuleVersionIdentifier> moduleVersionIdSerializer;
    private final Serializer<ComponentIdentifier> componentIdSerializer;
    private final Serializer<ComponentSelector> componentSelectorSerializer;
    private final Serializer<ResolvedVariantResult> resolvedVariantResultSerializer;
    private final Serializer<ComponentSelectionReason> componentSelectionReasonSerializer;

    public ResolvedComponentResultSerializer(Serializer<ModuleVersionIdentifier> moduleVersionIdSerializer, Serializer<ComponentIdentifier> componentIdSerializer, Serializer<ComponentSelector> componentSelectorSerializer, Serializer<ResolvedVariantResult> resolvedVariantResultSerializer, Serializer<ComponentSelectionReason> componentSelectionReasonSerializer) {
        this.moduleVersionIdSerializer = moduleVersionIdSerializer;
        this.componentIdSerializer = componentIdSerializer;
        this.componentSelectorSerializer = componentSelectorSerializer;
        this.resolvedVariantResultSerializer = resolvedVariantResultSerializer;
        this.componentSelectionReasonSerializer = componentSelectionReasonSerializer;
    }

    @Override
    public ResolvedComponentResult read(Decoder decoder) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(Encoder encoder, ResolvedComponentResult value) throws Exception {
        DefaultResolvedComponentResult root = (DefaultResolvedComponentResult)value;
        HashMap<ResolvedComponentResult, Integer> components = new HashMap<ResolvedComponentResult, Integer>();
        this.writeComponent(encoder, root, components);
    }

    private void writeComponent(Encoder encoder, ResolvedComponentResult component, Map<ResolvedComponentResult, Integer> components) throws Exception {
        Integer id = components.get(component);
        if (id != null) {
            encoder.writeSmallInt(id);
            return;
        }
        id = components.size();
        components.put(component, id);
        encoder.writeSmallInt(id);
        this.moduleVersionIdSerializer.write(encoder, component.getModuleVersion());
        this.componentIdSerializer.write(encoder, component.getId());
        this.componentSelectionReasonSerializer.write(encoder, component.getSelectionReason());
        List<ResolvedVariantResult> allVariants = ((ResolvedComponentResultInternal)component).getAllVariants();
        HashSet<ResolvedVariantResult> resolvedVariants = new HashSet<ResolvedVariantResult>(component.getVariants());
        encoder.writeSmallInt(allVariants.size());
        for (ResolvedVariantResult variant : allVariants) {
            this.resolvedVariantResultSerializer.write(encoder, variant);
            encoder.writeBoolean(resolvedVariants.contains(variant));
        }
        Set<? extends DependencyResult> dependencies = component.getDependencies();
        encoder.writeSmallInt(dependencies.size());
        for (DependencyResult dependencyResult : dependencies) {
            AbstractDependencyResult dependencyResult2;
            boolean successful = dependencyResult instanceof ResolvedDependencyResult;
            encoder.writeBoolean(successful);
            if (successful) {
                dependencyResult2 = (DefaultResolvedDependencyResult)dependencyResult;
                this.componentSelectorSerializer.write(encoder, dependencyResult2.getRequested());
                this.writeComponent(encoder, ((DefaultResolvedDependencyResult)dependencyResult2).getSelected(), components);
                continue;
            }
            dependencyResult2 = (DefaultUnresolvedDependencyResult)dependencyResult;
            this.componentSelectorSerializer.write(encoder, dependencyResult2.getRequested());
        }
    }
}

