/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.BuildIdentifierSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

public class ComponentSelectorSerializer
extends AbstractSerializer<ComponentSelector> {
    private final OptimizingAttributeContainerSerializer attributeContainerSerializer;
    private final BuildIdentifierSerializer buildIdentifierSerializer;

    public ComponentSelectorSerializer(AttributeContainerSerializer attributeContainerSerializer) {
        this.attributeContainerSerializer = new OptimizingAttributeContainerSerializer(attributeContainerSerializer);
        this.buildIdentifierSerializer = new BuildIdentifierSerializer();
    }

    void reset() {
        this.attributeContainerSerializer.reset();
    }

    @Override
    public ComponentSelector read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            String projectName = decoder.readString();
            return new DefaultProjectComponentSelector(buildIdentifier, Path.ROOT, Path.ROOT, projectName, this.readAttributes(decoder), this.readCapabilities(decoder));
        }
        if (Implementation.ROOT_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path projectPath = Path.path(decoder.readString());
            return new DefaultProjectComponentSelector(buildIdentifier, projectPath, projectPath, projectPath.getName(), this.readAttributes(decoder), this.readCapabilities(decoder));
        }
        if (Implementation.OTHER_BUILD_ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path(decoder.readString());
            String projectName = decoder.readString();
            return new DefaultProjectComponentSelector(buildIdentifier, identityPath, Path.ROOT, projectName, this.readAttributes(decoder), this.readCapabilities(decoder));
        }
        if (Implementation.OTHER_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path(decoder.readString());
            Path projectPath = Path.path(decoder.readString());
            return new DefaultProjectComponentSelector(buildIdentifier, identityPath, projectPath, projectPath.getName(), this.readAttributes(decoder), this.readCapabilities(decoder));
        }
        if (Implementation.MODULE.getId() == id) {
            return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), this.readVersionConstraint(decoder), this.readAttributes(decoder), this.readCapabilities(decoder));
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryComponentSelector(decoder.readString(), decoder.readNullableString(), decoder.readNullableString());
        }
        throw new IllegalArgumentException("Unable to find component selector with id: " + id);
    }

    private ImmutableAttributes readAttributes(Decoder decoder) throws IOException {
        return this.attributeContainerSerializer.read(decoder);
    }

    ImmutableVersionConstraint readVersionConstraint(Decoder decoder) throws IOException {
        String requires = decoder.readString();
        String prefers = decoder.readString();
        String strictly = decoder.readString();
        int rejectCount = decoder.readSmallInt();
        ArrayList rejects = Lists.newArrayListWithCapacity((int)rejectCount);
        for (int i = 0; i < rejectCount; ++i) {
            rejects.add(decoder.readString());
        }
        String branch = decoder.readNullableString();
        return new DefaultImmutableVersionConstraint(prefers, requires, strictly, rejects, branch);
    }

    private List<Capability> readCapabilities(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)new ImmutableCapability(decoder.readString(), decoder.readString(), decoder.readNullableString()));
        }
        return builder.build();
    }

    private void writeCapabilities(Encoder encoder, Collection<Capability> capabilities) throws IOException {
        encoder.writeSmallInt(capabilities.size());
        for (Capability capability : capabilities) {
            encoder.writeString(capability.getGroup());
            encoder.writeString(capability.getName());
            encoder.writeNullableString(capability.getVersion());
        }
    }

    @Override
    public void write(Encoder encoder, ComponentSelector value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component selector may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)value;
            encoder.writeString(moduleComponentSelector.getGroup());
            encoder.writeString(moduleComponentSelector.getModule());
            VersionConstraint versionConstraint = moduleComponentSelector.getVersionConstraint();
            this.writeVersionConstraint(encoder, versionConstraint);
            this.writeAttributes(encoder, moduleComponentSelector.getAttributes());
            this.writeCapabilities(encoder, moduleComponentSelector.getRequestedCapabilities());
        } else if (implementation == Implementation.ROOT_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString(projectComponentSelector.getProjectName());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
            this.writeCapabilities(encoder, projectComponentSelector.getRequestedCapabilities());
        } else if (implementation == Implementation.ROOT_BUILD_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString(projectComponentSelector.getProjectPath());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
            this.writeCapabilities(encoder, projectComponentSelector.getRequestedCapabilities());
        } else if (implementation == Implementation.OTHER_BUILD_ROOT_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString(projectComponentSelector.getIdentityPath().getPath());
            encoder.writeString(projectComponentSelector.getProjectName());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
            this.writeCapabilities(encoder, projectComponentSelector.getRequestedCapabilities());
        } else if (implementation == Implementation.OTHER_BUILD_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString(projectComponentSelector.getIdentityPath().getPath());
            encoder.writeString(projectComponentSelector.getProjectPath());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
            this.writeCapabilities(encoder, projectComponentSelector.getRequestedCapabilities());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)value;
            encoder.writeString(libraryComponentSelector.getProjectPath());
            encoder.writeNullableString(libraryComponentSelector.getLibraryName());
            encoder.writeNullableString(libraryComponentSelector.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    private void writeAttributes(Encoder encoder, AttributeContainer attributes) throws IOException {
        this.attributeContainerSerializer.write(encoder, attributes);
    }

    private void writeVersionConstraint(Encoder encoder, VersionConstraint versionConstraint) throws IOException {
        encoder.writeString(versionConstraint.getRequiredVersion());
        encoder.writeString(versionConstraint.getPreferredVersion());
        encoder.writeString(versionConstraint.getStrictVersion());
        List<String> rejectedVersions = versionConstraint.getRejectedVersions();
        encoder.writeSmallInt(rejectedVersions.size());
        for (String rejectedVersion : rejectedVersions) {
            encoder.writeString(rejectedVersion);
        }
        encoder.writeNullableString(versionConstraint.getBranch());
    }

    private Implementation resolveImplementation(ComponentSelector value) {
        Implementation implementation;
        if (value instanceof DefaultModuleComponentSelector) {
            implementation = Implementation.MODULE;
        } else {
            if (value instanceof DefaultProjectComponentSelector) {
                DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
                boolean isARootProject = projectComponentSelector.projectPath().equals(Path.ROOT);
                if (projectComponentSelector.getIdentityPath().equals(Path.ROOT) && isARootProject) {
                    return Implementation.ROOT_PROJECT;
                }
                if (isARootProject) {
                    return Implementation.OTHER_BUILD_ROOT_PROJECT;
                }
                if (!projectComponentSelector.getProjectName().equals(projectComponentSelector.projectPath().getName())) {
                    throw new IllegalArgumentException("Unexpected name for project " + projectComponentSelector.projectPath() + ". Expected: " + projectComponentSelector.projectPath().getName() + ", found: " + projectComponentSelector.getProjectName());
                }
                if (projectComponentSelector.getIdentityPath().equals(projectComponentSelector.projectPath())) {
                    return Implementation.ROOT_BUILD_PROJECT;
                }
                return Implementation.OTHER_BUILD_PROJECT;
            }
            if (value instanceof DefaultLibraryComponentSelector) {
                implementation = Implementation.LIBRARY;
            } else {
                throw new IllegalArgumentException("Unsupported component selector class: " + value.getClass());
            }
        }
        return implementation;
    }

    private static class OptimizingAttributeContainerSerializer
    implements AttributeContainerSerializer {
        private final Map<AttributeContainer, Integer> writeIndex = Maps.newIdentityHashMap();
        private final List<ImmutableAttributes> readIndex = Lists.newArrayList();
        private final AttributeContainerSerializer delegate;

        private OptimizingAttributeContainerSerializer(AttributeContainerSerializer delegate) {
            this.delegate = delegate;
        }

        public void reset() {
            this.writeIndex.clear();
            this.readIndex.clear();
        }

        @Override
        public ImmutableAttributes read(Decoder decoder) throws IOException {
            ImmutableAttributes attributes;
            boolean empty = decoder.readBoolean();
            if (empty) {
                return ImmutableAttributes.EMPTY;
            }
            int idx = decoder.readSmallInt();
            if (idx == this.readIndex.size()) {
                attributes = this.delegate.read(decoder);
                this.readIndex.add(attributes);
            } else {
                attributes = this.readIndex.get(idx);
            }
            return attributes;
        }

        @Override
        public void write(Encoder encoder, AttributeContainer container) throws IOException {
            if (container.isEmpty()) {
                encoder.writeBoolean(true);
                return;
            }
            encoder.writeBoolean(false);
            Integer idx = this.writeIndex.get(container);
            if (idx == null) {
                encoder.writeSmallInt(this.writeIndex.size());
                this.writeIndex.put(container, this.writeIndex.size());
                this.delegate.write(encoder, container);
            } else {
                encoder.writeSmallInt(idx);
            }
        }
    }

    private static enum Implementation {
        MODULE(1),
        ROOT_PROJECT(2),
        ROOT_BUILD_PROJECT(3),
        OTHER_BUILD_ROOT_PROJECT(4),
        OTHER_BUILD_PROJECT(5),
        LIBRARY(6),
        SNAPSHOT(7);

        private final byte id;

        private Implementation(int id) {
            this.id = (byte)id;
        }

        byte getId() {
            return this.id;
        }
    }
}

