/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedVariantResultSerializer;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentResultSerializer
implements Serializer<ResolvedGraphComponent> {
    private final ModuleVersionIdentifierSerializer idSerializer;
    private final ComponentSelectionReasonSerializer reasonSerializer;
    private final ComponentIdentifierSerializer componentIdSerializer;
    private final ResolvedVariantResultSerializer resolvedVariantResultSerializer;
    private final boolean returnAllVariants;

    public ComponentResultSerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory, ResolvedVariantResultSerializer resolvedVariantResultSerializer, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, ComponentIdentifierSerializer componentIdentifierSerializer, boolean returnAllVariants) {
        this.idSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        this.resolvedVariantResultSerializer = resolvedVariantResultSerializer;
        this.reasonSerializer = new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory);
        this.componentIdSerializer = componentIdentifierSerializer;
        this.returnAllVariants = returnAllVariants;
    }

    void reset() {
        this.resolvedVariantResultSerializer.reset();
    }

    @Override
    public ResolvedGraphComponent read(Decoder decoder) throws IOException {
        long resultId = decoder.readSmallLong();
        ModuleVersionIdentifier id = this.idSerializer.read(decoder);
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        ComponentIdentifier componentId = this.componentIdSerializer.read(decoder);
        int allVariantsSize = decoder.readSmallInt();
        ImmutableList.Builder allVariants = ImmutableList.builderWithExpectedSize((int)allVariantsSize);
        int resolvedVariantsSize = decoder.readSmallInt();
        ImmutableList.Builder resolvedVariants = ImmutableList.builderWithExpectedSize((int)resolvedVariantsSize);
        this.readVariants(decoder, allVariantsSize, resolvedVariantsSize, (ImmutableList.Builder<ResolvedVariantResult>)allVariants, (ImmutableList.Builder<ResolvedVariantResult>)resolvedVariants);
        String repositoryName = decoder.readNullableString();
        return new DetachedComponentResult(resultId, id, reason, componentId, (List<ResolvedVariantResult>)resolvedVariants.build(), (List<ResolvedVariantResult>)allVariants.build(), repositoryName);
    }

    private void readVariants(Decoder decoder, int allVariantsSize, int resolvedVariantsSize, ImmutableList.Builder<ResolvedVariantResult> allVariants, ImmutableList.Builder<ResolvedVariantResult> resolvedVariants) throws IOException {
        boolean returnAllVariants = allVariantsSize != resolvedVariantsSize;
        for (int i = 0; i < allVariantsSize; ++i) {
            ResolvedVariantResult variant = this.resolvedVariantResultSerializer.read(decoder);
            boolean isResolved = returnAllVariants ? decoder.readBoolean() : true;
            if (isResolved) {
                resolvedVariants.add((Object)variant);
            }
            allVariants.add((Object)variant);
        }
    }

    @Override
    public void write(Encoder encoder, ResolvedGraphComponent value) throws IOException {
        ImmutableSet resolvedVariants;
        List<ResolvedVariantResult> allVariants;
        encoder.writeSmallLong(value.getResultId());
        this.idSerializer.write(encoder, value.getModuleVersion());
        this.reasonSerializer.write(encoder, value.getSelectionReason());
        this.componentIdSerializer.write(encoder, value.getComponentId());
        if (this.returnAllVariants) {
            allVariants = value.getAllVariants();
            resolvedVariants = ImmutableSet.copyOf(value.getResolvedVariants());
        } else {
            allVariants = value.getResolvedVariants();
            resolvedVariants = ImmutableSet.copyOf(allVariants);
        }
        this.writeSelectedVariantDetails(encoder, (Set<ResolvedVariantResult>)resolvedVariants, allVariants);
        encoder.writeNullableString(value.getRepositoryName());
    }

    private void writeSelectedVariantDetails(Encoder encoder, Set<ResolvedVariantResult> resolvedVariants, List<ResolvedVariantResult> variants) throws IOException {
        encoder.writeSmallInt(variants.size());
        encoder.writeSmallInt(resolvedVariants.size());
        boolean returnAllVariants = variants.size() != resolvedVariants.size();
        for (ResolvedVariantResult variant : variants) {
            this.resolvedVariantResultSerializer.write(encoder, variant);
            if (!returnAllVariants) continue;
            encoder.writeBoolean(resolvedVariants.contains(variant));
        }
    }
}

