/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.NoOpDerivationStrategy;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

class LenientPlatformResolveMetadata
implements ModuleComponentResolveMetadata {
    private final ModuleComponentIdentifier moduleComponentIdentifier;
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final VirtualPlatformState platformState;
    private final NodeState platformNode;
    private final ResolveState resolveState;

    LenientPlatformResolveMetadata(ModuleComponentIdentifier moduleComponentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, VirtualPlatformState platformState, NodeState platformNode, ResolveState resolveState) {
        this.moduleComponentIdentifier = moduleComponentIdentifier;
        this.moduleVersionIdentifier = moduleVersionIdentifier;
        this.platformState = platformState;
        this.platformNode = platformNode;
        this.resolveState = resolveState;
    }

    @Override
    public ModuleComponentIdentifier getId() {
        return this.moduleComponentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSources getSources() {
        return null;
    }

    @Override
    public AttributesSchemaInternal getAttributesSchema() {
        return EmptySchema.INSTANCE;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return Collections.singleton("default");
    }

    LenientPlatformResolveMetadata withVersion(ModuleComponentIdentifier moduleComponentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier) {
        return new LenientPlatformResolveMetadata(moduleComponentIdentifier, moduleVersionIdentifier, this.platformState, this.platformNode, this.resolveState);
    }

    @Override
    @Nullable
    public ConfigurationMetadata getConfiguration(String name) {
        if ("default".equals(name)) {
            ImmutableList.Builder dependencies = new ImmutableList.Builder();
            Set<ModuleResolveState> participatingModules = this.platformState.getParticipatingModules();
            for (ModuleResolveState module : participatingModules) {
                dependencies.add((Object)new LenientPlatformDependencyMetadata(this.resolveState, this.platformNode, DefaultModuleComponentSelector.newSelector(module.getId(), this.moduleVersionIdentifier.getVersion()), DefaultModuleComponentIdentifier.newId(module.getId(), this.moduleVersionIdentifier.getVersion()), this.platformState.getSelectedPlatformId(), this.platformState.isForced(), true));
            }
            return new RealisedConfigurationMetadata(this.moduleComponentIdentifier, name, false, false, (ImmutableSet<String>)ImmutableSet.of((Object)name), (ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of(), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), ImmutableAttributes.EMPTY, ImmutableCapabilities.EMPTY, (ImmutableList<ModuleDependencyMetadata>)dependencies.build(), false, false);
        }
        throw new IllegalArgumentException("Undefined configuration '" + name + "'");
    }

    @Override
    public Optional<ImmutableList<? extends ConfigurationMetadata>> getVariantsForGraphTraversal() {
        return Optional.absent();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return null;
    }

    @Override
    public List<String> getStatusScheme() {
        return null;
    }

    @Override
    public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
        return ImmutableList.of();
    }

    @Override
    public MutableModuleComponentResolveMetadata asMutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModuleComponentResolveMetadata withSources(ModuleSources sources) {
        return this;
    }

    @Override
    public ModuleComponentResolveMetadata withDerivationStrategy(VariantDerivationStrategy derivationStrategy) {
        return this;
    }

    @Override
    public VariantDerivationStrategy getVariantDerivationStrategy() {
        return NoOpDerivationStrategy.getInstance();
    }

    @Override
    public boolean isExternalVariant() {
        return false;
    }

    @Override
    public boolean isComponentMetadataRuleCachingEnabled() {
        return true;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModuleComponentArtifactMetadata optionalArtifact(String type, @Nullable String extension, @Nullable String classifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<? extends ComponentVariant> getVariants() {
        return ImmutableList.of();
    }

    @Override
    public ImmutableAttributesFactory getAttributesFactory() {
        return null;
    }

    @Override
    public VariantMetadataRules getVariantMetadataRules() {
        return VariantMetadataRules.noOp();
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    VirtualPlatformState getPlatformState() {
        return this.platformState;
    }
}

