/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencyConstraintSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ArtifactCollectionInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationPublications;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.ProjectDependencyObservedListener;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationDetails;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationResult;
import org.gradle.api.internal.artifacts.configurations.ResolveExceptionWithHints;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFileCollectionVisitor;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedProjectConfiguration;
import org.gradle.api.internal.artifacts.transform.DefaultExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributeContainerWithErrorMessage;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.attributes.IncubatingAttributesChecker;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.provider.BuildableBackedSetProvider;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.tasks.FailureCollectingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.WrapUtil;

public class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator {
    private static final Action<Throwable> DEFAULT_ERROR_HANDLER = throwable -> {
        throw UncheckedException.throwAsUncheckedException(throwable);
    };
    private final ConfigurationResolver resolver;
    private final DependencyMetaDataProvider metaDataProvider;
    private final DefaultDependencySet dependencies;
    private final DefaultDependencyConstraintSet dependencyConstraints;
    private final DefaultDomainObjectSet<Dependency> ownDependencies;
    private final DefaultDomainObjectSet<DependencyConstraint> ownDependencyConstraints;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private CompositeDomainObjectSet<DependencyConstraint> inheritedDependencyConstraints;
    private DefaultDependencySet allDependencies;
    private DefaultDependencyConstraintSet allDependencyConstraints;
    private ImmutableActionSet<DependencySet> defaultDependencyActions = ImmutableActionSet.empty();
    private ImmutableActionSet<DependencySet> withDependencyActions = ImmutableActionSet.empty();
    private final DefaultPublishArtifactSet artifacts;
    private final DefaultDomainObjectSet<PublishArtifact> ownArtifacts;
    private CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies;
    private ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private ProjectDependencyObservedListener dependencyObservedBroadcast;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Instantiator instantiator;
    private Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private ResolutionStrategyInternal resolutionStrategy;
    private final FileCollectionFactory fileCollectionFactory;
    private final DocumentationRegistry documentationRegistry;
    private final Set<MutationValidator> childMutationValidators = Sets.newHashSet();
    private final MutationValidator parentMutationValidator = this::validateParentMutation;
    private final RootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final Path identityPath;
    private final Path path;
    private final String name;
    private final DefaultConfigurationPublications outgoing;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private final Set<Object> excludeRules = new LinkedHashSet<Object>();
    private Set<ExcludeRule> parsedExcludeRules;
    private boolean returnAllVariants = false;
    private final Object observationLock = new Object();
    private volatile ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private boolean insideBeforeResolve;
    private boolean dependenciesModified;
    private boolean canBeConsumed = true;
    private boolean canBeResolved = true;
    private boolean canBeMutated = true;
    private AttributeContainerInternal configurationAttributes;
    private final DomainObjectContext domainObjectContext;
    private final ImmutableAttributesFactory attributesFactory;
    private final ConfigurationFileCollection intrinsicFiles;
    private final DisplayName displayName;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final Lazy<List<DependencyConstraint>> consistentResolutionConstraints = Lazy.unsafe().of(this::consistentResolutionConstraints);
    private final AtomicInteger copyCount = new AtomicInteger(0);
    private Action<? super ConfigurationInternal> beforeLocking;
    private List<String> declarationAlternatives;
    private DeprecationMessageBuilder.WithDocumentation consumptionDeprecation;
    private List<String> resolutionAlternatives;
    private final CalculatedModelValue<ResolveState> currentResolveState;
    private ConfigurationInternal consistentResolutionSource;
    private String consistentResolutionReason;
    private ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory;
    private final DefaultConfigurationFactory defaultConfigurationFactory;

    public DefaultConfiguration(DomainObjectContext domainObjectContext, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners, ProjectDependencyObservedListener dependencyObservedBroadcast, DependencyMetaDataProvider metaDataProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, FileCollectionFactory fileCollectionFactory, BuildOperationExecutor buildOperationExecutor, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, ImmutableAttributesFactory attributesFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder, DocumentationRegistry documentationRegistry, UserCodeApplicationContext userCodeApplicationContext, ProjectStateRegistry projectStateRegistry, WorkerThreadRegistry workerThreadRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, DefaultConfigurationFactory defaultConfigurationFactory) {
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.workerThreadRegistry = workerThreadRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.identityPath = domainObjectContext.identityPath(name);
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.metaDataProvider = metaDataProvider;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.dependencyResolutionListeners = dependencyResolutionListeners;
        this.dependencyObservedBroadcast = dependencyObservedBroadcast;
        this.buildOperationExecutor = buildOperationExecutor;
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.configurationAttributes = attributesFactory.mutable();
        this.domainObjectContext = domainObjectContext;
        this.intrinsicFiles = this.fileCollectionFromSpec(Specs.satisfyAll());
        this.documentationRegistry = documentationRegistry;
        this.resolvableDependencies = instantiator.newInstance(ConfigurationResolvableDependencies.class, this);
        this.displayName = Describables.memoize(new ConfigurationDescription(this.identityPath));
        this.ownDependencies = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(Dependency.class);
        this.ownDependencies.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.ownDependencyConstraints = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class);
        this.ownDependencyConstraints.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.dependencies = new DefaultDependencySet(Describables.of(this.displayName, "dependencies"), this, this.ownDependencies);
        this.dependencyConstraints = new DefaultDependencyConstraintSet(Describables.of(this.displayName, "dependency constraints"), this, this.ownDependencyConstraints);
        this.ownArtifacts = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class);
        this.ownArtifacts.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet(Describables.of(this.displayName, "artifacts"), this.ownArtifacts, fileCollectionFactory);
        this.outgoing = instantiator.newInstance(DefaultConfigurationPublications.class, this.displayName, this.artifacts, new AllArtifactsProvider(), this.configurationAttributes, instantiator, artifactNotationParser, capabilityNotationParser, fileCollectionFactory, attributesFactory, domainObjectCollectionFactory);
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilder;
        this.currentResolveState = domainObjectContext.getModel().newCalculatedValue(ResolveState.NOT_RESOLVED);
        this.path = domainObjectContext.projectPath(name);
        this.defaultConfigurationFactory = defaultConfigurationFactory;
    }

    private static Action<Void> validateMutationType(MutationValidator mutationValidator, MutationValidator.MutationType type) {
        return arg -> mutationValidator.validateMutation(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Configuration.State getState() {
        ResolveState currentState = this.currentResolveState.get();
        ConfigurationInternal.InternalState resolvedState = currentState.state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (currentState.hasError()) {
                return Configuration.State.RESOLVED_WITH_FAILURES;
            }
            return Configuration.State.RESOLVED;
        }
        return Configuration.State.UNRESOLVED;
    }

    @VisibleForTesting
    public ConfigurationInternal.InternalState getResolvedState() {
        return this.currentResolveState.get().state;
    }

    @Override
    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.visible = visible;
        return this;
    }

    @Override
    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    @Override
    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        for (Configuration configuration2 : this.extendsFrom) {
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.removeCollection(configuration2.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.removeCollection(configuration2.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.removeCollection(configuration2.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration2).removeMutationValidator(this.parentMutationValidator);
        }
        this.extendsFrom = new LinkedHashSet<Configuration>();
        for (Configuration configuration2 : extendsFrom) {
            this.extendsFrom(configuration2);
        }
        return this;
    }

    @Override
    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        for (Configuration configuration2 : extendsFrom) {
            if (configuration2.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration2, configuration2.getHierarchy()));
            }
            if (!this.extendsFrom.add(configuration2)) continue;
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.addCollection(configuration2.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.addCollection(configuration2.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.addCollection(configuration2.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration2).addMutationValidator(this.parentMutationValidator);
        }
        return this;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.transitive = transitive;
        return this;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public Configuration setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Override
    public Set<Configuration> getHierarchy() {
        if (this.extendsFrom.isEmpty()) {
            return Collections.singleton(this);
        }
        Set<Configuration> result2 = WrapUtil.toLinkedSet(this);
        this.collectSuperConfigs(this, result2);
        return result2;
    }

    private void collectSuperConfigs(Configuration configuration2, Set<Configuration> result2) {
        for (Configuration superConfig : configuration2.getExtendsFrom()) {
            result2.remove(superConfig);
            result2.add(superConfig);
            this.collectSuperConfigs(superConfig, result2);
        }
    }

    @Override
    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.defaultDependencyActions = this.defaultDependencyActions.add(dependencies -> {
            if (dependencies.isEmpty()) {
                action.execute((DependencySet)dependencies);
            }
        });
        return this;
    }

    @Override
    public Configuration withDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.withDependencyActions = this.withDependencyActions.add(action);
        return this;
    }

    @Override
    public void runDependencyActions() {
        this.defaultDependencyActions.execute(this.dependencies);
        this.withDependencyActions.execute(this.dependencies);
        this.defaultDependencyActions = ImmutableActionSet.empty();
        this.withDependencyActions = ImmutableActionSet.empty();
        for (Configuration superConfig : this.extendsFrom) {
            ((ConfigurationInternal)superConfig).runDependencyActions();
        }
    }

    @Override
    public Set<Configuration> getAll() {
        return ImmutableSet.copyOf(this.configurationsProvider.getAll());
    }

    @Override
    public Set<File> resolve() {
        return this.getFiles();
    }

    @Override
    public Iterator<File> iterator() {
        return this.intrinsicFiles.iterator();
    }

    @Override
    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.intrinsicFiles.visitContents(visitor);
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        formatter.node("configuration: " + this.getIdentityPath());
    }

    @Override
    public boolean contains(File file) {
        return this.intrinsicFiles.contains(file);
    }

    @Override
    public boolean isEmpty() {
        return this.intrinsicFiles.isEmpty();
    }

    @Override
    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    @Override
    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    @Override
    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    @Override
    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        this.assertIsResolvable();
        return this.fileCollectionFromSpec(dependencySpec);
    }

    private ConfigurationFileCollection fileCollectionFromSpec(Spec<? super Dependency> dependencySpec) {
        return new ConfigurationFileCollection(new SelectedArtifactsProvider(), dependencySpec, this.configurationAttributes, Specs.satisfyAll(), false, false, new DefaultResolutionHost());
    }

    @Override
    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return this.fileCollection(Specs.convertClosureToSpec(dependencySpecClosure));
    }

    @Override
    public FileCollection fileCollection(Dependency ... dependencies) {
        Set<Dependency> deps = WrapUtil.toLinkedSet(dependencies);
        return this.fileCollection(deps::contains);
    }

    @Override
    public void markAsObserved(ConfigurationInternal.InternalState requestedState) {
        this.markThisObserved(requestedState);
        this.markParentsObserved(requestedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markThisObserved(ConfigurationInternal.InternalState requestedState) {
        Object object = this.observationLock;
        synchronized (object) {
            if (this.observedState.compareTo(requestedState) < 0) {
                this.observedState = requestedState;
            }
        }
    }

    private void markParentsObserved(ConfigurationInternal.InternalState requestedState) {
        for (Configuration configuration2 : this.extendsFrom) {
            ((ConfigurationInternal)configuration2).markAsObserved(requestedState);
        }
    }

    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        return this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED).getResolvedConfiguration();
    }

    private ResolveState resolveToStateOrLater(ConfigurationInternal.InternalState requestedState) {
        this.assertIsResolvable();
        this.warnIfConfigurationIsDeprecatedForResolving();
        ResolveState currentState = this.currentResolveState.get();
        if (currentState.state.compareTo(requestedState) >= 0) {
            return currentState;
        }
        if (!this.domainObjectContext.getModel().hasMutableState()) {
            if (!this.workerThreadRegistry.isWorkerThread()) {
                throw new IllegalStateException("The configuration " + this.identityPath.toString() + " was resolved from a thread not managed by Gradle.");
            }
            DeprecationLogger.deprecateBehaviour("Resolution of the configuration " + this.identityPath.toString() + " was attempted from a context different than the project context. Have a look at the documentation to understand why this is a problem and how it can be resolved.").willBeRemovedInGradle8().withUserManual("viewing_debugging_dependencies", "sub:resolving-unsafe-configuration-resolution-errors").nagUser();
            return this.domainObjectContext.getModel().fromMutableState(p -> this.resolveExclusively(requestedState));
        }
        return this.resolveExclusively(requestedState);
    }

    private void warnIfConfigurationIsDeprecatedForResolving() {
        if (this.resolutionAlternatives != null) {
            ((DeprecationMessageBuilder.DeprecateConfiguration)DeprecationLogger.deprecateConfiguration(this.name).forResolution().replaceWith(this.resolutionAlternatives)).willBecomeAnErrorInGradle8().withUpgradeGuideSection(5, "dependencies_should_no_longer_be_declared_using_the_compile_and_runtime_configurations").nagUser();
        }
    }

    private ResolveState resolveExclusively(ConfigurationInternal.InternalState requestedState) {
        return this.currentResolveState.update(initial -> {
            ResolveState current = initial;
            if (requestedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                current = this.resolveGraphIfRequired(requestedState, current);
            }
            if (requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                current = this.resolveArtifactsIfRequired(current);
            }
            return current;
        });
    }

    private ResolveState resolveGraphIfRequired(final ConfigurationInternal.InternalState requestedState, ResolveState currentState) {
        if (currentState.state == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || currentState.state == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (this.dependenciesModified) {
                throw new InvalidUserDataException(String.format("Attempted to resolve %s that has been resolved previously.", this.getDisplayName()));
            }
            return currentState;
        }
        return this.buildOperationExecutor.call(new CallableBuildOperation<ResolveState>(){

            @Override
            public ResolveState call(BuildOperationContext context) {
                DefaultConfiguration.this.runDependencyActions();
                DefaultConfiguration.this.preventFromFurtherMutation();
                ResolvableDependenciesInternal incoming = (ResolvableDependenciesInternal)DefaultConfiguration.this.getIncoming();
                DefaultConfiguration.this.performPreResolveActions(incoming);
                DefaultResolverResults results = new DefaultResolverResults();
                DefaultConfiguration.this.resolver.resolveGraph(DefaultConfiguration.this, results);
                DefaultConfiguration.this.dependenciesModified = false;
                ResolveState newState = new GraphResolved(results);
                DefaultConfiguration.this.currentResolveState.set(newState);
                DefaultConfiguration.this.markParentsObserved(requestedState);
                DefaultConfiguration.this.markReferencedProjectConfigurationsObserved(requestedState, results);
                if (!((ResolveState)newState).hasError()) {
                    ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).afterResolve(incoming);
                    DefaultConfiguration.this.dependencyResolutionListeners.removeAll();
                    newState = (ResolveState)DefaultConfiguration.this.currentResolveState.get();
                }
                this.captureBuildOperationResult(context, results);
                return newState;
            }

            private void captureBuildOperationResult(BuildOperationContext context, ResolverResults results) {
                Throwable failure = results.getFailure();
                if (failure != null) {
                    context.failed(failure);
                }
                ResolutionResult resolutionResult = results.getResolutionResult();
                context.setResult(ResolveConfigurationResolutionBuildOperationResult.create(resolutionResult, DefaultConfiguration.this.attributesFactory));
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve dependencies of " + DefaultConfiguration.this.identityPath;
                Path projectPath = DefaultConfiguration.this.domainObjectContext.getProjectPath();
                String projectPathString = null;
                if (!DefaultConfiguration.this.domainObjectContext.isScript() && projectPath != null) {
                    projectPathString = projectPath.getPath();
                }
                return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName).details(new ResolveConfigurationResolutionBuildOperationDetails(DefaultConfiguration.this.getName(), DefaultConfiguration.this.domainObjectContext.isScript(), DefaultConfiguration.this.getDescription(), DefaultConfiguration.this.domainObjectContext.getBuildPath().getPath(), projectPathString, DefaultConfiguration.this.isVisible(), DefaultConfiguration.this.isTransitive(), DefaultConfiguration.this.resolver.getRepositories()));
            }
        });
    }

    @Override
    public ConfigurationInternal getConsistentResolutionSource() {
        return this.consistentResolutionSource;
    }

    private List<DependencyConstraint> consistentResolutionConstraints() {
        if (this.consistentResolutionSource == null) {
            return Collections.emptyList();
        }
        this.assertThatConsistentResolutionIsPropertyConfigured();
        return this.consistentResolutionSource.getIncoming().getResolutionResult().getAllComponents().stream().map(this::registerConsistentResolutionConstraint).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private void assertThatConsistentResolutionIsPropertyConfigured() {
        if (!this.consistentResolutionSource.isCanBeResolved()) {
            throw new InvalidUserCodeException("You can't use " + this.consistentResolutionSource + " as a consistent resolution source for " + this + " because it isn't a resolvable configuration.");
        }
        this.assertNoDependencyResolutionConsistencyCycle();
    }

    @Override
    public Supplier<List<DependencyConstraint>> getConsistentResolutionConstraints() {
        return this.consistentResolutionConstraints;
    }

    @Override
    public ResolveException maybeAddContext(ResolveException e) {
        return this.failuresWithHint(e.getCauses()).orElse(e);
    }

    private Optional<ResolveException> failuresWithHint(Collection<? extends Throwable> causes) {
        try {
            if (this.ignoresSettingsRepositories()) {
                boolean hasModuleNotFound = causes.stream().anyMatch(ModuleVersionNotFoundException.class::isInstance);
                if (hasModuleNotFound) {
                    return Optional.of(new ResolveExceptionWithHints(this.getDisplayName(), causes, "The project declares repositories, effectively ignoring the repositories you have declared in the settings.", "You can figure out how project repositories are declared by configuring your build to fail on project repositories.", "See " + this.documentationRegistry.getDocumentationFor("declaring_repositories", "sub:fail_build_on_project_repositories") + " for details."));
                }
            }
        }
        catch (Throwable e) {
            return Optional.of(new ResolveException(this.getDisplayName(), (Iterable<? extends Throwable>)ImmutableList.builder().addAll(causes).add((Object)e).build()));
        }
        return Optional.empty();
    }

    private boolean ignoresSettingsRepositories() {
        if (this.domainObjectContext instanceof ProjectInternal) {
            ProjectInternal project = (ProjectInternal)this.domainObjectContext;
            return !project.getRepositories().isEmpty() && !project.getGradle().getSettings().getDependencyResolutionManagement().getRepositories().isEmpty();
        }
        return false;
    }

    private void assertNoDependencyResolutionConsistencyCycle() {
        LinkedHashSet sources = Sets.newLinkedHashSet();
        for (ConfigurationInternal src = this; src != null; src = src.getConsistentResolutionSource()) {
            if (sources.add(src)) continue;
            String cycle = sources.stream().map(Configuration::getName).collect(Collectors.joining(" -> ")) + " -> " + this.getName();
            throw new InvalidUserDataException("Cycle detected in consistent resolution sources: " + cycle);
        }
    }

    private Optional<DependencyConstraint> registerConsistentResolutionConstraint(ResolvedComponentResult result2) {
        if (result2.getId() instanceof ModuleComponentIdentifier) {
            ModuleVersionIdentifier moduleVersion = result2.getModuleVersion();
            DefaultDependencyConstraint constraint = DefaultDependencyConstraint.strictly(moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            constraint.because(this.consistentResolutionReason);
            return Optional.of(constraint);
        }
        return Optional.empty();
    }

    private void performPreResolveActions(ResolvableDependencies incoming) {
        DependencyResolutionListener dependencyResolutionListener = this.dependencyResolutionListeners.getSource();
        this.insideBeforeResolve = true;
        try {
            dependencyResolutionListener.beforeResolve(incoming);
        }
        finally {
            this.insideBeforeResolve = false;
        }
    }

    private void markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState requestedState, ResolverResults results) {
        ProjectInternal consumingProject = this.domainObjectContext.getProject();
        ProjectState consumingProjectState = consumingProject == null ? null : consumingProject.getOwner();
        for (ResolvedProjectConfiguration projectResult : results.getResolvedLocalComponents().getResolvedProjectConfigurations()) {
            ProjectState targetProjectState = this.projectStateRegistry.stateFor(projectResult.getId());
            this.dependencyObservedBroadcast.dependencyObserved(consumingProjectState, targetProjectState, requestedState, projectResult);
        }
    }

    private ResolveState resolveArtifactsIfRequired(ResolveState currentState) {
        if (currentState.state == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            return currentState;
        }
        if (currentState.state != ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new IllegalStateException("Cannot resolve artifacts before graph has been resolved.");
        }
        ResolverResults results = currentState.getCachedResolverResults();
        this.resolver.resolveArtifacts(this, results);
        return new ArtifactsResolved(results);
    }

    @Override
    public ExtraExecutionGraphDependenciesResolverFactory getDependenciesResolver() {
        if (this.dependenciesResolverFactory == null) {
            this.dependenciesResolverFactory = new DefaultExtraExecutionGraphDependenciesResolverFactory(new DefaultResolutionResultProvider(), this.domainObjectContext, this.calculatedValueContainerFactory, (attributes, filter) -> {
                ImmutableAttributes fullAttributes = this.attributesFactory.concat(this.configurationAttributes.asImmutable(), attributes);
                return new ConfigurationFileCollection(new SelectedArtifactsProvider(), Specs.satisfyAll(), fullAttributes, filter, false, false, new DefaultResolutionHost());
            });
        }
        return this.dependenciesResolverFactory;
    }

    private ResolverResults getResultsForBuildDependencies() {
        ResolveState currentState = this.currentResolveState.get();
        if (currentState.state == ConfigurationInternal.InternalState.UNRESOLVED) {
            throw new IllegalStateException("Cannot query results until resolution has happened.");
        }
        return currentState.getCachedResolverResults();
    }

    private ResolverResults resolveGraphForBuildDependenciesIfRequired() {
        if (this.getResolutionStrategy().resolveGraphToDetermineTaskDependencies()) {
            return this.resolveToStateOrLater(ConfigurationInternal.InternalState.GRAPH_RESOLVED).getCachedResolverResults();
        }
        ResolveState currentState = this.currentResolveState.update(initial -> {
            if (initial.state == ConfigurationInternal.InternalState.UNRESOLVED) {
                DefaultResolverResults results = new DefaultResolverResults();
                this.resolver.resolveBuildDependencies(this, results);
                this.markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED, results);
                return new BuildDependenciesResolved(results);
            }
            return initial;
        });
        return currentState.getCachedResolverResults();
    }

    private ResolverResults getResultsForArtifacts() {
        ResolveState currentState = this.currentResolveState.get();
        if (currentState.state != ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            currentState = this.resolveExclusively(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
        }
        return currentState.getCachedResolverResults();
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.assertIsResolvable();
        context.add(this.intrinsicFiles);
    }

    @Override
    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, this.getAllDependencies());
        }
        return new TasksFromDependentProjects(taskName, this.getName());
    }

    @Override
    public DependencySet getDependencies() {
        return this.dependencies;
    }

    @Override
    public DependencySet getAllDependencies() {
        if (this.allDependencies == null) {
            this.initAllDependencies();
        }
        return this.allDependencies;
    }

    private synchronized void initAllDependencies() {
        if (this.allDependencies != null) {
            return;
        }
        this.inheritedDependencies = this.domainObjectCollectionFactory.newDomainObjectSet(Dependency.class, this.ownDependencies);
        for (Configuration configuration2 : this.extendsFrom) {
            this.inheritedDependencies.addCollection(configuration2.getAllDependencies());
        }
        this.allDependencies = new DefaultDependencySet(Describables.of(this.displayName, "all dependencies"), this, this.inheritedDependencies);
    }

    @Override
    public DependencyConstraintSet getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    @Override
    public DependencyConstraintSet getAllDependencyConstraints() {
        if (this.allDependencyConstraints == null) {
            this.initAllDependencyConstraints();
        }
        return this.allDependencyConstraints;
    }

    private synchronized void initAllDependencyConstraints() {
        if (this.allDependencyConstraints != null) {
            return;
        }
        this.inheritedDependencyConstraints = this.domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class, this.ownDependencyConstraints);
        for (Configuration configuration2 : this.extendsFrom) {
            this.inheritedDependencyConstraints.addCollection(configuration2.getAllDependencyConstraints());
        }
        this.allDependencyConstraints = new DefaultDependencyConstraintSet(Describables.of(this.displayName, "all dependency constraints"), this, this.inheritedDependencyConstraints);
    }

    @Override
    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public PublishArtifactSet getAllArtifacts() {
        this.initAllArtifacts();
        return this.allArtifacts;
    }

    private synchronized void initAllArtifacts() {
        if (this.allArtifacts != null) {
            return;
        }
        DisplayName displayName = Describables.of(this.displayName, "all artifacts");
        if (!this.canBeMutated && this.extendsFrom.isEmpty()) {
            this.allArtifacts = new DefaultPublishArtifactSet(displayName, this.ownArtifacts, this.fileCollectionFactory);
            return;
        }
        if (this.canBeMutated) {
            this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
        }
        for (Configuration configuration2 : this.extendsFrom) {
            PublishArtifactSet allArtifacts = configuration2.getAllArtifacts();
            if (this.inheritedArtifacts == null && allArtifacts.isEmpty()) continue;
            if (this.inheritedArtifacts == null) {
                this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
            }
            this.inheritedArtifacts.addCollection(allArtifacts);
        }
        this.allArtifacts = this.inheritedArtifacts != null ? new DefaultPublishArtifactSet(displayName, this.inheritedArtifacts, this.fileCollectionFactory) : new DefaultPublishArtifactSet(displayName, this.ownArtifacts, this.fileCollectionFactory);
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        this.initExcludeRules();
        return Collections.unmodifiableSet(this.parsedExcludeRules);
    }

    @Override
    public Set<ExcludeRule> getAllExcludeRules() {
        LinkedHashSet result2 = Sets.newLinkedHashSet();
        result2.addAll(this.getExcludeRules());
        for (Configuration config : this.extendsFrom) {
            result2.addAll(((ConfigurationInternal)config).getAllExcludeRules());
        }
        return result2;
    }

    private synchronized void initExcludeRules() {
        if (this.parsedExcludeRules == null) {
            NotationParser<Object, ExcludeRule> parser = ExcludeRuleNotationConverter.parser();
            this.parsedExcludeRules = Sets.newLinkedHashSet();
            for (Object excludeRule : this.excludeRules) {
                this.parsedExcludeRules.add(parser.parseNotation(excludeRule));
            }
        }
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.clear();
        this.excludeRules.addAll(excludeRules);
    }

    @Override
    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.add(excludeRuleArgs);
        return this;
    }

    @Override
    @Deprecated
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    @Override
    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    @Override
    public ConfigurationPublications getOutgoing() {
        return this.outgoing;
    }

    @Override
    public OutgoingVariant convertToOutgoingVariant() {
        return this.outgoing.convertToOutgoingVariant();
    }

    @Override
    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        this.outgoing.collectVariants(visitor);
    }

    @Override
    public void beforeLocking(Action<? super ConfigurationInternal> action) {
        if (this.canBeMutated) {
            this.beforeLocking = this.beforeLocking != null ? Actions.composite(this.beforeLocking, action) : action;
        }
    }

    @Override
    public boolean isCanBeMutated() {
        return this.canBeMutated;
    }

    @Override
    public void preventFromFurtherMutation() {
        if (this.canBeMutated) {
            if (this.beforeLocking != null) {
                this.beforeLocking.execute(this);
                this.beforeLocking = null;
            }
            ImmutableAttributes delegatee = this.configurationAttributes.asImmutable();
            this.configurationAttributes = new ImmutableAttributeContainerWithErrorMessage(delegatee, this.displayName);
            this.outgoing.preventFromFurtherMutation();
            this.canBeMutated = false;
            if (this.isCanBeConsumed() && !this.isCanBeResolved() && !this.getAttributes().isEmpty()) {
                this.ensureUniqueAttributes();
            }
        }
    }

    private void ensureUniqueAttributes() {
        Set<? extends ConfigurationInternal> all;
        Set<? extends ConfigurationInternal> set2 = all = this.configurationsProvider != null ? this.configurationsProvider.getAll() : null;
        if (all != null) {
            Collection<? extends Capability> allCapabilities = this.allCapabilitiesIncludingDefault(this);
            Consumer<ConfigurationInternal> warnIfDuplicate = otherConfiguration -> {
                if (this.hasSameCapabilitiesAs(allCapabilities, (ConfigurationInternal)otherConfiguration) && this.hasSameAttributesAs((ConfigurationInternal)otherConfiguration)) {
                    ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour("Consumable configurations with identical capabilities within a project must have unique attributes, but " + this.getDisplayName() + " and " + otherConfiguration.getDisplayName() + " contain identical attribute sets.").withAdvice("Consider adding an additional attribute to one of the configurations to disambiguate them.  Run the 'outgoingVariants' task for more details.")).willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "unique_attribute_sets").nagUser();
                }
            };
            all.stream().filter(Configuration::isCanBeConsumed).filter((? super T c) -> !c.isCanBeResolved()).filter((? super T c) -> !c.isCanBeMutated()).filter((? super T c) -> c != this).filter((? super T c) -> !c.getAttributes().isEmpty()).forEach(warnIfDuplicate);
        }
    }

    private Collection<? extends Capability> allCapabilitiesIncludingDefault(Configuration conf) {
        if (conf.getOutgoing().getCapabilities().isEmpty()) {
            ProjectInternal project = this.domainObjectContext.getProject();
            if (project == null) {
                throw new IllegalStateException("Project is null for configuration '" + conf.getName() + "'.");
            }
            return Collections.singleton(new ProjectDerivedCapability(project));
        }
        return conf.getOutgoing().getCapabilities();
    }

    private boolean hasSameCapabilitiesAs(Collection<? extends Capability> allMyCapabilities, ConfigurationInternal other) {
        Collection<? extends Capability> allOtherCapabilities = this.allCapabilitiesIncludingDefault(other);
        return allMyCapabilities.size() == allOtherCapabilities.size() && allMyCapabilities.containsAll(allOtherCapabilities);
    }

    private boolean hasSameAttributesAs(ConfigurationInternal other) {
        return other.getAttributes().asMap().equals(this.getAttributes().asMap());
    }

    @Override
    public boolean isIncubating() {
        return IncubatingAttributesChecker.isAnyIncubating(this.getAttributes());
    }

    @Override
    public void outgoing(Action<? super ConfigurationPublications> action) {
        action.execute(this.outgoing);
    }

    @Override
    public ConfigurationInternal copy() {
        return this.createCopy(this.getDependencies(), this.getDependencyConstraints());
    }

    @Override
    public Configuration copyRecursive() {
        return this.createCopy(this.getAllDependencies(), this.getAllDependencyConstraints());
    }

    @Override
    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter(this.getDependencies(), dependencySpec), this.getDependencyConstraints());
    }

    @Override
    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter(this.getAllDependencies(), dependencySpec), this.getAllDependencyConstraints());
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints) {
        DefaultConfiguration copiedConfiguration = this.newConfiguration();
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions = this.defaultDependencyActions;
        copiedConfiguration.withDependencyActions = this.withDependencyActions;
        copiedConfiguration.dependencyResolutionListeners = this.dependencyResolutionListeners.copy();
        copiedConfiguration.canBeConsumed = this.canBeConsumed;
        copiedConfiguration.canBeResolved = this.canBeResolved;
        copiedConfiguration.getArtifacts().addAll(this.getAllArtifacts());
        if (!this.configurationAttributes.isEmpty()) {
            for (Attribute attribute : this.configurationAttributes.keySet()) {
                Object value = this.configurationAttributes.getAttribute(attribute);
                copiedConfiguration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast(attribute), value);
            }
        }
        for (ExcludeRule excludeRule : this.getAllExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add(dependency.copy());
        }
        DependencyConstraintSet dependencyConstraintSet = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            dependencyConstraintSet.add(((DependencyConstraintInternal)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private DefaultConfiguration newConfiguration() {
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        RootComponentMetadataBuilder rootComponentMetadataBuilder = this.rootComponentMetadataBuilder.withConfigurationsProvider(configurationsProvider);
        String newName = this.getNameWithCopySuffix();
        Factory<ResolutionStrategyInternal> childResolutionStrategy = this.resolutionStrategy != null ? Factories.constant(this.resolutionStrategy.copy()) : this.resolutionStrategyFactory;
        DefaultConfiguration copiedConfiguration = this.defaultConfigurationFactory.create(newName, configurationsProvider, childResolutionStrategy, rootComponentMetadataBuilder);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        return copiedConfiguration;
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.name + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    @Override
    public Configuration copy(Closure dependencySpec) {
        return this.copy(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        if (this.resolutionStrategy == null) {
            this.resolutionStrategy = this.resolutionStrategyFactory.create();
            this.resolutionStrategy.setMutationValidator(this);
            this.resolutionStrategyFactory = null;
        }
        return this.resolutionStrategy;
    }

    @Override
    public ComponentResolveMetadata toRootComponentMetaData() {
        return this.rootComponentMetadataBuilder.toRootComponentMetaData();
    }

    @Override
    public String getPath() {
        return this.path.getPath();
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public void setReturnAllVariants(boolean returnAllVariants) {
        if (!this.canBeMutated) {
            throw new IllegalStateException("Configuration is unmodifiable");
        }
        this.returnAllVariants = returnAllVariants;
    }

    @Override
    public boolean getReturnAllVariants() {
        return this.returnAllVariants;
    }

    @Override
    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure(closure, this.getResolutionStrategy());
        return this;
    }

    @Override
    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute(this.getResolutionStrategy());
        return this;
    }

    @Override
    public void addMutationValidator(MutationValidator validator) {
        this.childMutationValidators.add(validator);
    }

    @Override
    public void removeMutationValidator(MutationValidator validator) {
        this.childMutationValidators.remove(validator);
    }

    private void validateParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.preventIllegalParentMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        this.preventIllegalMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    private void preventIllegalParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        ConfigurationInternal.InternalState resolvedState = this.currentResolveState.get().state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after it has been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if (resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED && type == MutationValidator.MutationType.DEPENDENCIES) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
    }

    private void preventIllegalMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        ConfigurationInternal.InternalState resolvedState = this.currentResolveState.get().state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been resolved.", new Object[]{type, this.getDisplayName()}));
        }
        if (resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if ((this.observedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || this.observedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) && type != MutationValidator.MutationType.STRATEGY) {
            String extraMessage = this.insideBeforeResolve ? " Use 'defaultDependencies' instead of 'beforeResolve' to specify default dependencies for a configuration." : "";
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been included in dependency resolution.%s", new Object[]{type, this.getDisplayName(), extraMessage}));
        }
    }

    private void markAsModified(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.dependenciesModified = true;
    }

    private void notifyChildren(MutationValidator.MutationType type) {
        for (MutationValidator validator : this.childMutationValidators) {
            validator.validateMutation(type);
        }
    }

    private void rethrowFailure(String type, Collection<Throwable> failures) {
        if (failures.isEmpty()) {
            return;
        }
        if (failures.size() == 1) {
            this.failuresWithHint(failures).ifPresent(UncheckedException::throwAsUncheckedException);
            Throwable failure = failures.iterator().next();
            if (failure instanceof ResolveException) {
                throw UncheckedException.throwAsUncheckedException(failure);
            }
        }
        throw new DefaultLenientConfiguration.ArtifactResolveException(type, this.getIdentityPath().toString(), this.getDisplayName(), failures);
    }

    private void assertIsResolvable() {
        if (!this.canBeResolved) {
            throw new IllegalStateException("Resolving dependency configuration '" + this.name + "' is not allowed as it is defined as 'canBeResolved=false'.\nInstead, a resolvable ('canBeResolved=true') dependency configuration that extends '" + this.name + "' should be resolved.");
        }
    }

    @Override
    protected void assertCanCarryBuildDependencies() {
        this.assertIsResolvable();
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.configurationAttributes;
    }

    @Override
    public Configuration attributes(Action<? super AttributeContainer> action) {
        action.execute(this.configurationAttributes);
        return this;
    }

    @Override
    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    @Override
    public void setCanBeConsumed(boolean allowed) {
        this.validateMutation(MutationValidator.MutationType.ROLE);
        this.canBeConsumed = allowed;
    }

    @Override
    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    @Override
    public void setCanBeResolved(boolean allowed) {
        this.validateMutation(MutationValidator.MutationType.ROLE);
        this.canBeResolved = allowed;
    }

    @VisibleForTesting
    ListenerBroadcast<DependencyResolutionListener> getDependencyResolutionListeners() {
        return this.dependencyResolutionListeners;
    }

    @Override
    @Nullable
    public List<String> getDeclarationAlternatives() {
        return this.declarationAlternatives;
    }

    @Override
    @Nullable
    public DeprecationMessageBuilder.WithDocumentation getConsumptionDeprecation() {
        return this.consumptionDeprecation;
    }

    @Override
    @Nullable
    public List<String> getResolutionAlternatives() {
        return this.resolutionAlternatives;
    }

    @Override
    public boolean isFullyDeprecated() {
        return !(this.declarationAlternatives == null || this.canBeConsumed && this.consumptionDeprecation == null || this.canBeResolved && this.resolutionAlternatives == null);
    }

    @Override
    public DeprecatableConfiguration deprecateForDeclaration(String ... alternativesForDeclaring) {
        this.declarationAlternatives = ImmutableList.copyOf((Object[])alternativesForDeclaring);
        return this;
    }

    @Override
    public DeprecatableConfiguration deprecateForConsumption(Function<DeprecationMessageBuilder.DeprecateConfiguration, DeprecationMessageBuilder.WithDocumentation> deprecation) {
        this.consumptionDeprecation = deprecation.apply(DeprecationLogger.deprecateConfiguration(this.name).forConsumption());
        return this;
    }

    @Override
    public DeprecatableConfiguration deprecateForResolution(String ... alternativesForResolving) {
        this.resolutionAlternatives = ImmutableList.copyOf((Object[])alternativesForResolving);
        return this;
    }

    @Override
    public Configuration shouldResolveConsistentlyWith(Configuration versionsSource) {
        this.consistentResolutionSource = (ConfigurationInternal)versionsSource;
        this.consistentResolutionReason = "version resolved in " + versionsSource + " by consistent resolution";
        return this;
    }

    @Override
    public Configuration disableConsistentResolution() {
        this.consistentResolutionSource = null;
        this.consistentResolutionReason = null;
        return this;
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("\nConfiguration:");
        reply.append("  class='").append(this.getClass()).append("'");
        reply.append("  name='").append(this.getName()).append("'");
        reply.append("  hashcode='").append(this.hashCode()).append("'");
        reply.append("\nLocal Dependencies:");
        if (this.getDependencies().size() > 0) {
            for (Dependency d : this.getDependencies()) {
                reply.append("\n   ").append(d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nLocal Artifacts:");
        if (this.getArtifacts().size() > 0) {
            for (PublishArtifact a : this.getArtifacts()) {
                reply.append("\n   ").append(a);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Dependencies:");
        if (this.getAllDependencies().size() > 0) {
            for (Dependency d : this.getAllDependencies()) {
                reply.append("\n   ").append(d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Artifacts:");
        if (this.getAllArtifacts().size() > 0) {
            for (PublishArtifact a : this.getAllArtifacts()) {
                reply.append("\n   ").append(a);
            }
        } else {
            reply.append("\n   none");
        }
        return reply.toString();
    }

    private ConfigurationArtifactCollection artifactCollection(AttributeContainerInternal attributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants) {
        ImmutableAttributes viewAttributes = attributes.asImmutable();
        DefaultResolutionHost failureHandler = new DefaultResolutionHost();
        ConfigurationFileCollection files = new ConfigurationFileCollection(new SelectedArtifactsProvider(), Specs.satisfyAll(), viewAttributes, componentFilter, lenient, allowNoMatchingVariants, failureHandler);
        return new ConfigurationArtifactCollection(files, lenient, failureHandler, this.calculatedValueContainerFactory);
    }

    private class DefaultResolutionHost
    implements ResolutionHost {
        private DefaultResolutionHost() {
        }

        @Override
        public DisplayName displayName(String type) {
            return Describables.of(DefaultConfiguration.this, type);
        }

        @Override
        public void rethrowFailure(String type, Collection<Throwable> failures) {
            DefaultConfiguration.this.rethrowFailure(type, failures);
        }
    }

    private class AllArtifactsProvider
    implements PublishArtifactSetProvider {
        private AllArtifactsProvider() {
        }

        @Override
        public PublishArtifactSet getPublishArtifactSet() {
            return DefaultConfiguration.this.getAllArtifacts();
        }
    }

    private static class ArtifactCollectionResolvedArtifactsFactory
    implements Factory<Set<ResolvedArtifactResult>> {
        private final ArtifactCollection artifactCollection;

        private ArtifactCollectionResolvedArtifactsFactory(ArtifactCollection artifactCollection) {
            this.artifactCollection = artifactCollection;
        }

        @Override
        public Set<ResolvedArtifactResult> create() {
            return this.artifactCollection.getArtifacts();
        }
    }

    private static class ConfigurationArtifactCollection
    implements ArtifactCollectionInternal {
        private final ConfigurationFileCollection fileCollection;
        private final boolean lenient;
        private final CalculatedValueContainer<ArtifactSetResult, ?> result;

        ConfigurationArtifactCollection(ConfigurationFileCollection files, boolean lenient, ResolutionHost resolutionHost, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.fileCollection = files;
            this.lenient = lenient;
            this.result = calculatedValueContainerFactory.create(resolutionHost.displayName("files"), () -> {
                ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor();
                this.fileCollection.getSelectedArtifacts().visitArtifacts(visitor, lenient);
                Set<ResolvedArtifactResult> artifactResults = visitor.getArtifacts();
                Set<Throwable> failures = visitor.getFailures();
                if (!lenient) {
                    resolutionHost.rethrowFailure("artifacts", failures);
                }
                return new ArtifactSetResult(artifactResults, failures);
            });
        }

        @Override
        public FileCollection getArtifactFiles() {
            return this.fileCollection;
        }

        @Override
        public Set<ResolvedArtifactResult> getArtifacts() {
            this.ensureResolved();
            return this.result.get().artifactResults;
        }

        @Override
        public Provider<Set<ResolvedArtifactResult>> getResolvedArtifacts() {
            return new BuildableBackedSetProvider<FileCollection, ResolvedArtifactResult>(this.getArtifactFiles(), new ArtifactCollectionResolvedArtifactsFactory(this));
        }

        @Override
        public Iterator<ResolvedArtifactResult> iterator() {
            this.ensureResolved();
            return this.result.get().artifactResults.iterator();
        }

        @Override
        public Collection<Throwable> getFailures() {
            this.ensureResolved();
            return this.result.get().failures;
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor) {
            this.fileCollection.getSelectedArtifacts().visitArtifacts(visitor, this.lenient);
        }

        private void ensureResolved() {
            this.result.finalizeIfNotAlready();
        }
    }

    private static class ArtifactSetResult {
        private final Set<ResolvedArtifactResult> artifactResults;
        private final Set<Throwable> failures;

        ArtifactSetResult(Set<ResolvedArtifactResult> artifactResults, Set<Throwable> failures) {
            this.artifactResults = artifactResults;
            this.failures = failures;
        }
    }

    public static class ArtifactViewConfiguration
    implements ArtifactView.ViewConfiguration {
        private final ImmutableAttributesFactory attributesFactory;
        private final AttributeContainerInternal configurationAttributes;
        private AttributeContainerInternal viewAttributes;
        private Spec<? super ComponentIdentifier> componentFilter;
        private boolean lenient;
        private boolean reselectVariant;
        private boolean attributesUsed;

        public ArtifactViewConfiguration(ImmutableAttributesFactory attributesFactory, AttributeContainerInternal configurationAttributes) {
            this.attributesFactory = attributesFactory;
            this.configurationAttributes = configurationAttributes;
        }

        @Override
        public AttributeContainer getAttributes() {
            if (this.viewAttributes == null) {
                this.viewAttributes = this.reselectVariant ? this.attributesFactory.mutable() : this.attributesFactory.mutable(this.configurationAttributes);
                this.attributesUsed = true;
            }
            return this.viewAttributes;
        }

        @Override
        public ArtifactViewConfiguration attributes(Action<? super AttributeContainer> action) {
            action.execute(this.getAttributes());
            return this;
        }

        @Override
        public ArtifactViewConfiguration componentFilter(Spec<? super ComponentIdentifier> componentFilter) {
            this.assertComponentFilterUnset();
            this.componentFilter = componentFilter;
            return this;
        }

        @Override
        public boolean isLenient() {
            return this.lenient;
        }

        @Override
        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        @Override
        public ArtifactViewConfiguration lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        @Override
        public ArtifactViewConfiguration withVariantReselection() {
            this.reselectVariant = true;
            return this;
        }

        private void assertComponentFilterUnset() {
            if (this.componentFilter != null) {
                throw new IllegalStateException("The component filter can only be set once before the view was computed");
            }
        }

        private Spec<? super ComponentIdentifier> lockComponentFilter() {
            if (this.componentFilter == null) {
                this.componentFilter = Specs.satisfyAll();
            }
            return this.componentFilter;
        }

        private ImmutableAttributes lockViewAttributes() {
            this.viewAttributes = this.viewAttributes == null ? this.configurationAttributes.asImmutable() : this.viewAttributes.asImmutable();
            return this.viewAttributes.asImmutable();
        }
    }

    public class ConfigurationResolvableDependencies
    implements ResolvableDependenciesInternal {
        @Override
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        @Override
        public String getPath() {
            return DefaultConfiguration.this.path.getPath();
        }

        public String toString() {
            return "dependencies '" + DefaultConfiguration.this.getIdentityPath() + "'";
        }

        @Override
        public FileCollection getFiles() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.intrinsicFiles;
        }

        @Override
        public DependencySet getDependencies() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencies();
        }

        @Override
        public DependencyConstraintSet getDependencyConstraints() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencyConstraints();
        }

        @Override
        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("beforeResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        @Override
        public void beforeResolve(Closure action) {
            this.beforeResolve(ConfigureUtil.configureUsing(action));
        }

        @Override
        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("afterResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        @Override
        public void afterResolve(Closure action) {
            this.afterResolve(ConfigureUtil.configureUsing(action));
        }

        @Override
        public ResolutionResult getResolutionResult() {
            DefaultConfiguration.this.assertIsResolvable();
            return new LenientResolutionResult(DEFAULT_ERROR_HANDLER);
        }

        @Override
        public ArtifactCollection getArtifacts() {
            return DefaultConfiguration.this.artifactCollection(DefaultConfiguration.this.configurationAttributes, Specs.satisfyAll(), false, false);
        }

        @Override
        public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> configAction) {
            ArtifactViewConfiguration config = this.createArtifactViewConfiguration();
            configAction.execute(config);
            return this.createArtifactView(config);
        }

        private ArtifactView createArtifactView(ArtifactViewConfiguration config) {
            ImmutableAttributes viewAttributes = config.lockViewAttributes();
            boolean allowNoMatchingVariants = config.attributesUsed;
            ConfigurationArtifactView view = new ConfigurationArtifactView(viewAttributes, config.lockComponentFilter(), config.lenient, allowNoMatchingVariants);
            return view;
        }

        private ArtifactViewConfiguration createArtifactViewConfiguration() {
            return DefaultConfiguration.this.instantiator.newInstance(ArtifactViewConfiguration.class, DefaultConfiguration.this.attributesFactory, DefaultConfiguration.this.configurationAttributes);
        }

        @Override
        public AttributeContainer getAttributes() {
            return DefaultConfiguration.this.configurationAttributes;
        }

        @Override
        public ResolutionResult getResolutionResult(Action<? super Throwable> errorHandler) {
            return new LenientResolutionResult(errorHandler);
        }

        private class LenientResolutionResult
        implements ResolutionResult {
            private final Action<? super Throwable> errorHandler;
            private volatile ResolutionResult delegate;

            private LenientResolutionResult(Action<? super Throwable> errorHandler) {
                this.errorHandler = errorHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void resolve() {
                if (this.delegate == null) {
                    LenientResolutionResult lenientResolutionResult = this;
                    synchronized (lenientResolutionResult) {
                        if (this.delegate == null) {
                            ResolveState currentState = DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
                            this.delegate = currentState.getCachedResolverResults().getResolutionResult();
                            ResolveException failure = currentState.getCachedResolverResults().consumeNonFatalFailure();
                            if (failure != null) {
                                this.errorHandler.execute(failure);
                            }
                        }
                    }
                }
            }

            @Override
            public ResolvedComponentResult getRoot() {
                this.resolve();
                return this.delegate.getRoot();
            }

            @Override
            public Provider<ResolvedComponentResult> getRootComponent() {
                return new DefaultProvider<ResolvedComponentResult>(this::getRoot);
            }

            @Override
            public Set<? extends DependencyResult> getAllDependencies() {
                this.resolve();
                return this.delegate.getAllDependencies();
            }

            @Override
            public void allDependencies(Action<? super DependencyResult> action) {
                this.resolve();
                this.delegate.allDependencies(action);
            }

            @Override
            public void allDependencies(Closure closure) {
                this.resolve();
                this.delegate.allDependencies(closure);
            }

            @Override
            public Set<ResolvedComponentResult> getAllComponents() {
                this.resolve();
                return this.delegate.getAllComponents();
            }

            @Override
            public void allComponents(Action<? super ResolvedComponentResult> action) {
                this.resolve();
                this.delegate.allComponents(action);
            }

            @Override
            public void allComponents(Closure closure) {
                this.resolve();
                this.delegate.allComponents(closure);
            }

            @Override
            public AttributeContainer getRequestedAttributes() {
                return this.delegate.getRequestedAttributes();
            }

            public int hashCode() {
                this.resolve();
                return this.delegate.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof LenientResolutionResult) {
                    this.resolve();
                    return this.delegate.equals(((LenientResolutionResult)obj).delegate);
                }
                return false;
            }

            public String toString() {
                return "lenient resolution result for " + this.delegate;
            }
        }

        private class ConfigurationArtifactView
        implements ArtifactView {
            private final ImmutableAttributes viewAttributes;
            private final Spec<? super ComponentIdentifier> componentFilter;
            private final boolean lenient;
            private final boolean allowNoMatchingVariants;

            ConfigurationArtifactView(ImmutableAttributes viewAttributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants) {
                this.viewAttributes = viewAttributes;
                this.componentFilter = componentFilter;
                this.lenient = lenient;
                this.allowNoMatchingVariants = allowNoMatchingVariants;
            }

            @Override
            public AttributeContainer getAttributes() {
                return this.viewAttributes;
            }

            @Override
            public ArtifactCollection getArtifacts() {
                return DefaultConfiguration.this.artifactCollection(this.viewAttributes, this.componentFilter, this.lenient, this.allowNoMatchingVariants);
            }

            @Override
            public FileCollection getFiles() {
                return new ConfigurationFileCollection(new SelectedArtifactsProvider(), Specs.satisfyAll(), this.viewAttributes, this.componentFilter, this.lenient, this.allowNoMatchingVariants, new DefaultResolutionHost());
            }
        }
    }

    private static class ArtifactsResolved
    extends WithResults {
        public ArtifactsResolved(ResolverResults results) {
            super(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED, results);
        }
    }

    private static class GraphResolved
    extends WithResults {
        public GraphResolved(ResolverResults cachedResolverResults) {
            super(ConfigurationInternal.InternalState.GRAPH_RESOLVED, cachedResolverResults);
        }
    }

    private static class BuildDependenciesResolved
    extends WithResults {
        public BuildDependenciesResolved(ResolverResults results) {
            super(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED, results);
        }
    }

    private static class WithResults
    extends ResolveState {
        final ResolverResults cachedResolverResults;

        WithResults(ConfigurationInternal.InternalState state2, ResolverResults cachedResolverResults) {
            super(state2);
            this.cachedResolverResults = cachedResolverResults;
        }

        @Override
        boolean hasError() {
            return this.cachedResolverResults.hasError();
        }

        @Override
        public ResolverResults getCachedResolverResults() {
            return this.cachedResolverResults;
        }

        @Override
        public ResolvedConfiguration getResolvedConfiguration() {
            return this.cachedResolverResults.getResolvedConfiguration();
        }
    }

    private static abstract class ResolveState {
        static final ResolveState NOT_RESOLVED = new ResolveState(ConfigurationInternal.InternalState.UNRESOLVED){

            @Override
            public ResolvedConfiguration getResolvedConfiguration() {
                throw new IllegalStateException();
            }

            @Override
            public ResolverResults getCachedResolverResults() {
                throw new IllegalStateException();
            }

            @Override
            public boolean hasError() {
                return false;
            }
        };
        final ConfigurationInternal.InternalState state;

        ResolveState(ConfigurationInternal.InternalState state2) {
            this.state = state2;
        }

        abstract boolean hasError();

        public abstract ResolvedConfiguration getResolvedConfiguration();

        public abstract ResolverResults getCachedResolverResults();
    }

    private static class ConfigurationFileCollection
    extends AbstractFileCollection {
        private final Spec<? super Dependency> dependencySpec;
        private final AttributeContainerInternal viewAttributes;
        private final Spec<? super ComponentIdentifier> componentSpec;
        private final boolean lenient;
        private final boolean allowNoMatchingVariants;
        private final ResolutionResultProvider<VisitedArtifactSet> resultProvider;
        private final ResolutionHost resolutionHost;
        private SelectedArtifactSet selectedArtifacts;

        private ConfigurationFileCollection(ResolutionResultProvider<VisitedArtifactSet> resultProvider, Spec<? super Dependency> dependencySpec, AttributeContainerInternal viewAttributes, Spec<? super ComponentIdentifier> componentSpec, boolean lenient, boolean allowNoMatchingVariants, ResolutionHost resolutionHost) {
            this.resultProvider = resultProvider;
            this.dependencySpec = dependencySpec;
            this.viewAttributes = viewAttributes;
            this.componentSpec = componentSpec;
            this.lenient = lenient;
            this.allowNoMatchingVariants = allowNoMatchingVariants;
            this.resolutionHost = resolutionHost;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            SelectedArtifactSet selected = this.resultProvider.getTaskDependencyValue().select(this.dependencySpec, this.viewAttributes, this.componentSpec, this.allowNoMatchingVariants);
            FailureCollectingTaskDependencyResolveContext collectingContext = new FailureCollectingTaskDependencyResolveContext(context);
            selected.visitDependencies(collectingContext);
            if (!this.lenient) {
                this.resolutionHost.rethrowFailure("task dependencies", collectingContext.getFailures());
            }
        }

        @Override
        public String getDisplayName() {
            return this.resolutionHost.displayName("files").getDisplayName();
        }

        @Override
        protected void visitContents(FileCollectionStructureVisitor visitor) {
            ResolvedFileCollectionVisitor collectingVisitor = new ResolvedFileCollectionVisitor(visitor);
            this.getSelectedArtifacts().visitArtifacts(collectingVisitor, this.lenient);
            if (!this.lenient) {
                this.resolutionHost.rethrowFailure("files", collectingVisitor.getFailures());
            }
        }

        @Override
        protected void appendContents(TreeFormatter formatter) {
            formatter.node("contains: " + this.getDisplayName());
        }

        private SelectedArtifactSet getSelectedArtifacts() {
            if (this.selectedArtifacts == null) {
                this.selectedArtifacts = this.resultProvider.getValue().select(this.dependencySpec, this.viewAttributes, this.componentSpec, this.allowNoMatchingVariants);
            }
            return this.selectedArtifacts;
        }
    }

    private class SelectedArtifactsProvider
    implements ResolutionResultProvider<VisitedArtifactSet> {
        private SelectedArtifactsProvider() {
        }

        @Override
        public VisitedArtifactSet getTaskDependencyValue() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.resolveGraphForBuildDependenciesIfRequired().getVisitedArtifacts();
        }

        @Override
        public VisitedArtifactSet getValue() {
            DefaultConfiguration.this.assertIsResolvable();
            ResolveState currentState = DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
            return currentState.getCachedResolverResults().getVisitedArtifacts();
        }
    }

    private class DefaultResolutionResultProvider
    implements ResolutionResultProvider<ResolutionResult> {
        private DefaultResolutionResultProvider() {
        }

        @Override
        public ResolutionResult getTaskDependencyValue() {
            return DefaultConfiguration.this.getResultsForBuildDependencies().getResolutionResult();
        }

        @Override
        public ResolutionResult getValue() {
            return DefaultConfiguration.this.getResultsForArtifacts().getResolutionResult();
        }
    }

    private static class ConfigurationDescription
    implements Describable {
        private final Path identityPath;

        ConfigurationDescription(Path identityPath) {
            this.identityPath = identityPath;
        }

        @Override
        public String getDisplayName() {
            return "configuration '" + this.identityPath + "'";
        }
    }
}

