/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.google.gson.JsonElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.tasks.youtrack.model.YouTrackIssue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YouTrackTask
extends Task {
    private final YouTrackRepository myRepository;
    private final YouTrackIssue myIssue;
    private final TaskType myType;
    private final TaskState myIssueState;

    public YouTrackTask(@NotNull YouTrackRepository repository, @NotNull YouTrackIssue issue) {
        this.myRepository = repository;
        this.myIssue = issue;
        this.myIssueState = this.mapIssueStateToPredefinedValue();
        this.myType = this.mapIssueTypeToPredefinedValue();
    }

    @NotNull
    public TaskType getType() {
        return this.myType;
    }

    @NotNull
    private TaskType mapIssueTypeToPredefinedValue() {
        String typeName = this.getCustomFieldStringValue("Type");
        if (typeName != null) {
            try {
                return TaskType.valueOf((String)StringUtil.toUpperCase((String)typeName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return TaskType.OTHER;
    }

    @Nullable
    public TaskState getState() {
        return this.myIssueState;
    }

    @Nullable
    private TaskState mapIssueStateToPredefinedValue() {
        String stateName = this.getCustomFieldStringValue("State");
        if (stateName == null) {
            return null;
        }
        if (stateName.equals("Fixed")) {
            return TaskState.RESOLVED;
        }
        try {
            return TaskState.valueOf((String)StringUtil.toUpperCase((String)stateName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return TaskState.OTHER;
        }
    }

    @Nullable
    private String getCustomFieldStringValue(@NotNull String fieldName) {
        JsonElement stateNameElem;
        JsonElement fieldValueElem;
        YouTrackIssue.CustomField stateField = (YouTrackIssue.CustomField)ContainerUtil.find(this.myIssue.getCustomFields(), cf -> cf.getName().equals(fieldName));
        if (stateField != null && (fieldValueElem = stateField.getValue()) != null && fieldValueElem.isJsonObject() && (stateNameElem = fieldValueElem.getAsJsonObject().get("name")) != null && stateNameElem.isJsonPrimitive() && stateNameElem.getAsJsonPrimitive().isString()) {
            return stateNameElem.getAsString();
        }
        return null;
    }

    @NotNull
    public String getId() {
        return this.myIssue.getId();
    }

    @NotNull
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    @Nls
    @NotNull
    public String getSummary() {
        return this.myIssue.getSummary();
    }

    @Nls
    @NotNull
    public String getDescription() {
        return this.myIssue.getDescription();
    }

    public Comment @NotNull [] getComments() {
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        return LocalTaskImpl.getIconFromType((TaskType)this.getType(), (boolean)true);
    }

    @NotNull
    public Date getUpdated() {
        return new Date(this.myIssue.getUpdated());
    }

    @NotNull
    public Date getCreated() {
        return new Date(this.myIssue.getCreated());
    }

    public boolean isClosed() {
        return this.myIssue.getResolved() != 0L;
    }

    public boolean isIssue() {
        return true;
    }

    @NotNull
    public String getIssueUrl() {
        return this.myRepository.getUrl() + "/issue/" + this.getId();
    }
}

