/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.youtrack.YouTrackPluginAdvertiserService;
import com.intellij.tasks.youtrack.YouTrackTask;
import com.intellij.tasks.youtrack.model.YouTrackCommandList;
import com.intellij.tasks.youtrack.model.YouTrackErrorInfo;
import com.intellij.tasks.youtrack.model.YouTrackIssue;
import com.intellij.tasks.youtrack.model.YouTrackSingleIssueCommand;
import com.intellij.tasks.youtrack.model.YouTrackWorkItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="YouTrack")
public class YouTrackRepository
extends NewBaseRepositoryImpl {
    private static final TypeToken<List<YouTrackIssue>> LIST_OF_ISSUES_TYPE = new TypeToken<List<YouTrackIssue>>(){};
    private static final Gson GSON = TaskGsonUtil.createDefaultBuilder().create();
    private static final Logger LOG = Logger.getInstance(YouTrackRepository.class);
    private String myDefaultSearch = "Assignee: me sort by: updated #Unresolved";

    public YouTrackRepository() {
    }

    public YouTrackRepository(TaskRepositoryType type) {
        super(type);
    }

    @Override
    @NotNull
    public BaseRepository clone() {
        return new YouTrackRepository(this);
    }

    private YouTrackRepository(YouTrackRepository other) {
        super(other);
        this.myDefaultSearch = other.getDefaultSearch();
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List<YouTrackIssue> result = this.fetchIssues(query, offset, limit);
        return (Task[])ContainerUtil.map2Array(result, YouTrackTask.class, issue -> new YouTrackTask(this, (YouTrackIssue)issue));
    }

    @NotNull
    private List<YouTrackIssue> fetchIssues(@Nullable String query, int offset, int limit) throws URISyntaxException, IOException {
        String searchQuery = this.getDefaultSearch() + (String)(StringUtil.isNotEmpty((String)query) ? " " + query : "");
        URI endpoint = new URIBuilder(this.getRestApiUrl("api", "issues")).addParameter("query", searchQuery).addParameter("fields", "idReadable,updated,created,resolved,summary,description,customFields(name,value(name))").addParameter("$skip", String.valueOf(offset)).addParameter("$top", String.valueOf(limit)).build();
        try {
            return (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(endpoint), TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toMultipleObjects(LIST_OF_ISSUES_TYPE));
        }
        catch (YouTrackRequestFailedException e) {
            if ("invalid_query".equals(e.getErrorInfo().getError())) {
                LOG.debug("Ignoring invalid query: " + searchQuery);
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void test() throws Exception {
                URI endpoint = new URIBuilder(YouTrackRepository.this.getRestApiUrl("api", "issues")).addParameter("query", YouTrackRepository.this.myDefaultSearch).addParameter("fields", "idReadable,updated,created,resolved,summary,description,customFields(name,value(name))").addParameter("$top", String.valueOf(10)).build();
                this.myCurrentRequest.setURI(endpoint);
                YouTrackRepository.this.getHttpClient().execute((HttpUriRequest)this.myCurrentRequest, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(YouTrackRepository.this::parseYouTrackError).toNothing());
            }
        };
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        YouTrackIssue issue = this.fetchIssue(id);
        return issue != null ? new YouTrackTask(this, issue) : null;
    }

    @Nullable
    private YouTrackIssue fetchIssue(@NotNull String issueId) throws URISyntaxException, IOException {
        URI endpoint = new URIBuilder(this.getRestApiUrl("api", "issues", issueId)).addParameter("fields", "idReadable,updated,created,resolved,summary,description,customFields(name,value(name))").build();
        return (YouTrackIssue)this.getHttpClient().execute((HttpUriRequest)new HttpGet(endpoint), TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).ignoredCode(code -> code == 404).toSingleObject(YouTrackIssue.class));
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        HttpPost request = new HttpPost(this.getRestApiUrl("api", "commands"));
        request.setEntity((HttpEntity)new StringEntity(GSON.toJson((Object)new YouTrackSingleIssueCommand(task.getId(), "state " + state.getId())), ContentType.APPLICATION_JSON));
        this.getHttpClient().execute((HttpUriRequest)request, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toNothing());
    }

    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        return ContainerUtil.map2Set(this.fetchAvailableStates(task.getId()), suggestion -> new CustomTaskState(suggestion, suggestion));
    }

    @NotNull
    private List<String> fetchAvailableStates(@NotNull String issueId) throws URISyntaxException, IOException {
        URI endpoint = new URIBuilder(this.getRestApiUrl("api", "commands", "assist")).addParameter("fields", "suggestions(option)").build();
        String setStateCommandPrefix = "state ";
        HttpPost request = new HttpPost(endpoint);
        request.setEntity((HttpEntity)new StringEntity(GSON.toJson((Object)new YouTrackSingleIssueCommand(issueId, setStateCommandPrefix)), ContentType.APPLICATION_JSON));
        YouTrackCommandList commandList = (YouTrackCommandList)this.getHttpClient().execute((HttpUriRequest)request, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toSingleObject(YouTrackCommandList.class));
        if (commandList == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull(commandList.getSuggestions(), suggestion -> {
            String option = suggestion.getOption();
            return option.startsWith(setStateCommandPrefix) ? null : option;
        });
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        YouTrackPluginAdvertiserService.getInstance().showTimeTrackingNotification();
        Matcher matcher = TIME_SPENT_PATTERN.matcher(timeSpent);
        if (matcher.find()) {
            int hours = Integer.parseInt(matcher.group(1));
            int minutes = Integer.parseInt(matcher.group(2));
            int totalMinutes = hours * 60 + minutes;
            HttpPost request = new HttpPost(this.getRestApiUrl("api", "issues", task.getId(), "timeTracking", "workItems"));
            request.setEntity((HttpEntity)new StringEntity(GSON.toJson((Object)new YouTrackWorkItem(comment, totalMinutes)), ContentType.APPLICATION_JSON));
            this.getHttpClient().execute((HttpUriRequest)request, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toNothing());
        } else {
            LOG.warn("Unrecognized time pattern: " + timeSpent);
        }
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return (request, context) -> request.addHeader((Header)new BasicHeader("Accept", ContentType.APPLICATION_JSON.toString()));
    }

    public String getDefaultSearch() {
        return this.myDefaultSearch;
    }

    public void setDefaultSearch(String defaultSearch) {
        if (defaultSearch != null) {
            this.myDefaultSearch = defaultSearch;
        }
    }

    @Override
    @NotNull
    protected HttpClient getHttpClient() {
        return super.getHttpClient();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        YouTrackRepository repository = (YouTrackRepository)((Object)o);
        return Objects.equals(repository.getDefaultSearch(), this.getDefaultSearch());
    }

    protected int getFeatures() {
        return super.getFeatures() | 8 | 4;
    }

    @Override
    @NotNull
    protected String getDefaultScheme() {
        return "https";
    }

    @Override
    public boolean isUseHttpAuthentication() {
        return true;
    }

    @NotNull
    private RequestFailedException parseYouTrackError(@NotNull HttpResponse response) {
        try {
            return new YouTrackRequestFailedException(this, (YouTrackErrorInfo)GSON.fromJson(TaskResponseUtil.getResponseContentAsReader(response), YouTrackErrorInfo.class));
        }
        catch (IOException e) {
            return new RequestFailedException((Throwable)e);
        }
    }

    private static class YouTrackRequestFailedException
    extends RequestFailedException {
        private final YouTrackErrorInfo myErrorInfo;

        private YouTrackRequestFailedException(@NotNull YouTrackRepository repository, @NotNull YouTrackErrorInfo errorInfo) {
            super((TaskRepository)repository, YouTrackRequestFailedException.mostDescriptiveMessage(errorInfo));
            this.myErrorInfo = errorInfo;
        }

        @NotNull
        private YouTrackErrorInfo getErrorInfo() {
            return this.myErrorInfo;
        }

        @NotNull
        @NlsSafe
        private static String mostDescriptiveMessage(@NotNull YouTrackErrorInfo errorInfo) {
            return StringUtil.isNotEmpty((String)errorInfo.getErrorDescription()) ? errorInfo.getErrorDescription() : (StringUtil.isNotEmpty((String)errorInfo.getError()) ? errorInfo.getError() : "Unknown error");
        }
    }
}

