/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;

public class YouTrackIntellisense {
    public static final Key<YouTrackIntellisense> INTELLISENSE_KEY = Key.create((String)"youtrack.intellisense");
    private static final Logger LOG = Logger.getInstance(YouTrackIntellisense.class);
    private static final Map<String, TextAttributes> TEXT_ATTRIBUTES = Map.of("field-value", DefaultLanguageHighlighterColors.CONSTANT.getDefaultAttributes(), "field-name", DefaultLanguageHighlighterColors.KEYWORD.getDefaultAttributes(), "text", DefaultLanguageHighlighterColors.STRING.getDefaultAttributes(), "error", HighlighterColors.BAD_CHARACTER.getDefaultAttributes());
    private static final int CACHE_SIZE = 30;
    private static final Map<Pair<String, Integer>, Response> ourCache = Collections.synchronizedMap(new SizeLimitedCache(30));
    private final YouTrackRepository myRepository;

    @NotNull
    private static TextAttributes getAttributeByStyleClass(@NotNull String styleClass) {
        TextAttributes attr = TEXT_ATTRIBUTES.get(styleClass);
        return attr == null ? HighlighterColors.TEXT.getDefaultAttributes() : attr;
    }

    @NotNull
    public List<HighlightRange> fetchHighlighting(@NotNull String query, int caret) throws Exception {
        LOG.debug("Requesting highlighting");
        return this.fetch(query, caret, true).getHighlightRanges();
    }

    @NotNull
    public List<CompletionItem> fetchCompletion(@NotNull String query, int caret) throws Exception {
        LOG.debug("Requesting completion");
        return this.fetch(query, caret, false).getCompletionItems();
    }

    public YouTrackIntellisense(@NotNull YouTrackRepository repository) {
        this.myRepository = repository;
    }

    @NotNull
    private Response fetch(@NotNull String query, int caret, boolean ignoreCaret) throws Exception {
        LOG.debug("Query: '" + query + "' caret at: " + caret);
        Pair lookup = Pair.create((Object)query, (Object)caret);
        Response response = null;
        if (ignoreCaret) {
            for (Pair<String, Integer> pair : ourCache.keySet()) {
                if (!((String)pair.getFirst()).equals(query)) continue;
                response = ourCache.get(pair);
                break;
            }
        } else {
            response = ourCache.get(lookup);
        }
        LOG.debug("Cache " + (response != null ? "hit" : "miss"));
        if (response == null) {
            long startTime = System.currentTimeMillis();
            URI endpoint = new URIBuilder(this.myRepository.getRestApiUrl("api", "search", "assist")).addParameter("fields", "styleRanges(length,start,style),suggestions(completionEnd,completionStart,description,matchingEnd,matchingStart,option,prefix,suffix)").build();
            HttpPost request = new HttpPost(endpoint);
            Gson gson = TaskGsonUtil.createDefaultBuilder().create();
            Map<String, Integer> payload = Map.of("query", query, "caret", caret);
            request.setEntity((HttpEntity)new StringEntity(gson.toJson(payload), ContentType.APPLICATION_JSON));
            response = (Response)this.myRepository.getHttpClient().execute((HttpUriRequest)request, new TaskResponseUtil.GsonSingleObjectDeserializer<Response>(gson, Response.class));
            LOG.debug(String.format("Intellisense request to YouTrack took %d ms to complete", System.currentTimeMillis() - startTime));
            ourCache.put((Pair<String, Integer>)lookup, response);
        }
        return response;
    }

    public YouTrackRepository getRepository() {
        return this.myRepository;
    }

    public static class Response {
        private static final String DEFAULT_FIELDS = "styleRanges(length,start,style),suggestions(completionEnd,completionStart,description,matchingEnd,matchingStart,option,prefix,suffix)";
        private List<HighlightRange> styleRanges;
        private List<CompletionItem> suggestions;

        @NotNull
        public List<HighlightRange> getHighlightRanges() {
            return this.styleRanges;
        }

        @NotNull
        public List<CompletionItem> getCompletionItems() {
            return this.suggestions;
        }
    }

    private static final class SizeLimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int myMaxSize;

        private SizeLimitedCache(int max) {
            super((int)((double)max / 0.75) + 1, true);
            this.myMaxSize = max;
        }

        protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
            return this.size() > this.myMaxSize;
        }
    }

    public static class CompletionItem {
        private int completionStart;
        private int completionEnd;
        private int matchingStart;
        private int matchingEnd;
        private String prefix;
        private String suffix;
        private String description;
        private String option;

        @NotNull
        public TextRange getMatchRange() {
            return TextRange.create((int)this.matchingStart, (int)this.matchingEnd);
        }

        @NotNull
        public TextRange getCompletionRange() {
            return TextRange.create((int)this.completionStart, (int)this.completionEnd);
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public String getSuffix() {
            return StringUtil.notNullize((String)this.suffix);
        }

        @NotNull
        public String getPrefix() {
            return StringUtil.notNullize((String)this.prefix);
        }

        @NotNull
        public String getOption() {
            return this.option;
        }
    }

    public static class HighlightRange {
        private int start;
        private int length;
        private String style;

        @NotNull
        public String getStyleClass() {
            return StringUtil.notNullize((String)this.style);
        }

        @NotNull
        public TextRange getTextRange() {
            return TextRange.from((int)this.start, (int)this.length);
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            return YouTrackIntellisense.getAttributeByStyleClass(this.style);
        }
    }
}

