/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql.codeinsight;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.jira.jql.codeinsight.JqlStandardFunction;
import com.intellij.tasks.jira.jql.psi.JqlElementVisitor;
import com.intellij.tasks.jira.jql.psi.JqlEmptyValue;
import com.intellij.tasks.jira.jql.psi.JqlFunctionCall;
import com.intellij.tasks.jira.jql.psi.JqlIdentifier;
import com.intellij.tasks.jira.jql.psi.JqlList;
import com.intellij.tasks.jira.jql.psi.JqlOperand;
import com.intellij.tasks.jira.jql.psi.JqlSimpleClause;
import com.intellij.tasks.jira.jql.psi.JqlTerminalClause;
import org.jetbrains.annotations.NotNull;

public class JqlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        element.accept((PsiElementVisitor)new JqlElementVisitor(){

            @Override
            public void visitEmptyValue(JqlEmptyValue emptyValue) {
                JqlSimpleClause clause = (JqlSimpleClause)PsiTreeUtil.getParentOfType((PsiElement)emptyValue, JqlSimpleClause.class);
                if (clause != null && !JqlAnnotator.isEmptyClause(clause)) {
                    holder.newAnnotation(HighlightSeverity.ERROR, String.format(TaskBundle.message((String)"inspection.message.not.expecting.s.here", (Object[])new Object[0]), emptyValue.getText())).create();
                }
            }

            @Override
            public void visitJqlList(JqlList list) {
                JqlSimpleClause clause = (JqlSimpleClause)PsiTreeUtil.getParentOfType((PsiElement)list, JqlSimpleClause.class);
                if (clause != null && !JqlAnnotator.isListClause(clause)) {
                    holder.newAnnotation(HighlightSeverity.ERROR, TaskBundle.message((String)"inspection.message.not.expecting.list.values.here", (Object[])new Object[0])).create();
                }
            }

            @Override
            public void visitJqlSimpleClause(JqlSimpleClause clause) {
                boolean hasListOperand;
                JqlOperand operand = clause.getOperand();
                if (operand == null) {
                    return;
                }
                boolean operandIsListLiteral = operand instanceof JqlList;
                boolean operandIsListFunction = false;
                if (operand instanceof JqlFunctionCall) {
                    JqlFunctionCall functionCall = (JqlFunctionCall)operand;
                    JqlStandardFunction standardFunction = JqlStandardFunction.byName(functionCall.getFunctionName().getText());
                    operandIsListFunction = standardFunction != null && standardFunction.hasMultipleResults();
                }
                boolean bl = hasListOperand = operandIsListLiteral || operandIsListFunction;
                if (JqlAnnotator.isListClause(clause) && !hasListOperand) {
                    holder.newAnnotation(HighlightSeverity.ERROR, TaskBundle.message((String)"inspection.message.expecting.list.values.here", (Object[])new Object[0])).range((PsiElement)operand).create();
                }
                boolean hasEmptyOperand = operand instanceof JqlEmptyValue;
                if (JqlAnnotator.isEmptyClause(clause) && !hasEmptyOperand) {
                    holder.newAnnotation(HighlightSeverity.ERROR, TaskBundle.message((String)"inspection.message.expecting.empty.or.null.here", (Object[])new Object[0])).range((PsiElement)operand).create();
                }
            }

            @Override
            public void visitJqlIdentifier(JqlIdentifier identifier) {
                TextAttributes attributes = DefaultLanguageHighlighterColors.CONSTANT.getDefaultAttributes();
                if (attributes != null) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).enforcedTextAttributes(attributes).create();
                }
            }
        });
    }

    private static boolean isEmptyClause(JqlTerminalClause clause) {
        JqlTerminalClause.Type clauseType = clause.getType();
        return clauseType == JqlTerminalClause.Type.IS || clauseType == JqlTerminalClause.Type.IS_NOT;
    }

    private static boolean isListClause(JqlTerminalClause clause) {
        JqlTerminalClause.Type clauseType = clause.getType();
        return clauseType != null && clauseType.isListOperator();
    }
}

