/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tasks.jira.jql.JqlElementTypes;
import com.intellij.tasks.jira.jql.JqlFile;
import com.intellij.tasks.jira.jql.JqlLanguage;
import com.intellij.tasks.jira.jql.JqlLexer;
import com.intellij.tasks.jira.jql.JqlParser;
import com.intellij.tasks.jira.jql.JqlTokenTypes;
import org.jetbrains.annotations.NotNull;

public class JqlParserDefinition
implements ParserDefinition {
    private static final IFileElementType FILE_ELEMENT_TYPE = new IFileElementType((Language)JqlLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        return new JqlLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new JqlParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return JqlTokenTypes.WHITESPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.create((IElementType[])new IElementType[]{JqlTokenTypes.STRING_LITERAL});
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return JqlElementTypes.Factory.createElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        return new JqlFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

