/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.CachedIconLoader;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.ObjectUtils;
import icons.TasksCoreIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraTask
extends Task {
    protected final TaskRepository myRepository;
    private volatile Icon myIcon;

    protected JiraTask(@NotNull TaskRepository repository) {
        this.myRepository = repository;
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getSummary();

    public abstract String getDescription();

    public abstract Comment @NotNull [] getComments();

    @Nullable
    protected abstract String getIconUrl();

    @NotNull
    public abstract TaskType getType();

    public abstract TaskState getState();

    @Nullable
    public abstract Date getUpdated();

    public abstract Date getCreated();

    public final String getIssueUrl() {
        return this.myRepository.getUrl() + "/browse/" + this.getId();
    }

    @NotNull
    public final Icon getIcon() {
        if (this.myIcon == null) {
            String iconUrl = this.getIconUrl();
            this.myIcon = StringUtil.isEmpty((String)iconUrl) ? TasksCoreIcons.Jira : new DeferredIconImpl(TasksCoreIcons.Jira, (Object)iconUrl, false, JiraTask::getIconByUrl);
        }
        return this.myIcon;
    }

    @Nullable
    public final TaskRepository getRepository() {
        return this.myRepository;
    }

    public final boolean isClosed() {
        return this.getState() == TaskState.RESOLVED;
    }

    public final boolean isIssue() {
        return true;
    }

    @NotNull
    protected static Icon getIconByUrl(@Nullable String iconUrl) {
        return (Icon)ObjectUtils.notNull((Object)CachedIconLoader.getIcon(iconUrl), (Object)AllIcons.FileTypes.Any_type);
    }

    @Nullable
    protected final TaskState getStateById(int id) {
        return switch (id) {
            case 1 -> TaskState.OPEN;
            case 3 -> TaskState.IN_PROGRESS;
            case 4 -> TaskState.REOPENED;
            case 5, 6 -> TaskState.RESOLVED;
            default -> null;
        };
    }

    protected final TaskType getTypeByName(@Nullable String type) {
        if (type == null) {
            return TaskType.OTHER;
        }
        if ("Bug".equals(type)) {
            return TaskType.BUG;
        }
        if ("Exception".equals(type)) {
            return TaskType.EXCEPTION;
        }
        if ("New Feature".equals(type)) {
            return TaskType.FEATURE;
        }
        return TaskType.OTHER;
    }
}

