/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl.httpclient;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.Producer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TaskResponseUtil {
    public static final Logger LOG = Logger.getInstance(TaskResponseUtil.class);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private TaskResponseUtil() {
    }

    public static Reader getResponseContentAsReader(@NotNull HttpResponse response) throws IOException {
        org.apache.http.Header header = response.getEntity().getContentEncoding();
        Charset charset = header == null ? DEFAULT_CHARSET : Charset.forName(header.getValue());
        return new InputStreamReader(response.getEntity().getContent(), charset);
    }

    public static String getResponseContentAsString(@NotNull HttpResponse response) throws IOException {
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)DEFAULT_CHARSET);
    }

    public static String getResponseContentAsString(@NotNull HttpMethod response) throws IOException {
        Header header = response.getResponseHeader("Content-Type");
        if (header != null && header.getValue().contains("charset")) {
            return StringUtil.notNullize((String)response.getResponseBodyAsString());
        }
        InputStream stream = response.getResponseBodyAsStream();
        if (stream == null) {
            return "";
        }
        try (InputStreamReader reader = new InputStreamReader(stream, DEFAULT_CHARSET);){
            String string = StreamUtil.readText((Reader)reader);
            return string;
        }
    }

    public static Reader getResponseContentAsReader(@NotNull HttpMethod response) throws IOException {
        InputStream stream = response.getResponseBodyAsStream();
        String charsetName = null;
        Header header = response.getResponseHeader("Content-Type");
        if (header != null) {
            for (HeaderElement part : header.getElements()) {
                NameValuePair pair = part.getParameterByName("charset");
                if (pair == null) continue;
                charsetName = pair.getValue();
            }
        }
        return charsetName != null ? new InputStreamReader(stream, charsetName) : new InputStreamReader(stream, DEFAULT_CHARSET);
    }

    @NotNull
    public static String messageForStatusCode(int statusCode) {
        if (statusCode == 401) {
            return TaskBundle.message((String)"failure.login", (Object[])new Object[0]);
        }
        if (statusCode == 403) {
            return TaskBundle.message((String)"failure.permissions", (Object[])new Object[0]);
        }
        return TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{statusCode, HttpStatus.getStatusText(statusCode)});
    }

    public static void prettyFormatResponseToLog(@NotNull Logger logger, @NotNull HttpMethod response) {
        if (logger.isDebugEnabled() && response.hasBeenUsed()) {
            try {
                String contentType;
                String content = TaskResponseUtil.getResponseContentAsString(response);
                Header header = response.getRequestHeader("Content-Type");
                String string = contentType = header == null ? "text/plain" : StringUtil.toLowerCase((String)header.getElements()[0].getName());
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog((Logger)logger, (String)content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog((Logger)logger, (String)content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void prettyFormatResponseToLog(@NotNull Logger logger, @NotNull HttpResponse response) {
        if (logger.isDebugEnabled()) {
            try {
                String contentType;
                String content = TaskResponseUtil.getResponseContentAsString(response);
                org.apache.http.Header header = response.getEntity().getContentType();
                String string = contentType = header == null ? "text/plain" : StringUtil.toLowerCase((String)header.getElements()[0].getName());
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog((Logger)logger, (String)content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog((Logger)logger, (String)content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static boolean isSuccessful(int statusCode) {
        return statusCode / 100 == 2;
    }

    public static boolean isClientError(int statusCode) {
        return statusCode / 100 == 4;
    }

    public static boolean isServerError(int statusCode) {
        return statusCode / 100 == 5;
    }

    public static final class GsonMultipleObjectsDeserializer<T>
    extends GsonResponseHandler<List<T>> {
        public GsonMultipleObjectsDeserializer(Gson gson, TypeToken<List<T>> typeToken) {
            this(gson, typeToken, false);
        }

        public GsonMultipleObjectsDeserializer(@NotNull Gson gson, @NotNull TypeToken<List<T>> token, boolean ignoreNotFound) {
            super(JsonResponseHandlerBuilder.fromGson(gson).ignoredCode(code -> ignoreNotFound && code == 404), s -> (List)gson.fromJson(s, token.getType()), r -> (List)gson.fromJson(r, token.getType()), () -> Collections.emptyList());
        }
    }

    public static final class GsonSingleObjectDeserializer<T>
    extends GsonResponseHandler<T> {
        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls) {
            this(gson, cls, false);
        }

        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls, boolean ignoreNotFound) {
            super(JsonResponseHandlerBuilder.fromGson(gson).ignoredCode(code -> ignoreNotFound && code == 404), s -> gson.fromJson(s, cls), r -> gson.fromJson(r, cls), () -> null);
        }
    }

    private static class GsonResponseHandler<T>
    implements ResponseHandler<T> {
        private final JsonResponseHandlerBuilder myBuilder;
        private final Function<String, T> myFromString;
        private final Function<Reader, T> myFromReader;
        private final Producer<T> myFallbackValue;

        private GsonResponseHandler(@NotNull JsonResponseHandlerBuilder builder, @NotNull Function<String, T> fromString, @NotNull Function<Reader, T> fromReader, @NotNull Producer<T> fallbackValue) {
            this.myBuilder = builder;
            this.myFromString = fromString;
            this.myFromReader = fromReader;
            this.myFallbackValue = fallbackValue;
        }

        public T handleResponse(HttpResponse response) throws IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (!this.myBuilder.mySuccessChecker.test(statusCode)) {
                RequestFailedException exception;
                if (this.myBuilder.myIgnoreChecker.test(statusCode)) {
                    return (T)this.myFallbackValue.produce();
                }
                if (this.myBuilder.myErrorExtractor != null && (exception = this.myBuilder.myErrorExtractor.apply(response)) != null) {
                    throw exception;
                }
                throw RequestFailedException.forStatusCode((int)statusCode, (String)TaskResponseUtil.messageForStatusCode(statusCode));
            }
            try {
                if (LOG.isDebugEnabled()) {
                    String content = TaskResponseUtil.getResponseContentAsString(response);
                    TaskUtil.prettyFormatJsonToLog((Logger)LOG, (String)content);
                    return this.myFromString.apply(content);
                }
                return this.myFromReader.apply(TaskResponseUtil.getResponseContentAsReader(response));
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Malformed server response", (Throwable)e);
                return (T)this.myFallbackValue.produce();
            }
        }
    }

    @ApiStatus.Internal
    public static class JsonResponseHandlerBuilder {
        private final Gson myGson;
        private IntPredicate mySuccessChecker = code -> code / 100 == 2;
        private IntPredicate myIgnoreChecker = code -> false;
        private Function<HttpResponse, ? extends RequestFailedException> myErrorExtractor;

        private JsonResponseHandlerBuilder(@NotNull Gson gson) {
            this.myGson = gson;
        }

        @NotNull
        public static JsonResponseHandlerBuilder fromGson(@NotNull Gson gson) {
            return new JsonResponseHandlerBuilder(gson);
        }

        @NotNull
        public JsonResponseHandlerBuilder successCode(@NotNull IntPredicate predicate) {
            this.mySuccessChecker = predicate;
            return this;
        }

        @NotNull
        public JsonResponseHandlerBuilder ignoredCode(@NotNull IntPredicate predicate) {
            this.myIgnoreChecker = predicate;
            return this;
        }

        @NotNull
        public JsonResponseHandlerBuilder errorHandler(@NotNull Function<HttpResponse, ? extends RequestFailedException> handler) {
            this.myErrorExtractor = handler;
            return this;
        }

        @NotNull
        public <T> ResponseHandler<T> toSingleObject(@NotNull Class<T> cls) {
            return new GsonResponseHandler<Object>(this, s -> this.myGson.fromJson(s, cls), r -> this.myGson.fromJson(r, cls), () -> null);
        }

        @NotNull
        public <T> ResponseHandler<List<T>> toMultipleObjects(@NotNull TypeToken<List<T>> typeToken) {
            return new GsonResponseHandler<List<T>>(this, s -> (List)this.myGson.fromJson(s, typeToken.getType()), r -> (List)this.myGson.fromJson(r, typeToken.getType()), () -> Collections.emptyList());
        }

        @NotNull
        public ResponseHandler<Void> toNothing() {
            return new GsonResponseHandler<Void>(this, s -> null, r -> null, () -> null);
        }
    }
}

