/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskUiUtil {
    private static final Logger LOG = Logger.getInstance(TaskUiUtil.class);

    private TaskUiUtil() {
    }

    public static abstract class ComboBoxUpdater<T>
    extends RemoteFetchTask<Collection<T>> {
        protected final JComboBox<T> myComboBox;

        public ComboBoxUpdater(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String title, @NotNull JComboBox<T> comboBox) {
            super(project, title, ModalityState.any());
            this.myComboBox = comboBox;
        }

        @Nullable
        public T getExtraItem() {
            return null;
        }

        @Nullable
        public T getSelectedItem() {
            return this.getExtraItem();
        }

        protected boolean addSelectedItemIfMissing() {
            return false;
        }

        @Override
        protected void updateUI() {
            if (this.myResult != null) {
                this.myComboBox.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray((Collection)((Collection)this.myResult))));
                T extra = this.getExtraItem();
                if (extra != null) {
                    this.myComboBox.insertItemAt(extra, 0);
                }
                this.myComboBox.setSelectedItem(null);
                T selected = this.getSelectedItem();
                if (selected != null) {
                    if (!selected.equals(extra) && !((Collection)this.myResult).contains(selected)) {
                        if (this.addSelectedItemIfMissing()) {
                            this.myComboBox.addItem(selected);
                            this.myComboBox.setSelectedItem(selected);
                        } else {
                            this.selectFirstItem();
                        }
                    } else {
                        this.myComboBox.setSelectedItem(selected);
                    }
                } else {
                    this.selectFirstItem();
                }
            } else {
                this.handleError();
            }
        }

        private void selectFirstItem() {
            if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }

        protected void handleError() {
            this.myComboBox.removeAllItems();
        }
    }

    public static abstract class RemoteFetchTask<T>
    extends Task.Backgroundable {
        protected T myResult;
        protected Exception myException;
        private final ModalityState myModalityState;

        protected RemoteFetchTask(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String title) {
            this(project, title, ModalityState.current());
        }

        protected RemoteFetchTask(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String title, @NotNull ModalityState modalityState) {
            super(project, title);
            this.myModalityState = modalityState;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            try {
                this.myResult = this.fetch(indicator);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myException = e;
            }
        }

        @Nullable
        public final Task.NotificationInfo notifyFinished() {
            ApplicationManager.getApplication().invokeLater(() -> this.updateUI(), this.myModalityState);
            return null;
        }

        @NotNull
        protected abstract T fetch(@NotNull ProgressIndicator var1) throws Exception;

        protected abstract void updateUI();
    }
}

